/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.ClosureBoxContext;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.LambdaBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.GenericCaster;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.runnables.IFunctionRunnable;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Closure;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.Lambda;
import ortus.boxlang.runtime.types.NullValue;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.AbortException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.FunctionMeta;
import ortus.boxlang.runtime.util.ArgumentUtil;

public abstract class Function
implements IType,
IFunctionRunnable,
Serializable {
    public transient BoxMeta $bx;
    public static final Key ARGUMENT_COLLECTION = Key.argumentCollection;
    private Boolean canOutput = null;
    private static final long serialVersionUID = 1L;

    protected Function() {
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new FunctionMeta(this);
        }
        return this.$bx;
    }

    public ArgumentsScope createArgumentsScope(IBoxContext context, Object[] positionalArguments) {
        return ArgumentUtil.createArgumentsScope(context, positionalArguments, this.getArguments(), new ArgumentsScope(), this.getName());
    }

    public ArgumentsScope createArgumentsScope(IBoxContext context, Map<Key, Object> namedArguments) {
        return ArgumentUtil.createArgumentsScope(context, namedArguments, this.getArguments(), new ArgumentsScope(), this.getName());
    }

    public ArgumentsScope createArgumentsScope(IBoxContext context) {
        return ArgumentUtil.createArgumentsScope(context, this.getArguments(), new ArgumentsScope(), this.getName());
    }

    public Object invoke(FunctionBoxContext context) {
        InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();
        IStruct data = Struct.of(new Object[]{Key.context, context, Key.function, this});
        interceptorService.announce(BoxEvent.PRE_FUNCTION_INVOKE, data);
        Object result = null;
        context.pushTemplate(this);
        try {
            result = this.ensureReturnType(context, this._invoke(context));
            data.put(Key.result, result);
            interceptorService.announce(BoxEvent.POST_FUNCTION_INVOKE, data);
            if (this.getAccess().equals((Object)Access.REMOTE) && this.getAnnotations().containsKey(Key.returnFormat)) {
                context.getParentOfType(RequestBoxContext.class).putAttachment(Key.returnFormat, this.getAnnotations().get(Key.returnFormat).toString());
            }
        }
        catch (AbortException e) {
            if (e.isLoop().booleanValue()) {
                throw new BoxValidationException("You cannot use the 'loop' method of the exit component outside of a custom tag.");
            }
            if (e.isTemplate().booleanValue() || e.isTag().booleanValue()) {
                Object object = result;
                return object;
            }
            if (e.isRequest().booleanValue()) {
                context.flushBuffer(true);
            }
            throw e;
        }
        catch (Throwable e) {
            context.flushBuffer(true);
            throw e;
        }
        finally {
            context.popTemplate();
            context.flushBuffer(false);
        }
        return result;
    }

    protected Object ensureReturnType(IBoxContext context, Object value) {
        if (value == null) {
            return null;
        }
        CastAttempt<Object> typeCheck = GenericCaster.attempt(context, value, this.getReturnType(), true);
        if (!typeCheck.wasSuccessful()) {
            String actualType = value == null ? "null" : value.getClass().getName();
            throw new BoxRuntimeException(String.format("The return value of the function [%s] is of type [%s] does not match the declared type of [%s]", this.getName().getName(), actualType, this.getReturnType()));
        }
        if (typeCheck.get() instanceof NullValue) {
            return null;
        }
        return typeCheck.get();
    }

    public abstract Key getName();

    public abstract Argument[] getArguments();

    public abstract String getReturnType();

    public abstract IStruct getAnnotations();

    public abstract IStruct getDocumentation();

    public abstract Access getAccess();

    public List<BoxMethodDeclarationModifier> getModifiers() {
        return List.of();
    }

    public boolean hasModifier(BoxMethodDeclarationModifier modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public abstract Object _invoke(FunctionBoxContext var1);

    @Override
    public abstract long getRunnableCompileVersion();

    @Override
    public abstract LocalDateTime getRunnableCompiledOn();

    @Override
    public abstract Object getRunnableAST();

    public IStruct getMetaData() {
        Struct meta = new Struct(IStruct.TYPES.LINKED);
        if (this.getDocumentation() != null) {
            meta.putAll(this.getDocumentation());
        }
        if (this.getAnnotations() != null) {
            meta.putAll(this.getAnnotations());
        }
        meta.put(Key._NAME, (Object)this.getName().getName());
        meta.put(Key.returnType, (Object)this.getReturnType());
        meta.putIfAbsent(Key.hint, (Object)"");
        meta.putIfAbsent(Key.output, (Object)this.canOutput(null));
        meta.put(Key.access, (Object)this.getAccess().toString().toLowerCase());
        Array params = new Array();
        for (Argument argument : this.getArguments()) {
            Struct arg = new Struct(IStruct.TYPES.LINKED);
            arg.put(Key._NAME, (Object)argument.name().getName());
            arg.put(Key.required, (Object)argument.required());
            arg.put(Key.type, (Object)argument.type());
            arg.put(Key._DEFAULT, argument.defaultValue());
            if (argument.documentation() != null) {
                arg.putAll(argument.documentation());
            }
            if (argument.annotations() != null) {
                arg.putAll(argument.annotations());
            }
            arg.putIfAbsent(Key.hint, (Object)"");
            params.add(arg);
        }
        meta.put(Key.parameters, (Object)params);
        boolean isClosure = this instanceof Closure;
        meta.put(Key.closure, (Object)isClosure);
        meta.put(Key.ANONYMOUSCLOSURE, (Object)isClosure);
        boolean isLambda = this instanceof Lambda;
        meta.put(Key.lambda, (Object)isLambda);
        meta.put(Key.ANONYMOUSLAMBDA, (Object)isLambda);
        return meta;
    }

    public static FunctionBoxContext generateFunctionContext(Function function, IBoxContext parentContext, Key calledName, Object[] positionalArguments, IClassRunnable thisClass, BoxInterface thisInterface) {
        if (function instanceof Closure) {
            Closure clos = (Closure)function;
            return new ClosureBoxContext(parentContext, clos, calledName, positionalArguments);
        }
        if (function instanceof Lambda) {
            Lambda lam = (Lambda)function;
            return new LambdaBoxContext(parentContext, lam, calledName, positionalArguments);
        }
        return new FunctionBoxContext(parentContext, function, calledName, positionalArguments, thisClass).setThisInterface(thisInterface);
    }

    public static FunctionBoxContext generateFunctionContext(Function function, IBoxContext parentContext, Key calledName, Map<Key, Object> namedArguments, IClassRunnable thisClass, BoxInterface thisInterface) {
        if (function instanceof Closure) {
            Closure clos = (Closure)function;
            return new ClosureBoxContext(parentContext, clos, calledName, namedArguments);
        }
        if (function instanceof Lambda) {
            Lambda lam = (Lambda)function;
            return new LambdaBoxContext(parentContext, lam, calledName, namedArguments);
        }
        return new FunctionBoxContext(parentContext, function, calledName, namedArguments, thisClass).setThisInterface(thisInterface);
    }

    public boolean canOutput(FunctionBoxContext context) {
        Object anno;
        if (this.canOutput == null && (anno = this.getAnnotations().get(Key.output)) != null) {
            this.canOutput = BooleanCaster.cast(anno);
        }
        if (this.canOutput == null && context != null && context.isInClass()) {
            this.canOutput = context.getThisClass().canOutput();
        }
        if (this.canOutput == null) {
            this.canOutput = this.getSourceType().equals((Object)BoxSourceType.CFSCRIPT) || this.getSourceType().equals((Object)BoxSourceType.CFTEMPLATE);
        }
        return this.canOutput;
    }

    public Boolean implementsSignature(Function func) {
        if (this.getArguments().length != func.getArguments().length) {
            return false;
        }
        for (int i = 0; i < this.getArguments().length; ++i) {
            if (this.getArguments()[i].implementsSignature(func.getArguments()[i]).booleanValue()) continue;
            return false;
        }
        if (!func.getReturnType().equalsIgnoreCase("any") && !this.getReturnType().equalsIgnoreCase(func.getReturnType())) {
            return false;
        }
        return true;
    }

    public String signatureAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAccess().toString().toLowerCase());
        sb.append(" ");
        sb.append(this.getReturnType());
        sb.append(" function ");
        sb.append(this.getName().getName());
        sb.append("(");
        for (int i = 0; i < this.getArguments().length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getArguments()[i].signatureAsString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean requiresStrictArguments() {
        return false;
    }

    public static enum Access {
        PRIVATE,
        PUBLIC,
        PROTECTED,
        REMOTE,
        PACKAGE;


        public boolean isEffectivePublic() {
            return this == PUBLIC || this == REMOTE || this == PACKAGE;
        }
    }
}

