/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class FunctionalBIFAccess
extends Function {
    private static final Argument[] EMPTY_ARGUMENTS = new Argument[0];
    private static final IStruct documentation = Struct.of(new Object[]{"hint", "I am a functional wrapped BIF call."});
    private static FunctionService functionService = BoxRuntime.getInstance().getFunctionService();
    private static Map<Key, FunctionalBIFAccess> cache = new ConcurrentHashMap<Key, FunctionalBIFAccess>();
    private final Key name;
    private final String returnType = "any";

    public static FunctionalBIFAccess of(Key name) {
        return cache.computeIfAbsent(name, FunctionalBIFAccess::new);
    }

    public FunctionalBIFAccess(Key name) {
        this.name = name;
    }

    @Override
    public Key getName() {
        return this.name;
    }

    @Override
    public Argument[] getArguments() {
        return EMPTY_ARGUMENTS;
    }

    @Override
    public String getReturnType() {
        return "any";
    }

    @Override
    public IStruct getAnnotations() {
        return Struct.EMPTY;
    }

    @Override
    public IStruct getDocumentation() {
        return documentation;
    }

    @Override
    public Function.Access getAccess() {
        return Function.Access.PUBLIC;
    }

    @Override
    public Object _invoke(FunctionBoxContext context) {
        if (context.getArgumentsScope().isPositional()) {
            return functionService.getGlobalFunction(this.name).invoke((IBoxContext)context, context.getArgumentsScope().asNativeArray(), false, this.name);
        }
        return functionService.getGlobalFunction(this.name).invoke((IBoxContext)context, context.getArgumentsScope().asStruct(), false, this.name);
    }

    @Override
    public long getRunnableCompileVersion() {
        return 0L;
    }

    @Override
    public LocalDateTime getRunnableCompiledOn() {
        return null;
    }

    @Override
    public Object getRunnableAST() {
        return null;
    }

    @Override
    public List<ImportDefinition> getImports() {
        return List.of();
    }

    @Override
    public ResolvedFilePath getRunnablePath() {
        return ResolvedFilePath.of(Path.of("unknown", new String[0]));
    }

    @Override
    public BoxSourceType getSourceType() {
        return BoxSourceType.BOXSCRIPT;
    }

    @Override
    public boolean requiresStrictArguments() {
        return true;
    }
}

