/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.List;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class JavaMethod
extends Function {
    private static final Argument[] EMPTY_ARGUMENTS = new Argument[0];
    private static final IStruct DOCUMENTATION = Struct.of(new Object[]{"hint", "I am a wrapped Java method.  Since I may be overloaded, my return type and arguments will be determined when I am invoked"});
    private static final String RETURN_TYPE = "any";
    private final Key name;
    private DynamicObject dynamicObject;

    public JavaMethod(Key name, DynamicObject dynamicObject) {
        this.name = name;
        this.dynamicObject = dynamicObject;
    }

    @Override
    public Key getName() {
        return this.name;
    }

    @Override
    public Argument[] getArguments() {
        return EMPTY_ARGUMENTS;
    }

    @Override
    public String getReturnType() {
        return RETURN_TYPE;
    }

    @Override
    public IStruct getAnnotations() {
        return Struct.EMPTY;
    }

    @Override
    public IStruct getDocumentation() {
        return DOCUMENTATION;
    }

    @Override
    public Function.Access getAccess() {
        return Function.Access.PUBLIC;
    }

    @Override
    public Object _invoke(FunctionBoxContext context) {
        if (!context.getArgumentsScope().isPositional()) {
            throw new BoxValidationException("Java methods can only be called with positional arguments");
        }
        return this.dynamicObject.invoke(context, this.name.getName(), context.getArgumentsScope().asNativeArray());
    }

    @Override
    public long getRunnableCompileVersion() {
        return 0L;
    }

    @Override
    public LocalDateTime getRunnableCompiledOn() {
        return null;
    }

    @Override
    public Object getRunnableAST() {
        return null;
    }

    @Override
    public List<ImportDefinition> getImports() {
        return List.of();
    }

    @Override
    public ResolvedFilePath getRunnablePath() {
        return ResolvedFilePath.of(Path.of("unknown", new String[0]));
    }

    @Override
    public BoxSourceType getSourceType() {
        return BoxSourceType.BOXSCRIPT;
    }

    @Override
    public boolean requiresStrictArguments() {
        return true;
    }
}

