/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.QueryColumn;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.DatabaseException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.QueryMeta;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableQuery;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.util.DuplicationUtil;

public class Query
implements IType,
IReferenceable,
Collection<IStruct>,
Serializable {
    private List<Object[]> data = Collections.synchronizedList(new ArrayList());
    private Map<Key, QueryColumn> columns = Collections.synchronizedMap(new LinkedHashMap());
    public transient BoxMeta $bx;
    private transient FunctionService functionService = BoxRuntime.getInstance().getFunctionService();
    private static final long serialVersionUID = 1L;
    private IStruct metadata;

    public Query(IStruct meta) {
        this.metadata = meta == null ? new Struct(IStruct.TYPES.SORTED) : meta;
    }

    public Query() {
        this(new Struct(IStruct.TYPES.SORTED));
    }

    public static Query fromResultSet(ResultSet resultSet) {
        Query query = new Query();
        if (resultSet == null) {
            return query;
        }
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int columnCount = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                query.addColumn(Key.of(resultSetMetaData.getColumnLabel(i)), QueryColumnType.fromSQLType(resultSetMetaData.getColumnType(i)));
            }
            while (resultSet.next()) {
                Object[] row = new Object[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    row[i - 1] = resultSet.getObject(i);
                }
                query.addRow(row);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        return query;
    }

    public static Query fromArray(Array columnNames, Array columnTypes, Object rowData) {
        Query q = new Query();
        int i = 0;
        for (Object columnName : columnNames) {
            q.addColumn(Key.of(columnName), QueryColumnType.fromString((String)columnTypes.get(i)));
            ++i;
        }
        if (rowData == null) {
            return q;
        }
        q.addData(rowData);
        return q;
    }

    public Query setMetadata(IStruct meta) {
        this.metadata = meta;
        this.$bx = null;
        return this;
    }

    public Map<Key, QueryColumn> getColumns() {
        return this.columns;
    }

    public boolean hasColumns() {
        return !this.columns.isEmpty();
    }

    public boolean hasColumn(Key name) {
        return this.columns.containsKey(name);
    }

    public List<Object[]> getData() {
        return this.data;
    }

    public Query addColumn(Key name, QueryColumnType type) {
        return this.addColumn(name, type, null);
    }

    public synchronized Query addColumn(Key name, QueryColumnType type, Object[] columnData) {
        block5: {
            block4: {
                int index = -1;
                int newColIndex = this.getColumns().size();
                for (Key key : this.columns.keySet()) {
                    ++index;
                    if (!key.equals(name)) continue;
                    newColIndex = index;
                    break;
                }
                this.columns.put(name, this.createQueryColumn(name, type, newColIndex));
                if (this.data.isEmpty()) break block4;
                for (int i = 0; i < this.data.size(); ++i) {
                    Object[] row = this.data.get(i);
                    Object[] newRow = new Object[row.length + 1];
                    System.arraycopy(row, 0, newRow, 0, row.length);
                    if (columnData != null && i < columnData.length) {
                        newRow[newColIndex] = columnData[i];
                    }
                    this.data.set(i, newRow);
                }
                break block5;
            }
            if (columnData == null) break block5;
            for (Object columnDatum : columnData) {
                Object[] row = new Object[this.columns.size()];
                row[newColIndex] = columnDatum;
                this.data.add(row);
            }
        }
        return this;
    }

    protected QueryColumn createQueryColumn(Key name, QueryColumnType type, int index) {
        return new QueryColumn(name, type, this, index);
    }

    public Object[] getColumnData(Key name) {
        int index = this.getColumn(name).getIndex();
        Object[] columnData = new Object[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            columnData[i] = this.data.get(i)[index];
        }
        return columnData;
    }

    public Array getColumnDataAsArray(Key name) {
        return Array.fromArray(this.getColumnData(name));
    }

    public int getColumnIndex(Key name) {
        int index = 0;
        for (QueryColumn column : this.columns.values()) {
            if (column.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public QueryColumn getColumn(Key name) {
        QueryColumn column = this.columns.get(name);
        if (column == null) {
            throw new BoxRuntimeException("Column '" + String.valueOf(name) + "' does not exist in query");
        }
        return column;
    }

    public Object[] getRow(int index) {
        this.validateRow(index);
        return this.data.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query insertQueryAt(int position, Query target) {
        if (!target.getColumns().keySet().equals(this.getColumns().keySet())) {
            throw new BoxRuntimeException("Query columns do not match");
        }
        if (target.size() == 0) {
            return this;
        }
        Query query = this;
        synchronized (query) {
            for (int i = 0; i < target.size(); ++i) {
                this.data.add(position + i, target.getRow(i));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRow(Object[] row) {
        int newRow;
        Query query = this;
        synchronized (query) {
            this.data.add(row);
            newRow = this.data.size();
        }
        return newRow;
    }

    public int addRow(Array row) {
        return this.addRow(row.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query swapRow(int sourceRow, int destinationRow) {
        this.validateRow(sourceRow);
        this.validateRow(destinationRow);
        List<Object[]> list = this.data;
        synchronized (list) {
            Object[] temp = this.data.get(sourceRow);
            this.data.set(sourceRow, this.data.get(destinationRow));
            this.data.set(destinationRow, temp);
        }
        return this;
    }

    public int addEmptyRow() {
        return this.addRow(this.columns.keySet().stream().map(key -> null).toArray());
    }

    public int addRow(IStruct row) {
        Object[] rowData = new Object[this.columns.size()];
        int i = 0;
        for (QueryColumn column : this.columns.values()) {
            Object o = row.get(column.getName());
            rowData[i] = o == null ? "" : o;
            ++i;
        }
        return this.addRow(rowData);
    }

    public int addRows(int rows) {
        int lastRow = 0;
        for (int i = 0; i < rows; ++i) {
            lastRow = this.addRow(new Object[this.columns.size()]);
        }
        return lastRow;
    }

    public void deleteColumn(Key name) {
        QueryColumn column = this.getColumn(name);
        int index = column.getIndex();
        this.columns.remove(name);
        for (Object[] row : this.data) {
            Object[] newRow = new Object[row.length - 1];
            System.arraycopy(row, 0, newRow, 0, index);
            System.arraycopy(row, index + 1, newRow, index, row.length - index - 1);
            row = newRow;
        }
    }

    public Query deleteRow(int index) {
        this.validateRow(index);
        this.data.remove(index);
        return this;
    }

    public int addData(Object rowData) {
        CastAttempt<IStruct> structCastAttempt = StructCaster.attempt(rowData);
        if (structCastAttempt.wasSuccessful()) {
            return this.addRow(structCastAttempt.get());
        }
        CastAttempt<Array> arrayCastAttempt = ArrayCaster.attempt(rowData);
        if (arrayCastAttempt.wasSuccessful()) {
            Array arrData = arrayCastAttempt.get();
            if (arrData.isEmpty()) {
                return 0;
            }
            Boolean isArray = ArrayCaster.attempt(arrData.getFirst()).wasSuccessful();
            Boolean isStruct = StructCaster.attempt(arrData.getFirst()).wasSuccessful();
            if (isArray.booleanValue() || isStruct.booleanValue()) {
                int lastRow = 0;
                for (Object row : arrData) {
                    if (isArray.booleanValue()) {
                        lastRow = this.addRow(ArrayCaster.cast(row));
                        continue;
                    }
                    lastRow = this.addRow(StructCaster.cast(row));
                }
                return lastRow;
            }
            return this.addRow(arrData);
        }
        throw new BoxRuntimeException("rowData must be a struct, an array of structs, or an array of arrays.  " + rowData.getClass().getName() + " was passed.");
    }

    public IStruct getRowAsStruct(int index) {
        this.validateRow(index);
        Struct struct = new Struct(IStruct.TYPES.LINKED);
        Object[] row = this.data.get(index);
        int i = 0;
        for (QueryColumn column : this.columns.values()) {
            struct.put(column.getName(), row[i]);
            ++i;
        }
        return struct;
    }

    public Object getCell(Key columnName, int rowIndex) {
        this.validateRow(rowIndex);
        int columnIndex = this.getColumn(columnName).getIndex();
        return this.data.get(rowIndex)[columnIndex];
    }

    public Query setCell(Key columnName, int rowIndex, Object value) {
        this.validateRow(rowIndex);
        int columnIndex = this.getColumn(columnName).getIndex();
        this.data.get((int)rowIndex)[columnIndex] = value;
        return this;
    }

    public void validateRow(int index) {
        if (index < 0 || index >= this.data.size()) {
            throw new BoxRuntimeException("Row index " + index + " is out of bounds for query of size " + this.data.size());
        }
    }

    public int getRowFromContext(IBoxContext context) {
        return context.getQueryRow(this);
    }

    public String getColumnList() {
        return this.getColumns().keySet().stream().map(Key::getName).collect(Collectors.joining(","));
    }

    public Array getColumnArray() {
        return this.getColumns().keySet().stream().map(Key::getName).collect(BLCollector.toArray());
    }

    public void sort(Comparator<IStruct> compareFunc) {
        Stream<IStruct> sorted = this.intStream().mapToObj(index -> this.getRowAsStruct(index)).sorted(compareFunc);
        this.data = sorted.map(row -> row.getWrapped().entrySet().stream().map(entry -> entry.getValue()).toArray()).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public Iterator<IStruct> iterator() {
        return new Iterator<IStruct>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Query.this.data.size();
            }

            @Override
            public IStruct next() {
                IStruct rowData = Query.this.getRowAsStruct(this.index);
                ++this.index;
                return rowData;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    public Array toStructArray() {
        Iterator<IStruct> it = this.iterator();
        Array structArray = new Array();
        while (it.hasNext()) {
            structArray.add(it.next());
        }
        return structArray;
    }

    @Override
    public boolean add(IStruct row) {
        this.addRow(row);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends IStruct> rows) {
        for (IStruct iStruct : rows) {
            this.addRow(iStruct);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.data.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.data.retainAll(c);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public Object dereference(IBoxContext context, Key name, Boolean safe) {
        if (name.equals(BoxMeta.key)) {
            return this.getBoxMeta();
        }
        if (name.equals(Key.recordCount)) {
            return this.size();
        }
        if (name.equals(Key.columnList)) {
            return this.getColumnList();
        }
        if (name.equals(Key.currentRow)) {
            return this.getRowFromContext(context) + 1;
        }
        if (!this.hasColumn(name) && safe.booleanValue()) {
            return null;
        }
        return this.getColumn(name);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = this.functionService.getMemberMethod(name, BoxLangType.QUERY);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, positionalArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, positionalArguments);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = this.functionService.getMemberMethod(name, BoxLangType.QUERY);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, namedArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, namedArguments);
    }

    @Override
    public Object assign(IBoxContext context, Key name, Object value) {
        this.getColumn(name).setCell(this.getRowFromContext(context), value);
        return value;
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append("  ");
            sb.append(this.getRowAsStruct(i).asString());
        }
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new QueryMeta(this);
        }
        return this.$bx;
    }

    public IntStream intStream() {
        return IntStream.range(0, this.data.size());
    }

    public IStruct getMetaData() {
        this.metadata.computeIfAbsent(Key.recordCount, key -> this.data.size());
        this.metadata.computeIfAbsent(Key.columns, key -> this.getColumns());
        this.metadata.computeIfAbsent(Key.columnList, key -> this.getColumnList());
        this.metadata.computeIfAbsent(Key._HASHCODE, key -> this.hashCode());
        return this.metadata;
    }

    public Query duplicate() {
        return this.duplicate(false);
    }

    public Query duplicate(boolean deep) {
        Query q = new Query();
        this.getColumns().entrySet().stream().forEach(entry -> q.addColumn((Key)entry.getKey(), ((QueryColumn)entry.getValue()).getType()));
        if (deep) {
            q.addData(DuplicationUtil.duplicate(this.getData(), deep));
        } else {
            q.addData(this.getData());
        }
        return q;
    }

    @Override
    public int hashCode() {
        return this.computeHashCode(IType.createIdentitySetForType());
    }

    @Override
    public int computeHashCode(Set<IType> visited) {
        if (visited.contains(this)) {
            return 0;
        }
        visited.add(this);
        int result = 1;
        for (Object value : this.data.toArray()) {
            result = value instanceof IType ? 31 * result + ((IType)value).computeHashCode(visited) : 31 * result + (value == null ? 0 : value.hashCode());
        }
        return result;
    }

    public UnmodifiableQuery toUnmodifiable() {
        return new UnmodifiableQuery(this);
    }

    public Array asArrayOfStructs() {
        Array arr = new Array();
        for (int i = 0; i < this.data.size(); ++i) {
            arr.add(this.getRowAsStruct(i));
        }
        return arr;
    }

    public String toString() {
        return this.asString();
    }
}

