/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.io.Serializable;
import java.util.Map;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.Referencer;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.GenericCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.scopes.IntKey;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.GenericMeta;

public class QueryColumn
implements IReferenceable,
Serializable {
    private Key name;
    private QueryColumnType type;
    private transient Query query;
    private int index;
    public transient BoxMeta $bx;
    private static final long serialVersionUID = 1L;

    public QueryColumn(Key name, QueryColumnType type, Query query, int index) {
        this.name = name;
        this.type = type;
        this.query = query;
        this.index = index;
    }

    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new GenericMeta(this);
        }
        return this.$bx;
    }

    public Key getName() {
        return this.name;
    }

    public QueryColumnType getType() {
        return this.type;
    }

    public Query getQuery() {
        return this.query;
    }

    public int getIndex() {
        return this.index;
    }

    public QueryColumn setCell(int row, Object value) {
        this.query.validateRow(row);
        this.query.getData().get((int)row)[this.index] = value;
        return this;
    }

    public Object getCell(int row) {
        if (this.query.isEmpty()) {
            return "";
        }
        return this.query.getData().get(row)[this.index];
    }

    public Object[] getColumnData() {
        return this.query.getColumnData(this.name);
    }

    public Array getColumnDataAsArray() {
        return this.query.getColumnDataAsArray(this.name);
    }

    public static int getIntFromKey(Key key, boolean safe) {
        Integer index;
        if (key instanceof IntKey) {
            IntKey intKey = (IntKey)key;
            index = intKey.getIntValue();
        } else {
            CastAttempt<Number> indexAtt = NumberCaster.attempt(key.getName());
            if (!indexAtt.wasSuccessful()) {
                if (safe) {
                    return -1;
                }
                throw new BoxRuntimeException(String.format("Query column cannot be assigned with key %s", key.getName()));
            }
            Number dIndex = indexAtt.get();
            index = dIndex.intValue();
            if (index.doubleValue() != dIndex.doubleValue()) {
                if (safe) {
                    return -1;
                }
                throw new BoxRuntimeException(String.format("Query column index [%s] is invalid.  Index must be an integer.", dIndex));
            }
        }
        return index;
    }

    @Override
    public Object dereference(IBoxContext context, Key name, Boolean safe) {
        int index = QueryColumn.getIntFromKey(name, true);
        if (index > 0) {
            return this.getCell(index - 1);
        }
        return Referencer.get(context, this.getCell(this.query.getRowFromContext(context)), name, safe);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        return DynamicInteropService.invoke(context, this.getCell(this.query.getRowFromContext(context)), name.getName(), safe, positionalArguments);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        return DynamicInteropService.invoke(context, this.getCell(this.query.getRowFromContext(context)), name.getName(), safe, namedArguments);
    }

    @Override
    public Object assign(IBoxContext context, Key name, Object value) {
        int index = QueryColumn.getIntFromKey(name, true);
        String columnType = this.getType().toString();
        value = GenericCaster.cast(context, value, columnType);
        if (index > 0) {
            this.setCell(index - 1, value);
            return value;
        }
        Referencer.set(context, this.getCell(this.query.getRowFromContext(context)), name, value);
        return value;
    }
}

