/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

public enum QueryColumnType {
    BIGINT(-5),
    BINARY(-2),
    BIT(-7),
    CHAR(1),
    DATE(91),
    DECIMAL(3),
    DOUBLE(8),
    INTEGER(4),
    NULL(0),
    OBJECT(2000),
    OTHER(1111),
    TIME(92),
    TIMESTAMP(93),
    VARCHAR(12);

    public final int sqlType;

    private QueryColumnType(int sqlType) {
        this.sqlType = sqlType;
    }

    public static QueryColumnType fromString(String type) {
        switch (type = type.toLowerCase()) {
            case "array": 
            case "refcursor": 
            case "struct": 
            case "sqlxml": {
                return OTHER;
            }
            case "bigint": {
                return BIGINT;
            }
            case "binary": 
            case "varbinary": 
            case "longvarbinary": {
                return BINARY;
            }
            case "blob": 
            case "clob": 
            case "nclob": {
                return OBJECT;
            }
            case "bit": {
                return BIT;
            }
            case "nchar": 
            case "char": {
                return CHAR;
            }
            case "date": {
                return DATE;
            }
            case "distinct": {
                return OTHER;
            }
            case "decimal": {
                return DECIMAL;
            }
            case "real": 
            case "money": 
            case "money4": 
            case "float": 
            case "double": 
            case "numeric": {
                return DOUBLE;
            }
            case "idstamp": {
                return CHAR;
            }
            case "tinyint": 
            case "smallint": 
            case "integer": {
                return INTEGER;
            }
            case "nvarchar": 
            case "longvarchar": 
            case "longnvarchar": {
                return VARCHAR;
            }
            case "object": {
                return OBJECT;
            }
            case "other": {
                return OTHER;
            }
            case "time": {
                return TIME;
            }
            case "timestamp": {
                return TIMESTAMP;
            }
            case "varchar": 
            case "string": {
                return VARCHAR;
            }
            case "null": {
                return NULL;
            }
        }
        throw new IllegalArgumentException("Unknown QueryColumnType: " + type);
    }

    public String toString() {
        switch (this.ordinal()) {
            case 7: {
                return "integer";
            }
            case 0: {
                return "bigint";
            }
            case 6: {
                return "numeric";
            }
            case 5: {
                return "decimal";
            }
            case 3: {
                return "string";
            }
            case 13: {
                return "string";
            }
            case 1: {
                return "binary";
            }
            case 2: {
                return "bit";
            }
            case 11: {
                return "time";
            }
            case 4: {
                return "date";
            }
            case 12: {
                return "timestamp";
            }
            case 9: {
                return "object";
            }
            case 10: {
                return "other";
            }
            case 8: {
                return "null";
            }
        }
        throw new IllegalArgumentException("Unknown QueryColumnType: " + String.valueOf((Object)this));
    }

    public static QueryColumnType fromSQLType(int type) {
        switch (type) {
            case 2003: {
                return OTHER;
            }
            case -5: {
                return BIGINT;
            }
            case -2: {
                return BINARY;
            }
            case -7: {
                return BIT;
            }
            case 2004: {
                return OBJECT;
            }
            case 16: {
                return BIT;
            }
            case 1: {
                return VARCHAR;
            }
            case 2005: {
                return OBJECT;
            }
            case 70: {
                return OTHER;
            }
            case 91: {
                return DATE;
            }
            case 3: {
                return DECIMAL;
            }
            case 2001: {
                return OTHER;
            }
            case 8: {
                return DOUBLE;
            }
            case 6: {
                return DOUBLE;
            }
            case 4: {
                return INTEGER;
            }
            case 2000: {
                return OBJECT;
            }
            case -16: {
                return VARCHAR;
            }
            case -4: {
                return BINARY;
            }
            case -1: {
                return VARCHAR;
            }
            case -15: {
                return VARCHAR;
            }
            case 2011: {
                return OBJECT;
            }
            case 0: {
                return NULL;
            }
            case 2: {
                return DOUBLE;
            }
            case -9: {
                return VARCHAR;
            }
            case 1111: {
                return OTHER;
            }
            case 7: {
                return DOUBLE;
            }
            case 2006: {
                return OTHER;
            }
            case 2012: {
                return OTHER;
            }
            case -8: {
                return OTHER;
            }
            case 5: {
                return INTEGER;
            }
            case 2009: {
                return OTHER;
            }
            case 2002: {
                return OTHER;
            }
            case 92: {
                return TIME;
            }
            case 2013: {
                return TIME;
            }
            case 93: {
                return TIMESTAMP;
            }
            case 2014: {
                return TIMESTAMP;
            }
            case -6: {
                return INTEGER;
            }
            case -3: {
                return BINARY;
            }
            case 12: {
                return VARCHAR;
            }
        }
        return OTHER;
    }
}

