/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.ClassBoxContext;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.KeyCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.KeyCased;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.NullValue;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.IChangeListener;
import ortus.boxlang.runtime.types.meta.IListenable;
import ortus.boxlang.runtime.types.meta.StructMeta;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableStruct;

public class Struct
implements IStruct,
IListenable,
Serializable {
    private static final ThreadLocal<Set<Integer>> toStringObjects = ThreadLocal.withInitial(HashSet::new);
    public static final Comparator<Key> KEY_LENGTH_LONGEST_FIRST_COMPARATOR = (k1, k2) -> {
        int lengthCompare = Integer.compare(k2.getName().length(), k1.getName().length());
        if (lengthCompare != 0) {
            return lengthCompare;
        }
        return k1.getName().compareTo(k2.getName());
    };
    public static final IStruct EMPTY = new UnmodifiableStruct();
    public BoxMeta $bx;
    private final IStruct.TYPES type;
    private static final long serialVersionUID = 1L;
    protected final Map<Key, Object> wrapped;
    private Map<Key, IChangeListener> listeners;
    protected static final int INITIAL_CAPACITY = 32;

    public Struct(IStruct.TYPES type) {
        this.type = type;
        this.wrapped = switch (type) {
            case IStruct.TYPES.DEFAULT, IStruct.TYPES.CASE_SENSITIVE, IStruct.TYPES.SOFT -> new ConcurrentHashMap(32);
            case IStruct.TYPES.LINKED, IStruct.TYPES.LINKED_CASE_SENSITIVE -> Collections.synchronizedMap(new LinkedHashMap(32));
            case IStruct.TYPES.SORTED -> new ConcurrentSkipListMap();
            case IStruct.TYPES.WEAK -> new WeakHashMap(32);
            default -> throw new BoxRuntimeException("Invalid struct type [" + type.name() + "]");
        };
    }

    public Struct() {
        this(IStruct.TYPES.DEFAULT);
    }

    public Struct(Comparator<Key> comparator) {
        this.type = IStruct.TYPES.SORTED;
        this.wrapped = new ConcurrentSkipListMap<Key, Object>(comparator);
    }

    public Struct(Map<Key, Object> map, IStruct.TYPES type) {
        this.type = type;
        this.wrapped = map;
    }

    public Struct(Map<? extends Object, ? extends Object> map) {
        this(IStruct.TYPES.DEFAULT, map);
    }

    public Struct(IStruct.TYPES type, Map<? extends Object, ? extends Object> map) {
        this(type);
        this.addAll(map);
    }

    public static IStruct fromMap(Map<? extends Object, ? extends Object> map) {
        return new Struct(map);
    }

    public static IStruct fromMap(IStruct.TYPES type, Map<Object, Object> map) {
        return new Struct(type, map);
    }

    public static IStruct of(Object ... values) {
        if (values.length % 2 != 0) {
            throw new BoxRuntimeException("Invalid number of arguments.  Must be an even number.");
        }
        Struct struct = new Struct();
        for (int i = 0; i < values.length; i += 2) {
            struct.put(KeyCaster.cast(values[i]), values[i + 1]);
        }
        return struct;
    }

    public static IStruct linkedOf(Object ... values) {
        if (values.length % 2 != 0) {
            throw new BoxRuntimeException("Invalid number of arguments.  Must be an even number.");
        }
        Struct struct = new Struct(IStruct.TYPES.LINKED);
        for (int i = 0; i < values.length; i += 2) {
            struct.put(KeyCaster.cast(values[i]), values[i + 1]);
        }
        return struct;
    }

    public static IStruct sortedOf(Comparator<Key> comparator, Object ... values) {
        if (values.length % 2 != 0) {
            throw new BoxRuntimeException("Invalid number of arguments.  Must be an even number.");
        }
        Struct struct = comparator == null ? new Struct(IStruct.TYPES.SORTED) : new Struct(comparator);
        for (int i = 0; i < values.length; i += 2) {
            struct.put(KeyCaster.cast(values[i]), values[i + 1]);
        }
        return struct;
    }

    public static IStruct sortedOf(Comparator<Key> comparator, Map<Key, Object> map) {
        Struct struct = comparator == null ? new Struct(IStruct.TYPES.SORTED) : new Struct(comparator);
        struct.putAll(map);
        return struct;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Key key) {
        return this.isCaseSensitive() != false ? this.keySet().stream().anyMatch(match -> match.equalsWithCase(key)) : this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Key) {
            Key keyKey = (Key)key;
            return this.containsKey(keyKey);
        }
        if (key instanceof String) {
            String stringKey = (String)key;
            return this.containsKey(stringKey);
        }
        return this.containsKey(Key.of(StringCaster.cast(key)));
    }

    @Override
    public boolean containsKey(String key) {
        return this.containsKey(Key.of(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (key instanceof Key) {
            Key keyKey = (Key)key;
            return Struct.unWrapNull(this.isCaseSensitive() != false ? this.wrapped.get(this.keySet().stream().filter(k -> KeyCaster.cast(k).equalsWithCase(keyKey)).findFirst().orElse(Key.EMPTY)) : this.wrapped.get(keyKey));
        }
        if (key instanceof String) {
            String stringKey = (String)key;
            return this.get(stringKey);
        }
        return this.get(StringCaster.cast(key));
    }

    @Override
    public Object get(String key) {
        Key keyObj = Key.of(key);
        return Struct.unWrapNull(this.isCaseSensitive() != false ? this.wrapped.get(this.keySet().stream().filter(k -> KeyCaster.cast(k).equalsWithCase(keyObj)).findFirst().orElse(Key.EMPTY)) : this.wrapped.get(keyObj));
    }

    @Override
    public Object getOrDefault(Key key, Object defaultValue) {
        return this.isCaseSensitive() != false ? Struct.unWrapNull(this.wrapped.getOrDefault(this.keySet().stream().filter(k -> KeyCaster.cast(k).equalsWithCase(key)).findFirst().orElse(Key.EMPTY), defaultValue)) : Struct.unWrapNull(this.wrapped.getOrDefault(key, defaultValue));
    }

    @Override
    public Object getOrDefault(String key, Object defaultValue) {
        return this.getOrDefault(Key.of(key), defaultValue);
    }

    @Override
    public Object getRaw(Key key) {
        return this.isCaseSensitive() != false ? this.wrapped.get(this.keySet().stream().filter(k -> KeyCaster.cast(k).equalsWithCase(key)).findFirst().orElse(Key.EMPTY)) : this.wrapped.get(key);
    }

    @Override
    public Object put(Key key, Object value) {
        return this.wrapped.put(this.isCaseSensitive() != false && !(key instanceof KeyCased) ? new KeyCased(key.getName()) : key, this.notifyListeners(key, this.wrapNull(value)));
    }

    @Override
    public Object put(String key, Object value) {
        return this.put(this.isCaseSensitive() != false ? KeyCased.of(key) : Key.of(key), value);
    }

    @Override
    public Object putIfAbsent(Key key, Object value) {
        if (!this.containsKey(key)) {
            return this.wrapped.putIfAbsent(this.isCaseSensitive() != false && !(key instanceof KeyCased) ? new KeyCased(key.getName()) : key, this.notifyListeners(key, this.wrapNull(value)));
        }
        return null;
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        return this.putIfAbsent(Key.of(key), value);
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof Key) {
            Key keyKey = (Key)key;
            return this.remove(keyKey);
        }
        if (key instanceof String) {
            String stringKey = (String)key;
            return this.remove(stringKey);
        }
        return this.remove(Key.of(StringCaster.cast(key)));
    }

    @Override
    public Object remove(String key) {
        return this.remove(Key.of(key));
    }

    @Override
    public Object remove(Key key) {
        this.notifyListeners(key, null);
        return this.isCaseSensitive() != false ? this.wrapped.remove(this.keySet().stream().filter(k -> KeyCaster.cast(k).equalsWithCase(key)).findFirst().orElse(Key.EMPTY)) : this.wrapped.remove(key);
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Object> map) {
        Stream<Map.Entry> entryStream = map.size() > 1000 ? map.entrySet().parallelStream().map(entry -> entry) : map.entrySet().stream().map(entry -> entry);
        if (this.type.equals((Object)IStruct.TYPES.LINKED)) {
            entryStream.forEachOrdered(entry -> this.wrapped.put((Key)entry.getKey(), entry.getValue() == null ? new NullValue() : entry.getValue()));
        } else {
            entryStream.forEach((? super T entry) -> this.wrapped.put((Key)entry.getKey(), entry.getValue() == null ? new NullValue() : entry.getValue()));
        }
    }

    @Override
    public void addAll(Map<? extends Object, ? extends Object> map) {
        Stream<Map.Entry> entryStream = map.size() > 1000 ? map.entrySet().parallelStream().map(entry -> entry) : map.entrySet().stream().map(entry -> entry);
        if (this.type.equals((Object)IStruct.TYPES.LINKED)) {
            entryStream.forEachOrdered(entry -> {
                Key entryKey;
                Object patt0$temp = entry.getKey();
                Key key = patt0$temp instanceof Key ? (entryKey = (Key)patt0$temp) : Key.of(entry.getKey().toString());
                this.wrapped.put(key, entry.getValue() == null ? new NullValue() : entry.getValue());
            });
        } else {
            entryStream.forEach((? super T entry) -> {
                Key entryKey;
                Object patt0$temp = entry.getKey();
                Key key = patt0$temp instanceof Key ? (entryKey = (Key)patt0$temp) : Key.of(entry.getKey().toString());
                this.wrapped.put(key, entry.getValue() == null ? new NullValue() : entry.getValue());
            });
        }
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public Set<Key> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.wrapped.values().stream().map(entry -> Struct.unWrapNull(entry)).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<Key, Object>> entrySet() {
        return this.wrapped.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<Key, Object>((Key)entry.getKey(), Struct.unWrapNull(entry.getValue()))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public boolean equals(Object obj) {
        boolean bl;
        if (obj instanceof IStruct) {
            IStruct struct = (IStruct)obj;
            bl = this.wrapped.equals(struct.getWrapped());
        } else {
            bl = this.wrapped.equals(obj);
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.computeHashCode(IType.createIdentitySetForType());
    }

    @Override
    public int computeHashCode(Set<IType> visited) {
        if (visited.contains(this)) {
            return 0;
        }
        visited.add(this);
        int result = 1;
        for (Map.Entry<Key, Object> entry : this.wrapped.entrySet()) {
            result = 31 * result + (entry.getKey() == null ? 0 : entry.getKey().hashCode());
            Object value = entry.getValue();
            if (value instanceof IType) {
                result = 31 * result + ((IType)value).computeHashCode(visited);
                continue;
            }
            result = 31 * result + (value == null ? 0 : value.hashCode());
        }
        return result;
    }

    public String toString() {
        return this.asString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asString() {
        Integer thisHashCode;
        Set<Integer> stringed = toStringObjects.get();
        if (!stringed.add(thisHashCode = Integer.valueOf(System.identityHashCode(this)))) {
            return "<recursive reference " + thisHashCode + ">";
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.size() > 0 ? "{\n" : "{");
            sb.append(this.wrapped.entrySet().stream().map(entry -> {
                String line = ((Key)entry.getKey()).getName() + " : ";
                Object patt0$temp = entry.getValue();
                if (patt0$temp instanceof IType) {
                    IType t = (IType)patt0$temp;
                    line = line + t.asString();
                } else {
                    Object patt1$temp = entry.getValue();
                    if (patt1$temp instanceof String) {
                        String s = (String)patt1$temp;
                        line = line + "\"" + s.replace("\"", "\\\"") + "\"";
                    } else {
                        line = line + entry.getValue().toString();
                    }
                }
                return line;
            }).map(line -> line.replaceAll("(?m)^", "  ")).collect(Collectors.joining(",\n")));
            sb.append(this.size() > 0 ? "\n}" : "}");
            String string = sb.toString();
            return string;
        }
        finally {
            stringed.remove(thisHashCode);
        }
    }

    @Override
    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new StructMeta(this);
        }
        return this.$bx;
    }

    @Override
    public IStruct.TYPES getType() {
        return this.type;
    }

    @Override
    public Boolean isCaseSensitive() {
        return this.type.equals((Object)IStruct.TYPES.CASE_SENSITIVE) || this.type.equals((Object)IStruct.TYPES.LINKED_CASE_SENSITIVE);
    }

    @Override
    public Boolean isSoftReferenced() {
        return this.type.equals((Object)IStruct.TYPES.SOFT);
    }

    public UnmodifiableStruct toUnmodifiable() {
        return new UnmodifiableStruct(this);
    }

    @Override
    public Object assign(IBoxContext context, Key key, Object value) {
        this.put(key, value);
        return value;
    }

    @Override
    public Object dereference(IBoxContext context, Key key, Boolean safe) {
        if (key.equals(BoxMeta.key)) {
            return this.getBoxMeta();
        }
        Object value = this.getRaw(key);
        if (value == null && !safe.booleanValue()) {
            throw new KeyNotFoundException(String.format("The key [%s] was not found in the struct. Valid keys are (%s)", key.getName(), this.getKeysAsStrings()), this);
        }
        return Struct.unWrapNull(value);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = BoxRuntime.getInstance().getFunctionService().getMemberMethod(name, BoxLangType.STRUCT);
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof Function) {
                Function function = (Function)value;
                FunctionBoxContext fContext = Function.generateFunctionContext(function, context.getFunctionParentContext(), name, positionalArguments, this.getFunctionContextThisClassForInvoke(context), this.getFunctionContextThisInterfaceForInvoke());
                return function.invoke(fContext);
            }
            if (memberDescriptor == null) {
                throw new BoxRuntimeException("key '" + name.getName() + "' of type  '" + value.getClass().getName() + "'  is not a function ");
            }
        }
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, positionalArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, positionalArguments);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = BoxRuntime.getInstance().getFunctionService().getMemberMethod(name, BoxLangType.STRUCT);
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof Function) {
                Function function = (Function)value;
                FunctionBoxContext fContext = Function.generateFunctionContext(function, context.getFunctionParentContext(), name, namedArguments, this.getFunctionContextThisClassForInvoke(context), this.getFunctionContextThisInterfaceForInvoke());
                return function.invoke(fContext);
            }
            if (memberDescriptor == null) {
                throw new BoxRuntimeException("key '" + name.getName() + "' of type  '" + value.getClass().getName() + "'  is not a function ");
            }
        }
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, namedArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, namedArguments);
    }

    public IClassRunnable getFunctionContextThisClassForInvoke(IBoxContext context) {
        if (context instanceof ClassBoxContext) {
            ClassBoxContext cContext = (ClassBoxContext)context;
            return cContext.getThisClass();
        }
        if (context instanceof FunctionBoxContext) {
            FunctionBoxContext fContext = (FunctionBoxContext)context;
            return fContext.getThisClass();
        }
        return null;
    }

    public BoxInterface getFunctionContextThisInterfaceForInvoke() {
        return null;
    }

    public Object wrapNull(Object value) {
        if (value == null) {
            return new NullValue();
        }
        return this.wrapAssignment(value);
    }

    public Object wrapAssignment(Object value) {
        return this.isSoftReferenced() != false ? new SoftReference<Object>(value) : value;
    }

    @Override
    public List<Key> getKeys() {
        return this.keySet().stream().collect(Collectors.toList());
    }

    @Override
    public List<String> getKeysAsStrings() {
        return this.keySet().stream().map(Key::getName).collect(Collectors.toList());
    }

    public static Object unWrapNull(Object value) {
        if (value instanceof NullValue) {
            return null;
        }
        return value instanceof SoftReference ? ((SoftReference)value).get() : value;
    }

    @Override
    public Map<? extends Object, Object> getWrapped() {
        return this.wrapped;
    }

    @Override
    public void registerChangeListener(IChangeListener listener) {
        this.initListeners();
        this.listeners.put(IListenable.ALL_KEYS, listener);
    }

    @Override
    public void registerChangeListener(Key key, IChangeListener listener) {
        this.initListeners();
        this.listeners.put(key, listener);
    }

    @Override
    public void removeChangeListener(Key key) {
        this.initListeners();
        this.listeners.remove(key);
    }

    private Object notifyListeners(Key key, Object value) {
        if (this.listeners == null) {
            return value;
        }
        IChangeListener listener = this.listeners.get(key);
        if (listener == null) {
            listener = this.listeners.get(IListenable.ALL_KEYS);
        }
        if (listener == null) {
            return value;
        }
        return listener.notify(key, value, this.wrapped.get(key));
    }

    private void initListeners() {
        if (this.listeners == null) {
            this.listeners = new ConcurrentHashMap<Key, IChangeListener>();
        }
    }
}

