/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.KeyCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.scopes.IntKey;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.listeners.XMLChildrenListener;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.GenericMeta;
import ortus.boxlang.runtime.types.util.ListUtil;

public class XML
implements Serializable,
IStruct {
    private Node node;
    public BoxMeta $bx;
    private final IStruct.TYPES type;
    private static FunctionService functionService = BoxRuntime.getInstance().getFunctionService();
    private static final Set<Key> documentOnlyKeys = Set.of(Key.XMLRoot, Key.XMLDocType);
    private static final Set<Key> elementOnlyKeys = Set.of(Key.XMLText, Key.XMLCdata, Key.XMLAttributes, Key.XMLChildren, Key.XMLParent, Key.XMLNodes, Key.XMLNsPrefix, Key.XMLNsURI);
    private static final long serialVersionUID = 1L;

    public XML(String xmlData) {
        DocumentBuilder builder;
        this.type = IStruct.TYPES.DEFAULT;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new BoxRuntimeException("Error creating XML document builder", e);
        }
        InputSource inputSource = new InputSource(new StringReader(xmlData));
        try {
            this.node = builder.parse(inputSource);
        }
        catch (SAXException e) {
            throw new BoxRuntimeException("Error parsing XML document", e);
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error parsing XML document", e);
        }
    }

    public XML(Node node) {
        this.type = IStruct.TYPES.DEFAULT;
        this.node = node;
    }

    public XML(Boolean caseSenstive) {
        this.type = caseSenstive != false ? IStruct.TYPES.CASE_SENSITIVE : IStruct.TYPES.DEFAULT;
    }

    public String getXMLText() {
        StringBuilder sb = new StringBuilder();
        NodeList children = this.node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString();
    }

    public List<XML> getXMLChildrenAsList() {
        ArrayList<XML> children = new ArrayList<XML>();
        if (this.node != null) {
            NodeList childNodes = this.node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                children.add(new XML(child));
            }
        }
        return children;
    }

    public Array getXMLChildren() {
        XMLChildrenListener childrenListener = new XMLChildrenListener(this);
        Array childArray = new Array(this.getXMLChildrenAsList());
        childArray.registerChangeListener(childrenListener);
        return childArray;
    }

    public Array getXMLNodes() {
        Array children = new Array();
        NodeList childNodes = this.node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 2) continue;
            children.add(new XML(child));
        }
        return children;
    }

    public String getNodeComments() {
        StringBuilder comments = new StringBuilder();
        NodeList children = this.node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 8) continue;
            comments.append(child.getNodeValue());
        }
        return comments.toString();
    }

    public IStruct getXMLAttributes() {
        Struct attributes = new Struct(IStruct.TYPES.LINKED);
        NamedNodeMap attrs = this.node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            attributes.put(Key.of(attr.getNodeName()), (Object)attr.getNodeValue());
        }
        return attributes;
    }

    public String getXMLName() {
        switch (this.node.getNodeType()) {
            case 9: {
                return "#document";
            }
            case 11: {
                return "#document-fragment";
            }
            case 1: {
                return this.node.getNodeName();
            }
            case 3: {
                return "#text";
            }
            case 4: {
                return "#cdata-section";
            }
            case 8: {
                return "#comment";
            }
            case 10: {
                return ((DocumentType)this.node).getName();
            }
            case 5: {
                return ((EntityReference)this.node).getNodeName();
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getData();
            }
            case 6: {
                return ((Entity)this.node).getNodeName();
            }
            case 12: {
                return ((Notation)this.node).getNodeName();
            }
        }
        return "";
    }

    public String getXMLValue() {
        switch (this.node.getNodeType()) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "";
            }
            case 3: 
            case 4: 
            case 8: {
                return this.node.getTextContent();
            }
        }
        return "";
    }

    public String getXMLType() {
        switch (this.node.getNodeType()) {
            case 1: {
                return "ELEMENT";
            }
            case 2: {
                return "ATTRIBUTE";
            }
            case 3: {
                return "TEXT";
            }
            case 4: {
                return "CDATA SECTION";
            }
            case 5: {
                return "ENTITY REFERENCE";
            }
            case 6: {
                return "ENTITY";
            }
            case 7: {
                return "PROCESSING INSTRUCTION";
            }
            case 8: {
                return "COMMENT";
            }
            case 9: {
                return "DOCUMENT";
            }
            case 10: {
                return "DOCUMENT TYPE";
            }
            case 11: {
                return "DOCUMENT FRAGMENT";
            }
            case 12: {
                return "NOTATION";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public Object dereference(IBoxContext context, Key name, Boolean safe) {
        int index;
        if (name.equals(BoxMeta.key)) {
            return this.getBoxMeta();
        }
        if (name.equals(Key.XMLName)) {
            return this.getXMLName();
        }
        if (name.equals(Key.XMLType)) {
            return this.getXMLType();
        }
        if (name.equals(Key.XMLValue)) {
            return this.getXMLValue();
        }
        if (this.node.getNodeType() == 9) {
            Document document = (Document)this.node;
            if (name.equals(Key.XMLRoot)) {
                return new XML(document.getDocumentElement());
            }
            if (name.equals(Key.XMLComment)) {
                return this.getNodeComments();
            }
            if (name.equals(Key.XMLDocType)) {
                return new XML(document.getDoctype());
            }
        } else if (documentOnlyKeys.contains(name)) {
            throw new KeyNotFoundException("Key [" + name.getName() + "] can only be use with an Document node, but you have a [" + this.getXMLType() + "] node here.");
        }
        if (this.node.getNodeType() == 1) {
            String result;
            if (name.equals(Key.XMLText) || name.equals(Key.XMLCdata)) {
                return this.getXMLText();
            }
            if (name.equals(Key.XMLChildren)) {
                return this.getXMLChildren();
            }
            if (name.equals(Key.XMLParent)) {
                return new XML(this.node.getParentNode());
            }
            if (name.equals(Key.XMLNodes)) {
                return this.getXMLNodes();
            }
            if (name.equals(Key.XMLAttributes)) {
                return this.getXMLAttributes();
            }
            if (name.equals(Key.XMLNsPrefix)) {
                result = this.node.getPrefix();
                return result == null ? "" : result;
            }
            if (name.equals(Key.XMLNsURI)) {
                result = this.node.getNamespaceURI();
                return result == null ? "" : result;
            }
            if (name.equals(Key.XMLComment)) {
                return this.getNodeComments();
            }
        } else if (elementOnlyKeys.contains(name)) {
            throw new KeyNotFoundException("Key [" + name.getName() + "] can only be use with an Element node, but you have a [" + this.getXMLType() + "] node here.");
        }
        if (this.node.getNodeType() == 1 && (index = XML.getIntFromKey(name)) > 0) {
            return this.getSiblingAtPosition(index - 1);
        }
        XML child = this.getFirstChildOfName(name.getName());
        if (child != null) {
            return child;
        }
        if (safe.booleanValue()) {
            return null;
        }
        throw new KeyNotFoundException("Key [" + name.getName() + "] not found in XML node.");
    }

    public XML getFirstChildOfName(String childName) {
        NodeList children = this.node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase(childName)) continue;
            return new XML(child);
        }
        return null;
    }

    public XML getSiblingAtPosition(int index) {
        String ourName = this.node.getNodeName();
        int currMatch = -1;
        NodeList children = this.node.getParentNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase(ourName) || ++currMatch != index) continue;
            return new XML(child);
        }
        throw new KeyNotFoundException("Index [" + index + "] out of bounds for child [" + ourName + "] XML nodes.  There were only " + currMatch + " children.");
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = functionService.getMemberMethod(name, BoxLangType.XML);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, positionalArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, positionalArguments);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        MemberDescriptor memberDescriptor = functionService.getMemberMethod(name, BoxLangType.XML);
        if (memberDescriptor != null) {
            return memberDescriptor.invoke(context, (Object)this, namedArguments);
        }
        return DynamicInteropService.invoke(context, this, name.getName(), safe, namedArguments);
    }

    @Override
    public Object assign(IBoxContext context, Key name, Object value) {
        this.put(name, value);
        return this;
    }

    public String asString(IStruct transformerOptions) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            for (Map.Entry<Key, Object> entry : transformerOptions.entrySet()) {
                transformer.setOutputProperty(entry.getKey().getName(), entry.getValue().toString());
            }
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(this.node), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new BoxRuntimeException("Error converting XML node to string", e);
        }
    }

    @Override
    public String asString() {
        return this.asString(Struct.of(new Object[]{"omit-xml-declaration", "no", "method", "xml", "indent", "yes"}));
    }

    @Override
    public BoxMeta getBoxMeta() {
        if (this.$bx == null) {
            this.$bx = new GenericMeta(this);
        }
        return this.$bx;
    }

    public Node getNode() {
        return this.node;
    }

    public static int getIntFromKey(Key key) {
        Integer index;
        if (key instanceof IntKey) {
            IntKey intKey = (IntKey)key;
            index = intKey.getIntValue();
        } else {
            CastAttempt<Number> indexAtt = NumberCaster.attempt(key.getName());
            if (!indexAtt.wasSuccessful()) {
                return -1;
            }
            Number dIndex = indexAtt.get();
            index = dIndex.intValue();
            if (index.doubleValue() != dIndex.doubleValue()) {
                return -1;
            }
        }
        return index;
    }

    @Override
    public Object get(String key) {
        return this.getRaw(KeyCaster.cast(key));
    }

    @Override
    public Object get(Object key) {
        return this.getRaw(KeyCaster.cast(key));
    }

    @Override
    public Object getRaw(Key key) {
        return this.getFirstChildOfName(key.getName());
    }

    @Override
    public Object remove(String key) {
        return this.remove(KeyCaster.cast(key));
    }

    @Override
    public int size() {
        return this.getXMLChildrenAsList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getXMLChildrenAsList().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getFirstChildOfName(KeyCaster.cast(key).getName()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getXMLChildrenAsList().contains(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object put(Key key, Object value) {
        if (!(value instanceof Node)) {
            throw new BoxRuntimeException(String.format("The value passed [%s] is not a Node instance", value.toString()));
        }
        value = ((Node)value).cloneNode(true);
        if (documentOnlyKeys.contains(key)) {
            if (!key.equals(Key.XMLRoot)) throw new BoxRuntimeException(String.format("XML documents do not yet implement a setter for the key [%s]", key.getName()));
            this.node = (Node)value;
            return this;
        } else {
            Array keyArray = ListUtil.asList(key.getName(), ".");
            keyArray.remove(keyArray.size() - 1);
            if (keyArray.size() == 0) {
                this.node.appendChild((Node)value);
                return this;
            } else {
                String parent = ListUtil.asString(keyArray, ".");
                if (Key.of(parent).equals(Key.XMLRoot)) {
                    this.node.appendChild((Node)value);
                    return this;
                } else {
                    ((Node)((Object)this.getFirstChildOfName(parent))).appendChild((Node)value);
                }
            }
        }
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.remove(KeyCaster.cast(key));
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Object> m) {
        throw new UnsupportedOperationException("XML modification not implemented yet");
    }

    @Override
    public void clear() {
        this.node = null;
    }

    @Override
    public Set<Key> keySet() {
        return this.getXMLChildrenAsList().stream().map(XML::getXMLName).map(Key::of).collect(Collectors.toSet());
    }

    @Override
    public Collection<Object> values() {
        return this.getXMLChildrenAsList().stream().collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<Key, Object>> entrySet() {
        return this.getXMLChildrenAsList().stream().map(xml -> Map.entry(Key.of(xml.getXMLName()), xml)).collect(Collectors.toSet());
    }

    @Override
    public Boolean isSoftReferenced() {
        return false;
    }

    @Override
    public List<String> getKeysAsStrings() {
        return this.getXMLChildrenAsList().stream().map(XML::getXMLName).collect(Collectors.toList());
    }

    @Override
    public void addAll(Map<? extends Object, ? extends Object> m) {
        throw new UnsupportedOperationException("XML modification not implemented yet");
    }

    @Override
    public Object getOrDefault(String key, Object defaultValue) {
        return this.getOrDefault(KeyCaster.cast(key), defaultValue);
    }

    @Override
    public Object getOrDefault(Key key, Object defaultValue) {
        Object res = this.get(key);
        if (res == null) {
            return defaultValue;
        }
        return res;
    }

    @Override
    public boolean containsKey(String key) {
        return this.getFirstChildOfName(key) != null;
    }

    @Override
    public boolean containsKey(Key key) {
        return this.containsKey(key.getName());
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("XML modification not implemented yet");
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public IStruct.TYPES getType() {
        return IStruct.TYPES.DEFAULT;
    }

    @Override
    public Boolean isCaseSensitive() {
        return this.type.equals((Object)IStruct.TYPES.CASE_SENSITIVE);
    }

    public Map<Key, Object> getWrapped() {
        throw new UnsupportedOperationException("XML nodes don't support getting the wrapped Map.  Even though they behave like a struct, they really aren't one.");
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        throw new UnsupportedOperationException("XML modification not implemented yet");
    }

    @Override
    public Object putIfAbsent(Key key, Object value) {
        throw new UnsupportedOperationException("XML modification not implemented yet");
    }

    @Override
    public List<Key> getKeys() {
        return this.keySet().stream().collect(Collectors.toList());
    }

    @Override
    public Object remove(Key key) {
        Node parentNode = ((Node)((Object)this.getFirstChildOfName(key.getName()))).getParentNode();
        NodeList childNodes = parentNode.getChildNodes();
        IntStream.range(1, parentNode.getChildNodes().getLength()).mapToObj(idx -> childNodes.item(idx - 1)).filter(node -> this.isCaseSensitive().booleanValue() ? node.getNodeName() == key.getName() : key.equals(Key.of(key.getName()))).forEach((? super T node) -> parentNode.removeChild((Node)node));
        return this;
    }
}

