/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.exceptions;

import java.io.IOException;
import java.nio.file.FileSystemException;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class BoxIOException
extends BoxRuntimeException {
    public static final Key ErrorCodeKey = Key.errorcode;
    private static final String ACCESS_DENIED = "AccessDeniedException";
    private static final String ATOMIC_MOVE_DENIED = "AtomicMoveNotSupportedException";
    private static final String FILE_ALREADY_EXISTS = "FileAlreadyExistsException";
    private static final String FILE_NOT_FOUND = "FileNotFoundException";
    private static final String DIRECTORY_NOT_EMPTY = "DirectoryNotEmptyException";
    private static final String CLOSED_CHANNEL = "ClosedChannelException";
    private static final String INTERRUPTED = "InterruptedIOException";
    private static final String INTERRUPTED_BY_TIMEOUT = "InterruptedByTimeoutException";
    private static final String NO_SUCH_FILE = "NoSuchFileException";
    private static final String NOT_DIRECTORY = "NotDirectoryException";
    private static final String EOF = "EOFException";
    private static final String FILE_LOCK_INTERRUPTED = "FileLockInterruptionException";
    public String errorCode = "";

    public BoxIOException(IOException exception) {
        this(BoxIOException.parseExceptionMessage(exception), exception);
    }

    public BoxIOException(String message, IOException exception) {
        super(message, exception);
    }

    private static String parseExceptionMessage(IOException exception) {
        String exceptionType = exception.getClass().getSimpleName();
        String suspectedFile = exception.getMessage();
        FileSystemException fileException = null;
        switch (exceptionType) {
            case "AccessDeniedException": {
                fileException = (FileSystemException)exception;
                suspectedFile = fileException.getFile();
                return "Access was denied to the file [" + suspectedFile + "].";
            }
            case "AtomicMoveNotSupportedException": {
                return "Atomic move operation on [" + suspectedFile + "] failed. The cause was:" + String.valueOf(exception.getCause());
            }
            case "EOFException": {
                return "An end of file or end of stream has been reached unexpectedly on file [" + suspectedFile + "]";
            }
            case "FileLockInterruptionException": {
                return "A file lock exception occurred on file [" + suspectedFile + "] while another thread was waiting to acquire a file lock";
            }
            case "FileAlreadyExistsException": {
                fileException = (FileSystemException)exception;
                suspectedFile = fileException.getFile();
                return "The file [" + suspectedFile + "] already exists.";
            }
            case "FileNotFoundException": {
                return "The file [" + suspectedFile + "] could not be found or does not exist.";
            }
            case "NoSuchFileException": {
                fileException = (FileSystemException)exception;
                suspectedFile = fileException.getFile();
                return "The file [" + suspectedFile + "] could not be found or does not exist.";
            }
            case "NotDirectoryException": {
                fileException = (FileSystemException)exception;
                suspectedFile = fileException.getFile();
                return "The file [" + suspectedFile + "] is not a directory.";
            }
            case "DirectoryNotEmptyException": {
                return "The directory [" + suspectedFile + "] is not empty.";
            }
            case "ClosedChannelException": {
                return "Could not perform the requested operation on the file [" + suspectedFile + "]. The channel is closed.";
            }
            case "InterruptedIOException": {
                return "Operation failed on the file [" + suspectedFile + "]. The request was interrupted.";
            }
            case "InterruptedByTimeoutException": {
                return "Operation failed on file [" + suspectedFile + "]. A timeout occurred.";
            }
        }
        return "An unknown exception occurred" + exception.getMessage() + ": " + String.valueOf(exception.getCause());
    }
}

