/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.exceptions;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import ortus.boxlang.compiler.DiskClassUtil;
import ortus.boxlang.compiler.IBoxpiler;
import ortus.boxlang.compiler.SourceMap;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.javaboxpiler.JavaBoxpiler;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ThrowableCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.operators.InstanceOf;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxLangException;
import ortus.boxlang.runtime.types.exceptions.CustomException;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;
import ortus.boxlang.runtime.types.exceptions.ParseException;

public class ExceptionUtil {
    public static Boolean exceptionIsOfType(IBoxContext context, Throwable e, String type) {
        if (type.equalsIgnoreCase("any")) {
            return true;
        }
        if (e instanceof BoxLangException) {
            BoxLangException ble = (BoxLangException)e;
            if (ble.type.equalsIgnoreCase(type) || ble.type.toLowerCase().startsWith(type + ".")) {
                return true;
            }
        }
        if (InstanceOf.invoke(context, e, type).booleanValue()) {
            return true;
        }
        return false;
    }

    public static void throwException(Object exception) {
        Object ex = DynamicObject.unWrap(exception);
        if (ex instanceof String) {
            String string = (String)ex;
            throw new CustomException(string);
        }
        Throwable t = ThrowableCaster.cast(ex);
        if (t instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)t;
            throw runtimeException;
        }
        throw new CustomException(t.getMessage(), t);
    }

    public static void printBoxLangStackTrace(Throwable e, PrintStream out) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Array tagContext = ExceptionUtil.buildTagContext(e);
        StackTraceElement[] elements = e.getStackTrace();
        pw.println(e.getClass().getName() + ": " + e.getMessage());
        int i = 0;
        while (i < elements.length) {
            int j = i++;
            tagContext.stream().filter(tc -> {
                Struct context = (Struct)tc;
                return context.containsKey(Key.depth) && context.getAsInteger(Key.depth) == j;
            }).findFirst().ifPresentOrElse(tc -> {
                Struct context = (Struct)tc;
                pw.println("\t" + context.getAsString(Key.template) + ":" + String.valueOf(context.get(Key.line)));
            }, () -> pw.println("\t" + elements[j].toString()));
        }
        out.println(sw.toString());
    }

    public static Array buildTagContext(Throwable e, int depth) {
        Array tagContext = new Array();
        boolean isInComponent = false;
        String skipNext = "";
        boolean argumentDefaultValue = false;
        int i = -1;
        LinkedHashMap<Throwable, StackTraceElement[]> stacks = ExceptionUtil.getMergedStackTrace2(e);
        for (Map.Entry<Throwable, StackTraceElement[]> stack : stacks.entrySet()) {
            Array thisTagContext = new Array();
            Throwable cause = stack.getKey();
            for (StackTraceElement element : stack.getValue()) {
                String fileName;
                argumentDefaultValue = false;
                if (++i < cause.getStackTrace().length - 1 && cause.getStackTrace()[i + 1].toString().contains("ortus.boxlang.runtime.types.Argument.getDefaultValue")) {
                    argumentDefaultValue = true;
                }
                if (((fileName = element.toString()).contains("$cf") || fileName.contains("$bx")) && (fileName.contains("._pseudoConstructor(") || fileName.contains("._invoke(") || (isInComponent = fileName.contains(".lambda$_invoke$")) || argumentDefaultValue)) {
                    if (!skipNext.isEmpty()) {
                        if (fileName.startsWith(skipNext)) continue;
                        skipNext = "";
                    }
                    if (isInComponent) {
                        skipNext = fileName.substring(0, fileName.indexOf(".lambda$_invoke$"));
                    }
                    int lineNo = -1;
                    String BLFileName = element.getClassName();
                    SourceMap sourceMap = JavaBoxpiler.getInstance().getSourceMapFromFQN(IBoxpiler.getBaseFQN(element.getClassName()));
                    if (sourceMap != null) {
                        lineNo = sourceMap.convertJavaLineToSourceLine(element.getLineNumber());
                        BLFileName = sourceMap.getSource();
                    }
                    Object id = "";
                    Matcher m = Pattern.compile(".*\\$Func_(.*)$").matcher(element.getClassName());
                    if (m.find()) {
                        id = m.group(1) + "()";
                    }
                    thisTagContext.add(Struct.of(new Object[]{Key.codePrintHTML, ExceptionUtil.getSurroudingLinesOfCode(BLFileName, lineNo, true), Key.codePrintPlain, ExceptionUtil.getSurroudingLinesOfCode(BLFileName, lineNo, false), Key.column, -1, Key.id, id, Key.line, lineNo, Key.Raw_Trace, element.toString(), Key.template, BLFileName, Key.type, "BL", Key.depth, i}));
                    if (depth > 0 && tagContext.size() >= depth) break;
                }
                isInComponent = false;
            }
            Position position = null;
            if (cause instanceof ParseException) {
                ParseException pe = (ParseException)cause;
                if (pe.hasIssues()) {
                    position = pe.getIssues().get(0).getPosition();
                }
            } else if (cause instanceof ExpressionException) {
                ExpressionException ee = (ExpressionException)cause;
                position = ee.getPosition();
            }
            if (position != null) {
                String fileName = "";
                String codePrintHTML = "";
                String codePrintPlain = "";
                if (position.getSource() != null) {
                    Source source = position.getSource();
                    if (source instanceof SourceFile) {
                        SourceFile sf = (SourceFile)source;
                        fileName = sf.getFile().toString();
                    }
                    codePrintHTML = position.getSource().getSurroundingLines(position.getStart().getLine(), true);
                    codePrintPlain = position.getSource().getSurroundingLines(position.getStart().getLine(), false);
                }
                thisTagContext.add(0, Struct.of(new Object[]{Key.codePrintHTML, codePrintHTML, Key.codePrintPlain, codePrintPlain, Key.column, position.getStart().getColumn(), Key.id, "", Key.line, position.getStart().getLine(), Key.Raw_Trace, "", Key.template, fileName, Key.type, "BL"}));
            }
            tagContext.addAll(thisTagContext);
        }
        return tagContext;
    }

    private static String getSurroudingLinesOfCode(String fileName, int lineNo, boolean html) {
        File srcFile = new File(fileName);
        if (srcFile.exists()) {
            if (new DiskClassUtil(null).isJavaBytecode(srcFile)) {
                return "Precompiled source not available.";
            }
            try {
                List<String> lines = Files.readAllLines(srcFile.toPath());
                int startLine = Math.max(1, lineNo - 2);
                int endLine = Math.min(lines.size(), lineNo + 2);
                StringBuilder codeSnippet = new StringBuilder();
                for (int i = startLine; i <= endLine; ++i) {
                    String theLine = StringEscapeUtils.escapeHtml4(lines.get(i - 1));
                    if (i == lineNo && html) {
                        codeSnippet.append("<b>").append(i).append(": ").append(theLine).append("</b>").append("<br>");
                        continue;
                    }
                    codeSnippet.append(i).append(": ").append(theLine).append(html ? "<br>" : "\n");
                }
                return codeSnippet.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String getCurrentPositionInCode() {
        Array tagContext = ExceptionUtil.getTagContext(1);
        if (!tagContext.isEmpty()) {
            IStruct thisTag = (IStruct)tagContext.get(0);
            return thisTag.getAsString(Key.template) + ":" + String.valueOf(thisTag.get(Key.line));
        }
        return "[not found]";
    }

    public static Array buildTagContext(Throwable e) {
        return ExceptionUtil.buildTagContext(e, -1);
    }

    public static Array getTagContext() {
        return ExceptionUtil.buildTagContext(new Exception(), -1);
    }

    public static Array getTagContext(int depth) {
        return ExceptionUtil.buildTagContext(new Exception(), depth);
    }

    public static String getStackTraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static StackTraceElement[] getMergedStackTrace(Throwable cause) {
        ArrayList<StackTraceElement> merged = new ArrayList<StackTraceElement>();
        StackTraceElement[] elements = cause.getStackTrace();
        merged.addAll(Arrays.asList(elements));
        for (Throwable parent = cause.getCause(); parent != null; parent = parent.getCause()) {
            elements = parent.getStackTrace();
            int i = merged.size() - 1;
            for (int j = elements.length - 1; i >= 0 && j >= 0 && ((StackTraceElement)merged.get(i)).equals(elements[j]); --i, --j) {
            }
            for (int k = j; k >= 0; --k) {
                merged.add(i + 1, elements[k]);
            }
        }
        return merged.toArray(new StackTraceElement[0]);
    }

    public static LinkedHashMap<Throwable, StackTraceElement[]> getMergedStackTrace2(Throwable cause) {
        LinkedHashMap<Throwable, StackTraceElement[]> map = new LinkedHashMap<Throwable, StackTraceElement[]>();
        Throwable current = cause;
        while (current != null) {
            StackTraceElement[] elements = current.getStackTrace();
            List<StackTraceElement> merged = new ArrayList<StackTraceElement>(Arrays.asList(elements));
            Throwable parent = current.getCause();
            if (parent != null) {
                StackTraceElement[] parentElements = parent.getStackTrace();
                int i = elements.length - 1;
                for (int j = parentElements.length - 1; i >= 0 && j >= 0 && elements[i].equals(parentElements[j]); --i, --j) {
                }
                merged = merged.subList(0, i + 1);
            }
            map.put(current, merged.toArray(new StackTraceElement[0]));
            current = parent;
        }
        return map;
    }

    public static IStruct throwableToStruct(Throwable target) {
        if (target == null) {
            return null;
        }
        IStruct result = Struct.of(new Object[]{Key.message, target.getMessage(), Key.stackTrace, ExceptionUtil.getStackTraceAsString(target), Key.tagContext, ExceptionUtil.buildTagContext(target), Key.cause, ExceptionUtil.throwableToStruct(target.getCause())});
        if (target instanceof BoxLangException) {
            BoxLangException ble = (BoxLangException)target;
            result.addAll(ble.dataAsStruct());
        }
        return result;
    }
}

