/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.exceptions;

import java.util.List;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.Issue;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class ParseException
extends BoxRuntimeException {
    List<Issue> issues;

    public ParseException(List<Issue> issues, String source) {
        super("Error compiling [ " + source + " ]. " + ParseException.issuesAsString(issues));
        this.issues = issues;
        this.extendedInfo = ParseException.issuesAsString(issues);
    }

    public ParseException(String message, Throwable cause) {
        super(message, cause);
    }

    public static String issuesAsString(List<Issue> issues) {
        return issues.stream().map(Issue::toString).collect(Collectors.joining("\n"));
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public boolean hasIssues() {
        return this.issues != null && !this.issues.isEmpty();
    }

    @Override
    public IStruct dataAsStruct() {
        IStruct result = super.dataAsStruct();
        result.put("issues", (Object)this.issues);
        return result;
    }
}

