/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.unmodifiable;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumn;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.UnmodifiableException;
import ortus.boxlang.runtime.types.unmodifiable.IUnmodifiable;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableQueryColumn;

public class UnmodifiableQuery
extends Query
implements IUnmodifiable {
    private static final long serialVersionUID = 1L;

    public UnmodifiableQuery(IStruct meta) {
        super(meta);
    }

    public UnmodifiableQuery() {
        this(new Struct(IStruct.TYPES.SORTED));
    }

    public UnmodifiableQuery(Query query) {
        this();
        for (Map.Entry<Key, QueryColumn> columnInfo : query.getColumns().entrySet()) {
            super.addColumn(columnInfo.getValue().getName(), columnInfo.getValue().getType(), null);
        }
        for (Object[] row : query.getData()) {
            Object[] duplicatedRow = (Object[])row.clone();
            super.addRow(duplicatedRow);
        }
    }

    public static UnmodifiableQuery fromResultSet(ResultSet resultSet) {
        return Query.fromResultSet(resultSet).toUnmodifiable();
    }

    public static UnmodifiableQuery fromArray(Array columnNames, Array columnTypes, Object rowData) {
        return Query.fromArray(columnNames, columnTypes, rowData).toUnmodifiable();
    }

    @Override
    public UnmodifiableQuery addColumn(Key name, QueryColumnType type, Object[] columnData) {
        throw new UnmodifiableException("Cannot add columns to an UnmodifiableQuery");
    }

    @Override
    protected QueryColumn createQueryColumn(Key name, QueryColumnType type, int index) {
        return new UnmodifiableQueryColumn(name, type, this, index);
    }

    @Override
    public UnmodifiableQuery insertQueryAt(int position, Query target) {
        throw new UnmodifiableException("Cannot insert queries into an UnmodifiableQuery");
    }

    @Override
    public int addRow(Object[] row) {
        throw new UnmodifiableException("Cannot add rows to an UnmodifiableQuery");
    }

    @Override
    public UnmodifiableQuery swapRow(int sourceRow, int destinationRow) {
        throw new UnmodifiableException("Cannot swap rows in an UnmodifiableQuery");
    }

    @Override
    public int addRow(IStruct row) {
        throw new UnmodifiableException("Cannot add rows to an UnmodifiableQuery");
    }

    @Override
    public int addRows(int rows) {
        throw new UnmodifiableException("Cannot add rows to an UnmodifiableQuery");
    }

    @Override
    public void deleteColumn(Key name) {
        throw new UnmodifiableException("Cannot delete columns from an UnmodifiableQuery");
    }

    @Override
    public UnmodifiableQuery deleteRow(int index) {
        throw new UnmodifiableException("Cannot delete rows from an UnmodifiableQuery");
    }

    @Override
    public int addData(Object rowData) {
        throw new UnmodifiableException("Cannot add data to an UnmodifiableQuery");
    }

    @Override
    public UnmodifiableQuery setCell(Key columnName, int rowIndex, Object value) {
        throw new UnmodifiableException("Cannot set cells in an UnmodifiableQuery");
    }

    @Override
    public void sort(Comparator<IStruct> compareFunc) {
        throw new UnmodifiableException("Cannot sort an UnmodifiableQuery");
    }

    @Override
    public boolean add(IStruct row) {
        throw new UnmodifiableException("Cannot add rows to an UnmodifiableQuery");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnmodifiableException("Cannot remove rows from an UnmodifiableQuery");
    }

    @Override
    public boolean addAll(Collection<? extends IStruct> rows) {
        throw new UnmodifiableException("Cannot add rows to an UnmodifiableQuery");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnmodifiableException("Cannot remove rows from an UnmodifiableQuery");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnmodifiableException("Cannot retain rows in an UnmodifiableQuery");
    }

    @Override
    public void clear() {
        throw new UnmodifiableException("Cannot clear an UnmodifiableQuery");
    }

    @Override
    public Object assign(IBoxContext context, Key name, Object value) {
        throw new UnmodifiableException("Cannot assign to an UnmodifiableQuery");
    }

    @Override
    public UnmodifiableQuery duplicate() {
        return super.duplicate(false).toUnmodifiable();
    }

    @Override
    public Query toModifiable() {
        Query q = new Query();
        for (Map.Entry<Key, QueryColumn> columnInfo : this.getColumns().entrySet()) {
            q.addColumn(columnInfo.getValue().getName(), columnInfo.getValue().getType(), null);
        }
        for (Object[] row : this.getData()) {
            Object[] duplicatedRow = (Object[])row.clone();
            q.addRow(duplicatedRow);
        }
        return q;
    }
}

