/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.unmodifiable;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.KeyCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.NullValue;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.UnmodifiableException;
import ortus.boxlang.runtime.types.unmodifiable.IUnmodifiable;

public class UnmodifiableStruct
extends Struct
implements IUnmodifiable {
    public final IStruct.TYPES type;

    public UnmodifiableStruct(IStruct.TYPES type) {
        super(switch (type) {
            case IStruct.TYPES.DEFAULT -> new HashMap(32);
            case IStruct.TYPES.LINKED -> new LinkedHashMap(32);
            case IStruct.TYPES.SORTED -> new TreeMap();
            default -> throw new BoxRuntimeException("Invalid struct type [" + type.name() + "]");
        }, type);
        this.type = type;
    }

    public UnmodifiableStruct() {
        this(IStruct.TYPES.DEFAULT);
    }

    public UnmodifiableStruct(Map<? extends Object, ? extends Object> map) {
        this(IStruct.TYPES.DEFAULT, map);
    }

    public UnmodifiableStruct(IStruct struct) {
        IStruct.TYPES tYPES;
        if (struct instanceof Struct) {
            Struct str = (Struct)struct;
            tYPES = str.getType();
        } else {
            tYPES = IStruct.TYPES.DEFAULT;
        }
        this(tYPES, struct.getWrapped());
    }

    public UnmodifiableStruct(IStruct.TYPES type, Map<? extends Object, ? extends Object> map) {
        this(type);
        this._addAll(map);
    }

    @Override
    public Struct toModifiable() {
        return new Struct(this.wrapped, this.type);
    }

    public static UnmodifiableStruct fromMap(Map<? extends Object, ? extends Object> map) {
        return new UnmodifiableStruct(map);
    }

    public static UnmodifiableStruct fromMap(IStruct.TYPES type, Map<Object, Object> map) {
        return new UnmodifiableStruct(type, map);
    }

    public static UnmodifiableStruct fromStruct(IStruct struct) {
        return new UnmodifiableStruct(struct);
    }

    public static UnmodifiableStruct of(Object ... values) {
        if (values.length % 2 != 0) {
            throw new BoxRuntimeException("Invalid number of arguments.  Must be an even number.");
        }
        UnmodifiableStruct struct = new UnmodifiableStruct();
        for (int i = 0; i < values.length; i += 2) {
            struct._put(KeyCaster.cast(values[i]), values[i + 1]);
        }
        return struct;
    }

    @Override
    public Object put(Key key, Object value) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    private Object _put(Key key, Object value) {
        return this.wrapped.put(key, this.wrapNull(value));
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    @Override
    public Object putIfAbsent(Key key, Object value) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    @Override
    public Object remove(Object key) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    @Override
    public Object remove(String key) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    @Override
    public Object remove(Key key) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Object> map) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    private void _addAll(Map<? extends Object, ? extends Object> map) {
        Stream entryStream = map.entrySet().parallelStream();
        if (this.type.equals((Object)IStruct.TYPES.LINKED)) {
            entryStream.forEachOrdered(entry -> {
                Key entryKey;
                Object patt0$temp = entry.getKey();
                Key key = patt0$temp instanceof Key ? (entryKey = (Key)patt0$temp) : Key.of(entry.getKey().toString());
                this._put(key, entry.getValue());
            });
        } else {
            entryStream.forEach((? super T entry) -> {
                Key entryKey;
                Object patt0$temp = entry.getKey();
                Key key = patt0$temp instanceof Key ? (entryKey = (Key)patt0$temp) : Key.of(entry.getKey().toString());
                this._put(key, entry.getValue());
            });
        }
    }

    @Override
    public void addAll(Map<? extends Object, ? extends Object> map) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    @Override
    public void clear() {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    @Override
    public Object assign(IBoxContext context, Key key, Object value) {
        throw new UnmodifiableException("Cannot modify Unmodifiable Struct");
    }

    public static Object unWrapNull(Object value) {
        if (value instanceof NullValue) {
            return null;
        }
        return value;
    }
}

