/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.util;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collector;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.Struct;

public class BLCollector {
    private BLCollector() {
    }

    public static Collector<Object, ?, Array> toArray() {
        return Collector.of(Array::new, Array::add, (left, right) -> {
            left.addAll((Collection<? extends Object>)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.CONCURRENT);
    }

    public static Collector<Map.Entry<Key, Object>, ?, Struct> toStruct() {
        return Collector.of(Struct::new, (struct, entry) -> struct.put((Key)entry.getKey(), entry.getValue()), (left, right) -> {
            left.putAll((Map<? extends Key, ? extends Object>)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED);
    }

    public static Collector<Map.Entry<Key, Object>, ?, Struct> toStruct(IStruct.TYPES type) {
        Collector.Characteristics[] characteristics = type == IStruct.TYPES.LINKED ? new Collector.Characteristics[]{Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.CONCURRENT} : new Collector.Characteristics[]{Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED};
        return Collector.of(() -> new Struct(type), (struct, entry) -> struct.put((Key)entry.getKey(), entry.getValue()), (left, right) -> {
            left.putAll((Map<? extends Key, ? extends Object>)right);
            return left;
        }, characteristics);
    }

    public static Collector<IStruct, Query, Query> toQuery(Query newQuery) {
        return Collector.of(() -> newQuery, Query::add, (left, right) -> {
            left.addAll((Collection<? extends IStruct>)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.CONCURRENT);
    }
}

