/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.util;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.management.InvalidAttributeValueException;

public class DateTimeHelper {
    public static final DateTimeFormatter ISO_DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final DateTimeFormatter ISO_DATE_ONLY = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static LocalDateTime now() {
        return DateTimeHelper.now(DateTimeHelper.getSystemTimezone());
    }

    public static LocalDateTime now(ZoneId timezone) {
        return LocalDateTime.now(timezone);
    }

    public static LocalDateTime now(String timezone) {
        return DateTimeHelper.now(ZoneId.of(timezone));
    }

    public static Instant toInstant(Object target) throws IllegalArgumentException {
        if (target instanceof String) {
            String castedTarget = (String)target;
            return Instant.parse(castedTarget);
        }
        if (target instanceof Date) {
            Date castedTarget = (Date)target;
            return castedTarget.toInstant();
        }
        throw new IllegalArgumentException("Unsupported date/time");
    }

    public static LocalDateTime toLocalDateTime(Object target, ZoneId timezone) {
        return DateTimeHelper.toInstant(target).atZone(timezone == null ? ZoneOffset.UTC : timezone).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Object target, String timezone) {
        return DateTimeHelper.toLocalDateTime(target, timezone == null || timezone.length() == 0 ? null : ZoneId.of(timezone));
    }

    public static LocalDateTime toLocalDateTime(Object target) {
        return DateTimeHelper.toLocalDateTime(target, ZoneOffset.UTC);
    }

    public static LocalDateTime parse(String target) {
        return LocalDateTime.parse(target, ISO_DATE_FORMATTER);
    }

    public static LocalDate toLocalDate(Object target, ZoneId timezone) {
        return DateTimeHelper.toInstant(target).atZone(timezone == null ? ZoneOffset.UTC : timezone).toLocalDate();
    }

    public static LocalDate toLocalDate(Object target, String timezone) {
        return DateTimeHelper.toLocalDate(target, timezone == null || timezone.length() == 0 ? null : ZoneId.of(timezone));
    }

    public static LocalDate toLocalDate(Object target) {
        return DateTimeHelper.toLocalDate(target, ZoneOffset.UTC);
    }

    public static ZoneId getTimezone(String timezone) {
        return ZoneId.of(timezone);
    }

    public static ZoneId getSystemTimezone() {
        return ZoneId.systemDefault();
    }

    public static String getIsoTime(LocalDateTime dateTime, boolean toUTC) {
        return dateTime.atZone(toUTC ? ZoneOffset.UTC : DateTimeHelper.getSystemTimezone()).format(ISO_DATE_FORMATTER);
    }

    public static String getIsoTime(LocalDateTime dateTime) {
        return DateTimeHelper.getIsoTime(dateTime, true);
    }

    public static int daysInMonth(LocalDateTime now) {
        return now.getMonth().maxLength();
    }

    public static int daysInMonth() {
        return DateTimeHelper.daysInMonth(DateTimeHelper.now());
    }

    public static LocalDateTime getFirstBusinessDayOfTheMonth(String time, Boolean addMonth, LocalDateTime now) {
        if (addMonth.booleanValue()) {
            now = now.plusMonths(1L);
        }
        return now.with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)).withHour(Integer.parseInt(time.split(":")[0])).withMinute(Integer.parseInt(time.split(":")[1])).withSecond(0);
    }

    public static LocalDateTime getFirstBusinessDayOfTheMonth(String time, Boolean addMonth, ZoneId timezone) {
        return DateTimeHelper.getFirstBusinessDayOfTheMonth(time, addMonth, DateTimeHelper.now(timezone));
    }

    public static LocalDateTime getFirstBusinessDayOfTheMonth(ZoneId timezone) {
        return DateTimeHelper.getFirstBusinessDayOfTheMonth("00:00", (Boolean)false, DateTimeHelper.now(timezone));
    }

    public static LocalDateTime getFirstBusinessDayOfTheMonth() {
        return DateTimeHelper.getFirstBusinessDayOfTheMonth("00:00", (Boolean)false, DateTimeHelper.now(DateTimeHelper.getSystemTimezone()));
    }

    public static LocalDateTime getLastBusinessDayOfTheMonth(String time, Boolean addMonth, LocalDateTime now) {
        if (addMonth.booleanValue()) {
            now = now.plusMonths(1L);
        }
        LocalDateTime lastDay = now.with(TemporalAdjusters.lastDayOfMonth()).withHour(Integer.parseInt(time.split(":")[0])).withMinute(Integer.parseInt(time.split(":")[1])).withSecond(0);
        switch (lastDay.getDayOfWeek().getValue()) {
            case 7: {
                lastDay = lastDay.minusDays(2L);
                break;
            }
            case 6: {
                lastDay = lastDay.minusDays(1L);
                break;
            }
        }
        return lastDay;
    }

    public static LocalDateTime getLastBusinessDayOfTheMonth(String time, Boolean addMonth, ZoneId timezone) {
        return DateTimeHelper.getLastBusinessDayOfTheMonth(time, addMonth, DateTimeHelper.now(timezone));
    }

    public static LocalDateTime getLastBusinessDayOfTheMonth(ZoneId timezone) {
        return DateTimeHelper.getLastBusinessDayOfTheMonth("00:00", (Boolean)false, DateTimeHelper.now(timezone));
    }

    public static LocalDateTime getLastBusinessDayOfTheMonth() {
        return DateTimeHelper.getLastBusinessDayOfTheMonth("00:00", (Boolean)false, DateTimeHelper.now(DateTimeHelper.getSystemTimezone()));
    }

    public static String validateTime(String time) throws InvalidAttributeValueException {
        if (!time.matches("^([0-1][0-9]|[2][0-3]):[0-5][0-9]$")) {
            if (time.contains(":")) {
                throw new InvalidAttributeValueException("Invalid time representation (" + time + "). Time is represented in 24 hour minute format => HH:mm");
            }
            return DateTimeHelper.validateTime(time + ":00");
        }
        return time;
    }

    public static Duration timespanToDuration(String timespan) {
        String[] parts2 = timespan.split(",");
        if (parts2.length != 4) {
            throw new IllegalArgumentException("Invalid timespan representation (" + timespan + "). Timespan is represented in days,hours,minutes,seconds");
        }
        return Duration.ofDays(Long.parseLong(parts2[0])).plusHours(Long.parseLong(parts2[1])).plusMinutes(Long.parseLong(parts2[2])).plusSeconds(Long.parseLong(parts2[3]));
    }

    public static long timeUnitToSeconds(long value, TimeUnit target) {
        switch (target) {
            case SECONDS: {
                value = value * 60L * 60L * 24L;
                break;
            }
            case HOURS: {
                value = value * 60L * 60L;
                break;
            }
            case MINUTES: {
                value *= 60L;
                break;
            }
            case MILLISECONDS: {
                value /= 1000L;
                break;
            }
            case MICROSECONDS: {
                value /= 1000000L;
                break;
            }
            case NANOSECONDS: {
                value /= 1000000000L;
                break;
            }
        }
        return value;
    }

    public static LocalDateTime dateTimeAdd(LocalDateTime target, long amount, TimeUnit timeUnit) {
        return switch (timeUnit) {
            case TimeUnit.DAYS -> target.plusDays(amount);
            case TimeUnit.HOURS -> target.plusHours(amount);
            case TimeUnit.MINUTES -> target.plusMinutes(amount);
            case TimeUnit.MILLISECONDS -> target.plusSeconds(amount / 1000L);
            case TimeUnit.MICROSECONDS -> target.plusNanos(amount * 1000L);
            case TimeUnit.NANOSECONDS -> target.plusNanos(amount);
            default -> target.plusSeconds(amount);
        };
    }

    public static TimeUnit toTimeUnit(Object unit) {
        if (unit instanceof TimeUnit) {
            TimeUnit castedUnit = (TimeUnit)((Object)unit);
            return castedUnit;
        }
        if (unit instanceof String) {
            String castedUnit = (String)unit;
            return TimeUnit.valueOf(castedUnit.toUpperCase());
        }
        throw new IllegalArgumentException("Unsupported time unit: " + String.valueOf(unit));
    }
}

