/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.jr.annotationsupport.JacksonAnnotationExtension;
import com.fasterxml.jackson.jr.extension.javatime.JacksonJrJavaTimeExtension;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JacksonJrExtension;
import com.fasterxml.jackson.jr.ob.api.ExtensionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.conversion.BoxJsonProvider;

public class JSONUtil {
    private static final JSON JSON_BUILDER = JSON.builder(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS).enable(JsonParser.Feature.ALLOW_YAML_COMMENTS)).enable(JSON.Feature.PRETTY_PRINT_OUTPUT, JSON.Feature.USE_BIG_DECIMAL_FOR_FLOATS, JSON.Feature.USE_FIELDS, JSON.Feature.WRITE_NULL_PROPERTIES).register(JacksonAnnotationExtension.std).register(new JacksonJrJavaTimeExtension()).register(new JacksonJrExtension(){

        @Override
        protected void register(ExtensionContext extensionContext) {
            extensionContext.insertProvider(new BoxJsonProvider());
        }
    }).build();

    public static JSON getJSONBuilder() {
        return JSON_BUILDER;
    }

    public static Object fromJSON(Object json, boolean toBLTypes) {
        try {
            Object parsed = JSON_BUILDER.anyFrom(json);
            return toBLTypes ? JSONUtil.mapToBLTypes(parsed, true) : parsed;
        }
        catch (Exception e) {
            throw new BoxRuntimeException("Failed to parse JSON " + json.toString(), e);
        }
    }

    public static Object fromJSON(Object json) {
        return JSONUtil.fromJSON(json, false);
    }

    public static <T> T fromJSON(Class<T> clazz, Object json) {
        try {
            return JSON_BUILDER.beanFrom(clazz, json);
        }
        catch (Exception e) {
            throw new BoxRuntimeException("Failed to parse JSON into " + clazz.getSimpleName(), e);
        }
    }

    public static Object mapToBLTypes(Object result, Boolean strictMapping) {
        if (result == null) {
            return null;
        }
        if (result instanceof Map) {
            Map map = (Map)result;
            if (!(strictMapping.booleanValue() || map.size() != 2 && map.size() != 3)) {
                String col2;
                Map castedmap = map;
                Object columnKey = null;
                String dataKey = null;
                String rowCountKey = null;
                for (String col2 : castedmap.keySet()) {
                    if (col2.equalsIgnoreCase("columns")) {
                        columnKey = col2;
                    }
                    if (col2.equalsIgnoreCase("data")) {
                        dataKey = col2;
                    }
                    if (!col2.equalsIgnoreCase("rowCount")) continue;
                    rowCountKey = col2;
                }
                if (columnKey != null && dataKey != null && (col2 = castedmap.get(columnKey)) instanceof List) {
                    List colList = (List)((Object)col2);
                    Query qry = new Query();
                    ArrayList validColumns = new ArrayList();
                    colList.forEach(c -> {
                        Key thisCol = Key.of(c.toString());
                        validColumns.add(thisCol);
                        qry.addColumn(thisCol, QueryColumnType.OBJECT);
                    });
                    Boolean golden = true;
                    Object object = map.get(dataKey);
                    if (object instanceof List) {
                        List listData = (List)object;
                        for (Object row : listData) {
                            List listRow;
                            if (row instanceof List && (listRow = (List)row).size() == colList.size()) {
                                qry.addRow(listRow.toArray());
                                continue;
                            }
                            golden = false;
                            break;
                        }
                        if (golden.booleanValue()) {
                            return qry;
                        }
                    } else {
                        Map tmp;
                        object = map.get(dataKey);
                        if (object instanceof Map && (tmp = (Map)object).keySet().size() == colList.size() && rowCountKey != null) {
                            CastAttempt<Integer> rowCountAttempt = IntegerCaster.attempt(map.get(rowCountKey));
                            Map mapData = (Map)map.get(dataKey);
                            if (rowCountAttempt.wasSuccessful()) {
                                int rowCount = rowCountAttempt.get();
                                for (Map.Entry col3 : mapData.entrySet()) {
                                    Key thisColKey = Key.of(col3.getKey().toString());
                                    if (validColumns.contains(thisColKey)) {
                                        List listData;
                                        Object v = mapData.get(thisColKey.getName());
                                        if (v instanceof List && (listData = (List)v).size() == rowCount) {
                                            qry.addColumn(thisColKey, QueryColumnType.OBJECT, listData.toArray());
                                            continue;
                                        }
                                        golden = false;
                                        break;
                                    }
                                    golden = false;
                                    break;
                                }
                                if (golden.booleanValue()) {
                                    return qry;
                                }
                            }
                        }
                    }
                }
            }
            IStruct str = Struct.fromMap(IStruct.TYPES.LINKED, map);
            for (Key key : str.keySet()) {
                str.put(key, JSONUtil.mapToBLTypes(str.get(key), strictMapping));
            }
            return str;
        }
        if (result instanceof List) {
            List list = (List)result;
            Array arr = Array.fromList(list);
            for (int i = 0; i < arr.size(); ++i) {
                arr.set(i, JSONUtil.mapToBLTypes(arr.get(i), strictMapping));
            }
            return arr;
        }
        return result;
    }
}

