/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.operators.Compare;
import ortus.boxlang.runtime.operators.StringCompare;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.AsyncService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.BLCollector;

public class ListUtil {
    public static final String DEFAULT_DELIMITER = ",";
    public static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");
    public static final Struct sortDirectives = new Struct((Map<? extends Object, ? extends Object>)new HashMap<Key, Comparator<Object>>(){
        {
            this.put(Key.of("numericAsc"), (a, b) -> Compare.invoke(a, b, false));
            this.put(Key.of("numericDesc"), (b, a) -> Compare.invoke(a, b, true));
            this.put(Key.of("textAsc"), (a, b) -> StringCompare.invoke(StringCaster.cast(a), StringCaster.cast(b), true));
            this.put(Key.of("textDesc"), (b, a) -> StringCompare.invoke(StringCaster.cast(a), StringCaster.cast(b), true));
            this.put(Key.of("textNoCaseAsc"), (a, b) -> StringCompare.invoke(StringCaster.cast(a), StringCaster.cast(b), false));
            this.put(Key.of("textNoCaseDesc"), (b, a) -> StringCompare.invoke(StringCaster.cast(a), StringCaster.cast(b), false));
        }
    });

    public static String asString(Array list, String delimiter) {
        return list.stream().map(s -> s == null ? "" : s).map(StringCaster::cast).collect(Collectors.joining(list.containsDelimiters ? "" : delimiter));
    }

    public static Array asList(String list, String delimiter) {
        return ListUtil.asList(list, delimiter, false, false);
    }

    public static Array asList(String list, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        return ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter, false);
    }

    public static Array asList(String list, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter, Boolean preserveDelimiters) {
        String[] result = null;
        if (delimiter.length() == 0) {
            result = list.split("");
        } else if (wholeDelimiter.booleanValue()) {
            result = includeEmpty.booleanValue() ? StringUtils.splitByWholeSeparatorPreserveAllTokens(list, delimiter) : StringUtils.splitByWholeSeparator(list, delimiter);
        } else {
            if (delimiter.length() > 1 && !wholeDelimiter.booleanValue() && preserveDelimiters.booleanValue()) {
                return new Array(list.splitWithDelimiters("[" + ListUtil.escapeRegexSpecials(delimiter) + "]", 0)).withDelimiters();
            }
            result = includeEmpty != false ? StringUtils.splitPreserveAllTokens(list, delimiter) : StringUtils.split(list, delimiter);
        }
        return Arrays.stream(result).map(String::trim).collect(BLCollector.toArray());
    }

    public static int indexOf(String list, String value, String delimiter) {
        return ListUtil.indexOf(list, value, delimiter, false, false);
    }

    public static int indexOf(String list, String value, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        return ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter).findIndex(value, true);
    }

    public static int indexOfNoCase(String list, String value, String delimiter) {
        return ListUtil.indexOfNoCase(list, value, delimiter, false, false);
    }

    public static int indexOfNoCase(String list, String value, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        return ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter).findIndex(value, false);
    }

    public static Boolean contains(String list, String value, String delimiter) {
        return ListUtil.contains(list, value, delimiter, false, false);
    }

    public static Boolean contains(String list, String value, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        return ListUtil.indexOf(list, value, delimiter, includeEmpty, wholeDelimiter) > 0;
    }

    public static Boolean containsNoCase(String list, String value, String delimiter) {
        return ListUtil.containsNoCase(list, value, delimiter, false, false);
    }

    public static Boolean containsNoCase(String list, String value, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        return ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter).findIndex(value, false) > 0;
    }

    public static String getAt(String list, int index, String delimiter) {
        return ListUtil.getAt(list, index, delimiter, false, false);
    }

    public static String getAt(String list, int index, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        return StringCaster.cast(ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter).getAt(index));
    }

    public static String getAt(String list, int index, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter, String defaultValue) {
        Array array = ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter);
        if (index < 0 || array.size() < index) {
            return defaultValue;
        }
        return StringCaster.cast(array.getAt(index));
    }

    public static String setAt(String list, int index, String value, String delimiter) {
        return ListUtil.setAt(list, index, value, delimiter, false, false);
    }

    public static String setAt(String list, int index, String value, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        return ListUtil.asString(ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter).setAt(index, value), delimiter);
    }

    public static String append(String list, String value, String delimiter) {
        return ListUtil.append(list, value, delimiter, false, false);
    }

    public static String append(String list, String value, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        Array jList = ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter);
        jList.add(value);
        return ListUtil.asString(jList, delimiter);
    }

    public static String prepend(String list, String value, String delimiter) {
        return ListUtil.prepend(list, value, delimiter, false, false);
    }

    public static String prepend(String list, String value, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        Array jList = ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter);
        jList.add(0, value);
        return ListUtil.asString(jList, delimiter);
    }

    public static String insertAt(String list, int index, String value, String delimiter) {
        return ListUtil.insertAt(list, index, value, delimiter, false, false);
    }

    public static String insertAt(String list, int index, String value, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        Array jList = ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter);
        if (index < 1 || index > jList.size() + 1) {
            throw new BoxRuntimeException("Index out of bounds for list with " + jList.size() + " elements.");
        }
        jList.add(index - 1, value);
        return ListUtil.asString(jList, delimiter);
    }

    public static String deleteAt(String list, int index, String delimiter) {
        return ListUtil.deleteAt(list, index, delimiter, false, true);
    }

    public static String deleteAt(String list, int index, String delimiter, Boolean includeEmpty, Boolean wholeDelimiter) {
        return ListUtil.asString(ListUtil.asList(list, delimiter, includeEmpty, wholeDelimiter, true).deleteAt(index), delimiter);
    }

    public static String removeDuplicates(String list, String delimiter, Boolean caseSensitive) {
        return ListUtil.asString(ListUtil.asList(list, delimiter).removeDuplicates(caseSensitive), delimiter);
    }

    public static void each(Array array, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads, Boolean ordered) {
        IntConsumer exec = callback.requiresStrictArguments() ? idx -> callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null}) : idx -> callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null, idx + 1, array});
        IntStream intStream = array.intStream();
        if (!parallel.booleanValue()) {
            intStream.forEach(exec);
        } else if (ordered.booleanValue()) {
            AsyncService.buildExecutor("ArrayEach_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> array.intStream().parallel().forEachOrdered(exec));
        } else {
            AsyncService.buildExecutor("ArrayEach_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> array.intStream().parallel().forEach(exec));
        }
    }

    public static Boolean some(Array array, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads) {
        IntPredicate test = callback.requiresStrictArguments() ? idx -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null})) : idx -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null, idx + 1, array}));
        IntStream intStream = array.intStream();
        return parallel == false ? Boolean.valueOf(intStream.anyMatch(test)) : (Boolean)AsyncService.buildExecutor("ArraySome_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> array.intStream().parallel().anyMatch(test));
    }

    public static Boolean every(Array array, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads) {
        IntPredicate test = callback.requiresStrictArguments() ? idx -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null})) : idx -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null, idx + 1, array}));
        IntStream intStream = array.intStream();
        return !parallel.booleanValue() ? intStream.dropWhile(test).toArray().length == 0 : BooleanCaster.cast(AsyncService.buildExecutor("ArrayEvery_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> array.intStream().parallel().dropWhile(test).toArray().length == 0));
    }

    public static Array filter(Array array, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads) {
        IntPredicate test = callback.requiresStrictArguments() ? idx -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null})) : idx -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null, idx + 1, array}));
        IntStream intStream = array.intStream();
        return ArrayCaster.cast(parallel == false ? intStream.filter(test).mapToObj(idx -> array.size() > idx ? array.get(idx) : null).toArray() : AsyncService.buildExecutor("ArrayFilter_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> array.intStream().parallel().filter(test).mapToObj(array::get).toArray()));
    }

    public static Array sort(Array array, Function callback, IBoxContext callbackContext) {
        array.sort((a, b) -> IntegerCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{a, b})));
        return array;
    }

    public static Array sort(Array array, String sortType, String sortOrder, Locale locale) {
        Key sortKey = Key.of(sortType + sortOrder);
        if (!sortDirectives.containsKey(sortKey)) {
            throw new BoxRuntimeException("You must supply either a sortOrder or callback");
        }
        array.sort((Comparator)sortDirectives.get(sortKey));
        return array;
    }

    public static Array trim(Array array) {
        int fromIndex = 0;
        for (int i = 0; i < array.size(); ++i) {
            fromIndex = i;
            if (StringCaster.cast(array.get(i)).length() > 0) break;
        }
        int toIndex = 0;
        for (int i = array.size() - 1; i >= 0; --i) {
            toIndex = i;
            if (StringCaster.cast(array.get(i)).length() > 0) break;
        }
        return Array.copyOf(array.subList(fromIndex, toIndex + 1));
    }

    public static Array map(Array array, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads) {
        IntFunction<Object> mapper = callback.requiresStrictArguments() ? idx -> callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null}) : idx -> callbackContext.invokeFunction((Object)callback, new Object[]{array.size() > idx ? array.get(idx) : null, idx + 1, array});
        IntStream intStream = array.intStream();
        if (!parallel.booleanValue()) {
            return new Array(intStream.mapToObj(mapper).toArray());
        }
        return ArrayCaster.cast(AsyncService.buildExecutor("ArrayMap_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> new Array(array.intStream().parallel().mapToObj(mapper).toArray())));
    }

    public static Object reduce(Array array, Function callback, IBoxContext callbackContext, Object initialValue) {
        BiFunction<Object, Integer, Object> reduction = callback.requiresStrictArguments() ? (acc, idx) -> callbackContext.invokeFunction((Object)callback, new Object[]{acc, array.size() > idx ? array.get((int)idx) : null}) : (acc, idx) -> callbackContext.invokeFunction((Object)callback, new Object[]{acc, array.size() > idx ? array.get((int)idx) : null, idx + 1, array});
        return array.intStream().boxed().reduce(initialValue, reduction, (acc, intermediate) -> acc);
    }

    public static Object reduce(String list, String delimiter, boolean includeEmptyFields, boolean multiCharacterDelimiter, Function callback, IBoxContext callbackContext, Object initialValue) {
        Array array = ListUtil.asList(list, delimiter, includeEmptyFields, multiCharacterDelimiter);
        BiFunction<Object, Integer, Object> reduction = callback.requiresStrictArguments() ? (acc, idx) -> callbackContext.invokeFunction((Object)callback, new Object[]{acc, array.size() > idx ? array.get((int)idx) : null}) : (acc, idx) -> callbackContext.invokeFunction((Object)callback, new Object[]{acc, array.size() > idx ? array.get((int)idx) : null, idx + 1, list, delimiter});
        return array.intStream().boxed().reduce(initialValue, reduction, (acc, intermediate) -> acc);
    }

    private static String escapeRegexSpecials(String str) {
        return SPECIAL_REGEX_CHARS.matcher(str).replaceAll("\\\\$0");
    }
}

