/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.util;

import java.math.MathContext;
import java.math.RoundingMode;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;

public class MathUtil {
    public static MathContext defaultMathContext = MathContext.DECIMAL128;
    public static boolean highPrecisionMath = true;

    public static MathContext getMathContext() {
        return defaultMathContext;
    }

    public static void setMathContext(MathContext mathContext) {
        defaultMathContext = mathContext;
    }

    public static MathContext setPrecision(int precision) {
        defaultMathContext = new MathContext(precision, defaultMathContext.getRoundingMode());
        return defaultMathContext;
    }

    public static MathContext setRoundingMode(String roundingMode) {
        defaultMathContext = new MathContext(defaultMathContext.getPrecision(), RoundingMode.valueOf(roundingMode.trim().toUpperCase()));
        return defaultMathContext;
    }

    public static MathContext setRoundingMode(RoundingMode roundingMode) {
        defaultMathContext = new MathContext(defaultMathContext.getPrecision(), roundingMode);
        return defaultMathContext;
    }

    public static void setMathContext(String mathContext) {
        switch (mathContext.toUpperCase().trim()) {
            case "DECIMAL32": {
                defaultMathContext = MathContext.DECIMAL32;
                break;
            }
            case "DECIMAL64": {
                defaultMathContext = MathContext.DECIMAL64;
                break;
            }
            case "DECIMAL128": {
                defaultMathContext = MathContext.DECIMAL128;
                break;
            }
            default: {
                throw new BoxValidationException(mathContext + " is not a valid MathContext");
            }
        }
    }

    public static boolean isHighPrecisionMath() {
        return highPrecisionMath;
    }

    public static void setHighPrecisionMath(boolean highPrecisionMath) {
        MathUtil.highPrecisionMath = highPrecisionMath;
    }
}

