/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    private static final Pattern POSIX_PATTERN = Pattern.compile("\\[(.*?)\\]");
    private static final Pattern POSIX_PATTERN_NOCASE = Pattern.compile("\\[(.*?)\\]", 2);
    private static final Map<String, String> POSIX_MAP = new HashMap<String, String>();

    public static String posixReplace(String expression, Boolean noCase) {
        Matcher posixMatcher;
        Matcher matcher = posixMatcher = noCase != false ? POSIX_PATTERN_NOCASE.matcher(expression) : POSIX_PATTERN.matcher(expression);
        if (!posixMatcher.find()) {
            return expression;
        }
        posixMatcher.reset();
        StringBuilder sb = new StringBuilder();
        while (posixMatcher.find()) {
            String insideBrackets = posixMatcher.group(1);
            for (Map.Entry<String, String> entry : POSIX_MAP.entrySet()) {
                insideBrackets = insideBrackets.replace(entry.getKey(), entry.getValue());
            }
            posixMatcher.appendReplacement(sb, Matcher.quoteReplacement("[" + insideBrackets + "]"));
        }
        posixMatcher.appendTail(sb);
        String returnExpression = sb.toString();
        for (Map.Entry<String, String> entry : POSIX_MAP.entrySet()) {
            returnExpression = returnExpression.replace(entry.getKey(), "[" + entry.getValue() + "]");
        }
        return returnExpression;
    }

    public static String replaceNonQuantiferCurlyBraces(String input) {
        String quantifierRegex = "\\{\\d*,?\\d*\\}";
        Pattern quantifierPattern = Pattern.compile(quantifierRegex);
        Matcher matcher = quantifierPattern.matcher(input);
        StringBuilder escapedString = new StringBuilder();
        int lastIndex = 0;
        while (matcher.find()) {
            String betweenMatches = input.substring(lastIndex, matcher.start()).replaceAll("(?<!\\\\)\\{", "\\\\{").replaceAll("(?<!\\\\)\\}", "\\\\}");
            escapedString.append(betweenMatches);
            escapedString.append(matcher.group());
            lastIndex = matcher.end();
        }
        escapedString.append(input.substring(lastIndex).replaceAll("(?<!\\\\)\\{", "\\\\{").replaceAll("(?<!\\\\)\\}", "\\\\}"));
        return escapedString.toString();
    }

    static {
        POSIX_MAP.put("[:alnum:]", "a-zA-Z0-9");
        POSIX_MAP.put("[:alpha:]", "a-zA-Z");
        POSIX_MAP.put("[:blank:]", " \\t");
        POSIX_MAP.put("[:cntrl:]", "\\x00-\\x1F\\x7F");
        POSIX_MAP.put("[:digit:]", "0-9");
        POSIX_MAP.put("[:graph:]", "\\x21-\\x7E");
        POSIX_MAP.put("[:lower:]", "a-z");
        POSIX_MAP.put("[:print:]", "\\x20-\\x7E");
        POSIX_MAP.put("[:punct:]", "!\"#$%&'()*+,-./:;<=>?@\\[\\]^_`{|}~");
        POSIX_MAP.put("[:space:]", "\\s");
        POSIX_MAP.put("[:upper:]", "A-Z");
        POSIX_MAP.put("[:xdigit:]", "0-9a-fA-F");
    }
}

