/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.util;

import com.fasterxml.jackson.jr.ob.JSON;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StringUtil {
    public static final String NEW_LINE = System.lineSeparator();
    public static final String TAB = "\t";
    public static final List<String> SQL_KEYWORDS = List.of("ALTER TABLE", "CREATE TABLE", "CASE", "NULLIF", "DELETE", "DROP TABLE", "FROM", "GROUP BY", "HAVING", "INSERT INTO", "LIMIT", "ORDER BY", "OFFSET", "SELECT", "UNION", "UPDATE", "WHERE");
    public static final String SQL_KEYWORDS_REGEX = String.join((CharSequence)"|", SQL_KEYWORDS);
    public static final List<String> SQL_INDENTED_KEYWORDS = List.of("FULL JOIN", "INNER JOIN", "JOIN", "LEFT JOIN", "OUTER JOIN", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL", "EXISTS", "DISTINCT", "UNION ALL", "UNION", "INTERSECT", "MINUS", "EXCEPT");
    public static final String SQL_INDENTED_KEYWORDS_REGEX = String.join((CharSequence)"|", SQL_INDENTED_KEYWORDS);
    public static final List<String> SQL_OPERATORS = List.of("\\+", "\\-", "\\*", "\\/", "\\%", "\\=", "\\<", "\\>", "\\<\\=", "\\>\\=", "\\<\\>", "\\!\\=");
    public static final String SQL_OPERATORS_REGEX = String.join((CharSequence)"|", SQL_OPERATORS);
    public static final List<String> SQL_LOGICAL_OPERATORS = List.of("AND", "OR", "NOT");
    public static final String SQL_LOGICAL_OPERATORS_REGEX = String.join((CharSequence)"|", SQL_LOGICAL_OPERATORS);
    public static final String INDENT = "  ";

    public static String slugify(String str) {
        return StringUtil.slugify(str, 0, "");
    }

    public static String slugify(String str, int maxLength, String allow) {
        String slug = str.trim().toLowerCase().replace("\\s+", "-").replaceAll("\u00e4", "ae").replaceAll("\u00fc", "ue").replaceAll("\u00f6", "oe").replaceAll("\u00df", "ss");
        slug = slug.toLowerCase().replaceAll("[^a-z0-9" + allow + "]", "-").replaceAll("-+", "-");
        if (maxLength != 0 && slug.length() > maxLength) {
            slug = slug.substring(0, maxLength);
        }
        return slug;
    }

    public static String prettyJson(String target) {
        try {
            Object jsonObject = JSON.std.anyFrom(target);
            return JSON.std.with(JSON.Feature.PRETTY_PRINT_OUTPUT).asString(jsonObject);
        }
        catch (Exception e) {
            return target;
        }
    }

    public static String prettySql(String target) {
        return target.lines().map(String::trim).map(item -> item.replaceAll("\\s*(?![^()]*\\))(,)\\s*", "," + NEW_LINE + INDENT)).map(item -> item.replaceAll("\\((\\w|\\'|\"|\\`)", "( $1")).map(item -> item.replaceAll("(\\w|\\'|\"|\\`)\\)", "$1 )")).map(item -> item.replaceAll("(?i)( )*(" + SQL_KEYWORDS_REGEX + ")( )+", NEW_LINE + "$2" + NEW_LINE + INDENT).toUpperCase()).map(item -> item.replaceAll("(?i)(" + SQL_INDENTED_KEYWORDS_REGEX + ")", NEW_LINE + "  $1").toUpperCase()).map(item -> item.replaceAll("(?i)(" + SQL_LOGICAL_OPERATORS_REGEX + ")", "$1" + NEW_LINE).toUpperCase()).map(item -> item.replaceAll("(?i)(" + SQL_OPERATORS_REGEX + ")", " $1 ")).collect(StringBuilder::new, (sb, s) -> sb.append((String)s).append(NEW_LINE), StringBuilder::append).toString();
    }

    public static String camelCase(String target) {
        String replacedString = target.replace("_", " ").replace("-", " ");
        String[] words = replacedString.split("\\s+");
        return IntStream.range(0, words.length).mapToObj(i -> i == 0 ? words[i].toLowerCase() : StringUtil.ucFirst(words[i].toLowerCase())).collect(Collectors.joining());
    }

    public static String ucFirst(String target) {
        return target.substring(0, 1).toUpperCase() + target.substring(1);
    }

    public static String lcFirst(String target) {
        return target.substring(0, 1).toLowerCase() + target.substring(1);
    }

    public static String kebabCase(String target) {
        return target.toLowerCase().replaceAll("\\s+", "-");
    }

    public static String snakeCase(String target) {
        return target.toLowerCase().replaceAll("\\s+", "_");
    }

    public static String pascalCase(String target) {
        return StringUtil.ucFirst(StringUtil.camelCase(target));
    }

    public static String pluralize(String word) {
        Object result = word;
        if (((String)result).endsWith("s")) {
            result = ((String)result).endsWith("ss") || ((String)result).endsWith("us") ? (String)result + "es" : (String)result + "s";
        } else if (((String)result).endsWith("y")) {
            String lastTwoChars = ((String)result).length() > 1 ? ((String)result).substring(((String)result).length() - 2).toLowerCase() : "";
            List<String> suffixes = Arrays.asList("ay", "ey", "iy", "oy", "uy");
            result = suffixes.contains(lastTwoChars) ? (String)result + "s" : ((String)result).substring(0, ((String)result).length() - 1) + "ies";
        } else {
            result = StringUtil.endsWithAny((String)result, "x", "s", "z", "ch", "sh") ? (String)result + "es" : (String)result + "s";
        }
        return result;
    }

    public static String singularize(String word) {
        Object result = word;
        if (((String)result).endsWith("s")) {
            result = ((String)result).endsWith("sses") || ((String)result).endsWith("uses") ? ((String)result).substring(0, ((String)result).length() - 2) : (((String)result).endsWith("ies") ? ((String)result).substring(0, ((String)result).length() - 3) + "y" : (((String)result).endsWith("es") ? (((String)result).length() > 3 && StringUtil.endsWithAny((String)result, "shes", "ches") ? ((String)result).substring(0, ((String)result).length() - 2) : ((String)result).substring(0, ((String)result).length() - 1)) : ((String)result).substring(0, ((String)result).length() - 1)));
        }
        return result;
    }

    private static boolean endsWithAny(String word, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!word.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

