/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.types.util;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.operators.Compare;
import ortus.boxlang.runtime.operators.StringCompare;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.AsyncService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.util.EncryptionUtil;
import ortus.boxlang.runtime.util.LocalizationUtil;

public class StructUtil {
    public static final Key scopeAll = Key.of("all");

    public static void each(IStruct struct, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads, Boolean ordered) {
        Stream entryStream = struct.entrySet().stream();
        Consumer<Map.Entry> exec = callback.requiresStrictArguments() ? item -> callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue()}) : item -> callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue(), struct});
        if (!parallel.booleanValue()) {
            entryStream.forEach(exec);
        } else if (ordered.booleanValue()) {
            AsyncService.buildExecutor("StructEach_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> ((Stream)entryStream.parallel()).forEachOrdered(exec));
        } else {
            AsyncService.buildExecutor("StructEach_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> ((Stream)entryStream.parallel()).forEach(exec));
        }
    }

    public static Boolean some(IStruct struct, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads) {
        Stream entryStream = struct.entrySet().stream();
        Predicate<Map.Entry> test = callback.requiresStrictArguments() ? item -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue()})) : item -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue(), struct}));
        return parallel == false ? Boolean.valueOf(entryStream.anyMatch(test)) : (Boolean)AsyncService.buildExecutor("structSome_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> ((Stream)entryStream.parallel()).anyMatch(test));
    }

    public static Boolean every(IStruct struct, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads) {
        Stream entryStream = struct.entrySet().stream();
        Predicate<Map.Entry> test = callback.requiresStrictArguments() ? item -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue()})) : item -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue(), struct}));
        return !parallel.booleanValue() ? entryStream.dropWhile(test).toArray().length == 0 : BooleanCaster.cast(AsyncService.buildExecutor("ArrayEvery_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> ((Stream)entryStream.parallel()).dropWhile(test).toArray().length == 0));
    }

    public static Struct filter(IStruct struct, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads) {
        Stream entryStream = struct.entrySet().stream();
        Stream filteredStream = null;
        Predicate<Map.Entry> test = callback.requiresStrictArguments() ? item -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue()})) : item -> BooleanCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue(), struct}));
        filteredStream = parallel == false ? entryStream.filter(test) : (Stream)AsyncService.buildExecutor("StructFilter_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> ((Stream)entryStream.parallel()).filter(test));
        return filteredStream.collect(BLCollector.toStruct(struct.getType()));
    }

    public static Struct map(IStruct struct, Function callback, IBoxContext callbackContext, Boolean parallel, Integer maxThreads) {
        Stream entryStream = struct.entrySet().stream();
        Struct result = new Struct(struct.getType());
        Consumer<Map.Entry> exec = callback.requiresStrictArguments() ? item -> result.put((Key)item.getKey(), callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue()})) : item -> result.put((Key)item.getKey(), callbackContext.invokeFunction((Object)callback, new Object[]{((Key)item.getKey()).getName(), item.getValue(), struct}));
        if (!parallel.booleanValue()) {
            entryStream.forEach(exec);
        } else if (struct.getType().equals((Object)IStruct.TYPES.LINKED)) {
            AsyncService.buildExecutor("StructMap_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> ((Stream)entryStream.parallel()).forEachOrdered(exec));
        } else {
            AsyncService.buildExecutor("StructMap_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> ((Stream)entryStream.parallel()).forEach(exec));
        }
        return result;
    }

    public static Object reduce(IStruct struct, Function callback, IBoxContext callbackContext, Object initialValue) {
        BiFunction<Object, Map.Entry, Object> reduction = callback.requiresStrictArguments() ? (acc, item) -> callbackContext.invokeFunction((Object)callback, new Object[]{acc, ((Key)item.getKey()).getName(), item.getValue()}) : (acc, item) -> callbackContext.invokeFunction((Object)callback, new Object[]{acc, ((Key)item.getKey()).getName(), item.getValue(), struct});
        return struct.entrySet().stream().reduce(initialValue, reduction, (acc, intermediate) -> acc);
    }

    public static Array sort(IStruct struct, String sortType, String sortOrder, String path) {
        if (path == null) {
            Key typeKey = Key.of(sortType + sortOrder);
            if (!StructUtil.getCommonComparators().containsKey(typeKey)) {
                throw new BoxRuntimeException(String.format("The sort directive [%s,%s] is not a valid struct sorting directive", sortType, sortOrder));
            }
            return new Array(struct.keySet().stream().sorted(StructUtil.getCommonComparators().get(typeKey)).map(k -> k.getName()).toArray());
        }
        Boolean isDescending = Key.of(sortOrder).equals(Key.of("desc"));
        return new Array(struct.entrySet().stream().sorted((a, b) -> Compare.invoke(StructUtil.getAtPath(StructCaster.cast(isDescending != false ? b.getValue() : a.getValue()), path), StructUtil.getAtPath(StructCaster.cast(isDescending != false ? a.getValue() : b.getValue()), path), !sortType.toLowerCase().contains("nocase"))).map(e -> ((Key)e.getKey()).getName()).toArray());
    }

    public static Array sort(IStruct struct, Function callback, IBoxContext callbackContext) {
        return new Array(struct.keySet().stream().map(k -> k.getName()).sorted((a, b) -> IntegerCaster.cast(callbackContext.invokeFunction((Object)callback, new Object[]{a, b}))).toArray());
    }

    public static Object getAtPath(IStruct struct, String path) {
        String[] parts2 = path.split("\\.");
        Object ref = null;
        Key refName = Key.of(parts2[0]);
        if (struct.containsKey(refName)) {
            ref = struct.get(refName);
            for (int i = 1; i < parts2.length - 1 && (ref = StructCaster.cast(ref).get(Key.of(parts2[i]))) != null; ++i) {
            }
            return ref;
        }
        return null;
    }

    public static Stream<IStruct> findKey(IStruct struct, String key) {
        int keyLength = key.length();
        IStruct flatMap = StructUtil.toFlatMap(struct);
        return flatMap.entrySet().stream().filter(entry -> {
            String stringKey = ((Key)entry.getKey()).getName().toLowerCase();
            return StringUtils.right(stringKey, keyLength).equals(key.toLowerCase());
        }).map(entry -> {
            Struct returnStruct = new Struct(IStruct.TYPES.LINKED);
            String keyName = ((Key)entry.getKey()).getName();
            String[] keyParts = ((Key)entry.getKey()).getName().split("\\.");
            returnStruct.put(Key.owner, keyParts.length > 1 ? flatMap.get(Key.of(keyName.substring(0, keyName.lastIndexOf(".")))) : struct);
            returnStruct.put(Key.path, (Object)("." + keyName));
            returnStruct.put(Key.value, entry.getValue());
            return returnStruct;
        });
    }

    public static Stream<IStruct> findValue(IStruct struct, Object value) {
        IStruct flatMap = StructUtil.toFlatMap(struct);
        return flatMap.entrySet().stream().filter(entry -> Compare.invoke(value, entry.getValue()) == 0).map(entry -> {
            Struct returnStruct = new Struct(IStruct.TYPES.LINKED);
            String keyName = ((Key)entry.getKey()).getName();
            String[] keyParts = ((Key)entry.getKey()).getName().split("\\.");
            String parentName = keyName;
            if (keyParts.length > 1) {
                parentName = keyName.substring(0, keyName.lastIndexOf("."));
            }
            String finalParent = parentName;
            returnStruct.put(Key.owner, (Object)(keyParts.length > 1 ? StructUtil.unFlattenKeys(flatMap.entrySet().stream().filter(mapEntry -> ((Key)mapEntry.getKey()).getName().contains(finalParent)).map(mapEntry -> new AbstractMap.SimpleEntry(Key.of(((Key)mapEntry.getKey()).getName().replace(finalParent + ".", "")), mapEntry.getValue())).collect(BLCollector.toStruct()), true, false) : struct));
            returnStruct.put(Key.path, (Object)("." + keyName));
            returnStruct.put(Key.key, (Object)keyParts[keyParts.length - 1]);
            return returnStruct;
        });
    }

    public static IStruct deepMerge(IStruct recipient, IStruct merge) {
        return StructUtil.deepMerge(recipient, merge, false);
    }

    public static IStruct deepMerge(IStruct recipient, IStruct merge, boolean override) {
        merge.entrySet().forEach(entry -> {
            Object patt2$temp;
            Object patt0$temp = entry.getValue();
            if (patt0$temp instanceof IStruct) {
                IStruct mergeStruct = (IStruct)patt0$temp;
                Object patt1$temp = recipient.get(entry.getKey());
                if (patt1$temp instanceof IStruct) {
                    IStruct recipStruct = (IStruct)patt1$temp;
                    StructUtil.deepMerge(recipStruct, mergeStruct, override);
                    return;
                }
            }
            if ((patt2$temp = entry.getValue()) instanceof Array) {
                Array merageArray = (Array)patt2$temp;
                Object patt3$temp = recipient.get(entry.getKey());
                if (patt3$temp instanceof Array) {
                    Array recipArray = (Array)patt3$temp;
                    merageArray.stream().forEach(item -> {
                        if (!recipArray.contains(entry.getValue())) {
                            recipArray.add(entry.getValue());
                        }
                    });
                    return;
                }
            }
            if (override) {
                recipient.put((Key)entry.getKey(), entry.getValue());
                return;
            }
            recipient.putIfAbsent((Key)entry.getKey(), entry.getValue());
        });
        return recipient;
    }

    public static IStruct toFlatMap(IStruct struct) {
        return new Struct(struct.getType(), struct.entrySet().stream().flatMap(StructUtil::flattenEntry).collect(Collectors.toMap(entry -> (Key)entry.getKey(), entry -> entry.getValue(), (v1, v2) -> {
            throw new BoxRuntimeException("An exception occurred while flattening the struct");
        }, LinkedHashMap::new)));
    }

    public static Stream<Map.Entry<Key, Object>> flattenEntry(Map.Entry<Key, Object> entry) {
        java.util.function.Function<Map.Entry, AbstractMap.SimpleEntry> flattener = e -> new AbstractMap.SimpleEntry(Key.of(((Key)entry.getKey()).getName() + "." + ((Key)e.getKey()).getName()), e.getValue());
        if (entry.getValue() instanceof Map) {
            IStruct nested = StructCaster.cast(entry.getValue());
            return nested.entrySet().stream().map(flattener).flatMap(StructUtil::flattenEntry);
        }
        return Stream.of(entry);
    }

    public static IStruct unFlattenKeys(IStruct struct, boolean deep, boolean retainKeys) {
        for (Key k : struct.getKeys()) {
            int index;
            String key = k.getName();
            Object value = struct.get(k);
            if (deep && value instanceof IStruct) {
                StructUtil.unFlattenKeys(StructCaster.cast(value), deep, retainKeys);
            }
            if ((index = key.indexOf(46)) == -1) continue;
            StructUtil.unFlattenKey(index, k, key, struct, retainKeys);
        }
        return struct;
    }

    public static void unFlattenKey(int index, Key key, String keyValue, IStruct original, boolean retainKeys) {
        Object value = original.get(key);
        IStruct destination = original;
        if (!retainKeys) {
            original.remove(key);
        }
        do {
            String left = keyValue.substring(0, index);
            keyValue = keyValue.substring(index + 1);
            Key destinationKey = Key.of(left);
            if (!destination.containsKey(destinationKey)) {
                destination.put(destinationKey, (Object)new Struct());
            }
            destination = destination.getAsStruct(destinationKey);
        } while ((index = keyValue.indexOf(46)) != -1);
        destination.put(Key.of(keyValue), value);
    }

    public static String toQueryString(IStruct struct, String delimiter) {
        return struct.entrySet().stream().map(entry -> EncryptionUtil.urlEncode(((Key)entry.getKey()).getName().trim()) + "=" + EncryptionUtil.urlEncode(entry.getValue().toString().trim())).collect(Collectors.joining(delimiter));
    }

    public static String toQueryString(IStruct struct) {
        return StructUtil.toQueryString(struct, "&");
    }

    public static IStruct fromQueryString(String target, String delimiter) {
        if ((target = target.trim()).length() == 0) {
            return new Struct(IStruct.TYPES.LINKED);
        }
        if (target.startsWith("?")) {
            target = target.substring(1);
        }
        return new Struct(IStruct.TYPES.LINKED, Stream.of(target.split(delimiter)).map(pair -> pair.split("=")).collect(Collectors.toMap(pair -> Key.of(EncryptionUtil.urlDecode(pair[0]).trim()), pair -> ((String[])pair).length > 1 ? EncryptionUtil.urlDecode(pair[1]).trim() : "")));
    }

    public static IStruct fromQueryString(String target) {
        return StructUtil.fromQueryString(target, "&");
    }

    public static HashMap<Key, Comparator<Key>> getCommonComparators() {
        return StructUtil.getCommonComparators(LocalizationUtil.COMMON_LOCALES.get(Key.of("US")));
    }

    public static HashMap<Key, Comparator<Key>> getCommonComparators(final Locale locale) {
        return new HashMap<Key, Comparator<Key>>(){
            {
                this.put(Key.of("textAsc"), (a, b) -> StringCompare.invoke(StringCaster.cast(a), StringCaster.cast(b), true, locale));
                this.put(Key.of("textDesc"), (b, a) -> StringCompare.invoke(StringCaster.cast(a), StringCaster.cast(b), true, locale));
                this.put(Key.of("textNoCaseAsc"), (a, b) -> StringCompare.invoke(StringCaster.cast(a), StringCaster.cast(b), false, locale));
                this.put(Key.of("textNoCaseDesc"), (b, a) -> StringCompare.invoke(StringCaster.cast(a), StringCaster.cast(b), false, locale));
                this.put(Key.of("numericAsc"), (a, b) -> {
                    CastAttempt<Number> aNum = NumberCaster.attempt(a.getOriginalValue());
                    CastAttempt<Number> bNum = null;
                    return aNum.wasSuccessful() && (bNum = NumberCaster.attempt(b.getOriginalValue())).wasSuccessful() ? Compare.invoke(aNum.get(), bNum.get()) : Compare.invoke(a.toString(), b.toString(), true);
                });
                this.put(Key.of("numericDesc"), (b, a) -> {
                    CastAttempt<Number> aNum = NumberCaster.attempt(a.getOriginalValue());
                    CastAttempt<Number> bNum = null;
                    return aNum.wasSuccessful() && (bNum = NumberCaster.attempt(b.getOriginalValue())).wasSuccessful() ? Compare.invoke(aNum.get(), bNum.get()) : Compare.invoke(a.toString(), b.toString(), true);
                });
            }
        };
    }
}

