/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.GenericCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.IntKey;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.NullValue;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class ArgumentUtil {
    public static ArgumentsScope createArgumentsScope(IBoxContext context, Object[] positionalArguments, Argument[] arguments, ArgumentsScope scope, Key functionName) {
        int i;
        scope.setPositional(true);
        for (i = 0; i < positionalArguments.length; ++i) {
            Key name;
            Object value = positionalArguments[i];
            if (arguments.length - 1 >= i) {
                name = arguments[i].name();
                value = ArgumentUtil.ensureArgumentType(context, name, value, arguments[i].type(), functionName);
            } else {
                name = Key.of(i + 1);
            }
            if (value == null && arguments.length - 1 >= i && arguments[i].hasDefaultValue()) {
                value = ArgumentUtil.ensureArgumentType(context, name, arguments[i].getDefaultValue(context), arguments[i].type(), functionName);
            }
            scope.put(name, value);
        }
        if (arguments.length > scope.size()) {
            for (i = scope.size(); i < arguments.length; ++i) {
                if (arguments[i].required() && !arguments[i].hasDefaultValue()) {
                    throw new BoxRuntimeException("Required argument [" + arguments[i].name().getName() + "] is missing for function [" + functionName.getName() + "]");
                }
                scope.put(arguments[i].name(), ArgumentUtil.ensureArgumentType(context, arguments[i].name(), arguments[i].getDefaultValue(context), arguments[i].type(), functionName));
            }
        }
        return scope;
    }

    public static ArgumentsScope createArgumentsScope(IBoxContext context, Map<Key, Object> namedArguments, Argument[] arguments, ArgumentsScope scope, Key functionName) {
        if (namedArguments.containsKey(Function.ARGUMENT_COLLECTION)) {
            LinkedHashMap<Key, Object> copyofNamedArguments = new LinkedHashMap<Key, Object>();
            copyofNamedArguments.putAll(namedArguments);
            namedArguments = copyofNamedArguments;
            Object argCollection = namedArguments.get(Function.ARGUMENT_COLLECTION);
            List listCollection = null;
            if (argCollection instanceof ArgumentsScope) {
                ArgumentsScope as = (ArgumentsScope)argCollection;
                LinkedHashMap<Key, Object> copyofArgCol = new LinkedHashMap<Key, Object>();
                copyofArgCol.putAll(as);
                int i = 0;
                for (Argument argument : arguments) {
                    IntKey intKey = Key.of(++i);
                    if (namedArguments.containsKey(argument.name())) {
                        copyofArgCol.remove(argument.name());
                        continue;
                    }
                    if (copyofArgCol.containsKey(argument.name())) {
                        namedArguments.put(argument.name(), copyofArgCol.get(argument.name()));
                        copyofArgCol.remove(argument.name());
                        continue;
                    }
                    if (copyofArgCol.containsKey(intKey)) {
                        namedArguments.put(argument.name(), copyofArgCol.get(intKey));
                        copyofArgCol.remove(intKey);
                        continue;
                    }
                    namedArguments.put(argument.name(), null);
                }
                namedArguments.putAll(copyofArgCol);
                namedArguments.remove(Function.ARGUMENT_COLLECTION);
            } else if (argCollection instanceof Map) {
                Map argumentCollection = (Map)argCollection;
                scope.putAll(argumentCollection);
                namedArguments.remove(Function.ARGUMENT_COLLECTION);
            } else if (argCollection instanceof List) {
                listCollection = (List)argCollection;
                for (int i = 0; i < listCollection.size(); ++i) {
                    Object value = listCollection.get(i);
                    Key name = arguments.length - 1 >= i ? arguments[i].name() : Key.of(i + 1);
                    scope.put(name, value);
                }
                namedArguments.remove(Function.ARGUMENT_COLLECTION);
            }
        }
        scope.putAll((Map<? extends Key, ? extends Object>)namedArguments);
        for (Argument argument : arguments) {
            if (!scope.containsKey(argument.name()) || scope.get(argument.name()) == null) {
                if (argument.required() && !argument.hasDefaultValue()) {
                    throw new BoxRuntimeException("Required argument " + argument.name().getName() + " is missing for function " + functionName.getName());
                }
                scope.put(argument.name(), ArgumentUtil.ensureArgumentType(context, argument.name(), argument.getDefaultValue(context), argument.type(), functionName));
                continue;
            }
            scope.put(argument.name(), ArgumentUtil.ensureArgumentType(context, argument.name(), scope.get(argument.name()), argument.type(), functionName));
        }
        return scope;
    }

    public static ArgumentsScope createArgumentsScope(IBoxContext context, Object[] positionalArguments) {
        ArgumentsScope scope = new ArgumentsScope().setPositional(true);
        for (int i = 0; i < positionalArguments.length; ++i) {
            scope.put(Key.of(i + 1), positionalArguments[i]);
        }
        return scope;
    }

    public static ArgumentsScope createArgumentsScope(IBoxContext context, Map<Key, Object> namedArguments) {
        ArgumentsScope scope = new ArgumentsScope();
        Object object = namedArguments.get(Key.argumentCollection);
        if (object instanceof IStruct) {
            IStruct argCol = (IStruct)object;
            scope.putAll(argCol);
            namedArguments.remove(Key.argumentCollection);
        }
        scope.putAll((Map<? extends Key, ? extends Object>)namedArguments);
        return scope;
    }

    public static ArgumentsScope createArgumentsScope(IBoxContext context, Argument[] arguments, ArgumentsScope scope, Key functionName) {
        return ArgumentUtil.createArgumentsScope(context, new Object[0], arguments, scope, functionName);
    }

    public static Object ensureArgumentType(IBoxContext context, Key name, Object value, String type, Key functionName) {
        if (value == null) {
            return null;
        }
        CastAttempt<Object> typeCheck = GenericCaster.attempt(context, value, type, true);
        if (!typeCheck.wasSuccessful()) {
            throw new BoxRuntimeException(String.format("In function [%s], argument [%s] with a type of [%s] does not match the declared type of [%s]", functionName.getName(), name.getName(), DynamicObject.unWrap(value).getClass().getName(), type));
        }
        Object result = typeCheck.get();
        if (result instanceof NullValue) {
            return null;
        }
        return result;
    }

    public static Map<Key, Object> positionalToMap(Object ... args) {
        LinkedHashMap<Key, Object> map = new LinkedHashMap<Key, Object>();
        for (int i = 0; i < args.length; ++i) {
            map.put(Key.of(i + 1), args[i]);
        }
        return map;
    }

    public static Map<Key, Object> mapArgumentsToDeclaredArguments(Map<Key, Object> args, Argument[] declaredArguments) {
        for (int i = 0; i < declaredArguments.length; ++i) {
            Argument declaredArgument = declaredArguments[i];
            if (!args.containsKey(Key.of(i + 1))) continue;
            args.put(declaredArgument.name(), args.get(Key.of(i + 1)));
            args.remove(Key.of(i + 1));
        }
        return args;
    }
}

