/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.nio.file.Path;
import java.util.Arrays;
import ortus.boxlang.runtime.util.FQN;

public class BoxFQN
extends FQN {
    public BoxFQN(Path root, Path filePath) {
        super(root, filePath);
    }

    private BoxFQN(String[] parts2) {
        super(parts2);
    }

    public BoxFQN(Path path) {
        super(path);
    }

    public BoxFQN(String path) {
        super(path);
    }

    public BoxFQN(String prefix, FQN fqn) {
        super(prefix, fqn);
    }

    public BoxFQN(String prefix, String path) {
        super(prefix, path);
    }

    public BoxFQN(String prefix, Path path) {
        super(prefix, path);
    }

    @Override
    public BoxFQN getPackage() {
        if (this.parts.length > 1) {
            return new BoxFQN(Arrays.copyOfRange(this.parts, 0, this.parts.length - 1));
        }
        return new BoxFQN(new String[0]);
    }

    @Override
    protected String[] parseParts(String fqn) {
        if ((fqn = this.normalizeDots(fqn)).isEmpty()) {
            return new String[0];
        }
        return (String[])Arrays.stream(fqn.split("\\.")).toArray(String[]::new);
    }

    @Override
    protected String cleanFileName(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0) {
            fileName = fileName.substring(0, dotIndex);
        }
        return fileName;
    }

    public static BoxFQN of(String prefix, String path) {
        return new BoxFQN(prefix, path);
    }

    public static BoxFQN of(String prefix, Path path) {
        return new BoxFQN(prefix, path);
    }

    public static BoxFQN of(String path) {
        return new BoxFQN(path);
    }

    public static BoxFQN of(Path path) {
        return new BoxFQN(path);
    }

    @Override
    public BoxFQN appendPrefix(String prefix) {
        return new BoxFQN(prefix, this);
    }
}

