/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class CLIUtil {
    public static IStruct parseArguments(String[] args) {
        return CLIUtil.parseArguments(new ArrayList<String>(Arrays.asList(args)));
    }

    public static IStruct parseArguments(List<String> args) {
        Struct options = new Struct();
        Array positionalArgs = new Array();
        block0: for (String arg : args) {
            if (arg.startsWith("--")) {
                Boolean value;
                String key;
                if (arg.startsWith("--!") || arg.startsWith("--no-")) {
                    key = arg.startsWith("--!") ? arg.substring(3).trim() : arg.substring(5).trim();
                    value = false;
                } else {
                    String[] parts2 = arg.split("=", 2);
                    key = parts2[0].substring(2).trim();
                    value = parts2.length == 1 ? Boolean.valueOf(true) : CLIUtil.cleanQuotedValue(parts2[1].trim());
                }
                options.put(key, (Object)value);
                continue;
            }
            if (arg.startsWith("-") && arg.length() > 1) {
                for (int i = 1; i < arg.length(); ++i) {
                    String key = String.valueOf(arg.charAt(i));
                    Object value = true;
                    if (i == 1 && arg.length() > 2 && arg.charAt(2) == '=') {
                        value = CLIUtil.cleanQuotedValue(arg.substring(3).trim());
                        options.put(key, value);
                        continue block0;
                    }
                    options.put(key, value);
                }
                continue;
            }
            positionalArgs.add(arg);
        }
        return Struct.of(new Object[]{"options", options, "positionals", positionalArgs});
    }

    private static String cleanQuotedValue(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

