/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.DoubleCaster;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.LongCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.JSONUtil;
import ortus.boxlang.runtime.util.FileSystemUtil;

public class DataNavigator {
    public static Navigator ofPath(Object filePath) {
        Object castedFilePath;
        if (filePath instanceof String) {
            castedFilePath = (String)filePath;
            filePath = Paths.get((String)castedFilePath, new String[0]);
        }
        if (filePath instanceof Path) {
            castedFilePath = (Path)filePath;
            return new Navigator((Path)castedFilePath);
        }
        throw new BoxRuntimeException("The file path must be a String or a Path");
    }

    public static Navigator ofJson(String json) {
        Object data = JSONUtil.fromJSON(json);
        if (data instanceof Map) {
            Map map = (Map)data;
            return new Navigator(Struct.fromMap(map));
        }
        throw new BoxRuntimeException("The JSON data must be a Map and it's a [" + data.getClass().getName() + "]");
    }

    public static Navigator of(Object data) {
        String filePath;
        if (data instanceof Path) {
            return DataNavigator.ofPath(data);
        }
        if (data instanceof String && FileSystemUtil.isValidFilePath(filePath = (String)data).booleanValue()) {
            return DataNavigator.ofPath(filePath);
        }
        if (data instanceof String) {
            return DataNavigator.ofJson(StringCaster.cast(data));
        }
        if (data instanceof IStruct) {
            IStruct struct = (IStruct)data;
            return new Navigator(struct);
        }
        if (data instanceof Map) {
            Map map = (Map)data;
            return new Navigator(Struct.fromMap(map));
        }
        throw new BoxRuntimeException("The data is not a valid type for navigation. \nIt must be a Map, a Struct, a JSON string, or file path to a JSON file, etc.");
    }

    public static class Navigator {
        private IStruct config;
        private IStruct segment;

        public Navigator(Path filePath) {
            this.parseFile(filePath);
        }

        public Navigator(IStruct data) {
            this.config = data;
        }

        public boolean isEmpty() {
            return this.segment == null ? this.config.isEmpty() : this.segment.isEmpty();
        }

        public boolean isPresent() {
            return !this.isEmpty();
        }

        public Navigator ifPresent(String key, Consumer<Object> consumer) {
            IStruct navConfig;
            IStruct iStruct = navConfig = this.segment == null ? this.config : this.segment;
            if (navConfig.containsKey(key)) {
                consumer.accept(this.get(key));
            }
            return this;
        }

        public Navigator ifPresentOrElse(String key, Consumer<Object> consumer, Runnable orElse) {
            IStruct navConfig;
            IStruct iStruct = navConfig = this.segment == null ? this.config : this.segment;
            if (navConfig.containsKey(key)) {
                consumer.accept(this.get(key));
            } else {
                orElse.run();
            }
            return this;
        }

        public boolean has(String ... path) {
            IStruct navConfig = this.segment == null ? this.config : this.segment;
            Object lastResult = null;
            for (String targetKey : path) {
                if (!navConfig.containsKey(targetKey)) {
                    return false;
                }
                lastResult = navConfig.get(Key.of(targetKey));
                if (!(lastResult instanceof Map)) continue;
                navConfig = StructCaster.cast(lastResult);
            }
            return true;
        }

        public Navigator from(String ... path) {
            IStruct navConfig = this.config;
            Struct lastResult = null;
            for (String thisPath : path) {
                lastResult = !navConfig.containsKey(thisPath) ? new Struct() : navConfig.get(Key.of(thisPath));
                if (!(lastResult instanceof Map)) {
                    throw new BoxRuntimeException("The requested segment is not a Struct, but a [" + lastResult.getClass().getName() + "]");
                }
                navConfig = this.segment = StructCaster.cast(lastResult);
            }
            return this;
        }

        public Object get(String key, Object defaultValue) {
            Object result = this.get(key);
            return result == null ? defaultValue : result;
        }

        public Object getOrThrow(String ... key) {
            Object result = this.get(key);
            if (result == null) {
                throw new BoxRuntimeException("The key [" + String.valueOf(key) + "] does not exist in the json contents. Top level keys are: " + String.valueOf(this.config.keySet()));
            }
            return result;
        }

        public Object get(String ... key) {
            IStruct navConfig = this.segment == null ? this.config : this.segment;
            Object lastResult = null;
            for (String targetKey : key) {
                if (!navConfig.containsKey(targetKey)) {
                    lastResult = null;
                    break;
                }
                lastResult = navConfig.get(Key.of(targetKey));
                if (!(lastResult instanceof Map)) continue;
                navConfig = StructCaster.cast(lastResult);
            }
            if (lastResult instanceof Map) {
                Map map = lastResult;
                return StructCaster.cast(map);
            }
            if (lastResult instanceof List) {
                List list = lastResult;
                return ArrayCaster.cast(list);
            }
            if (lastResult instanceof Object[]) {
                Object[] array = lastResult;
                return ArrayCaster.cast(array);
            }
            return lastResult;
        }

        public Key getAsKey(String key, Object defaultValue) {
            return Key.of(StringCaster.cast(this.get(key, defaultValue)));
        }

        public Key getAsKey(String ... key) {
            return Key.of(StringCaster.cast(this.get(key)));
        }

        public String getAsString(String key, Object defaultValue) {
            return StringCaster.cast(this.get(key, defaultValue));
        }

        public String getAsString(String ... key) {
            return StringCaster.cast(this.get(key));
        }

        public Boolean getAsBoolean(String key, Object defaultValue) {
            return BooleanCaster.cast(this.get(key, defaultValue));
        }

        public Boolean getAsBoolean(String ... key) {
            return BooleanCaster.cast(this.get(key));
        }

        public Integer getAsInteger(String key, Object defaultValue) {
            return IntegerCaster.cast(this.get(key, defaultValue));
        }

        public Integer getAsInteger(String ... key) {
            return IntegerCaster.cast(this.get(key));
        }

        public DateTime getAsDate(String key, Object defaultValue) {
            return DateTimeCaster.cast(this.get(key, defaultValue));
        }

        public DateTime getAsDate(String ... key) {
            return DateTimeCaster.cast(this.get(key));
        }

        public Long getAsLong(String key, Object defaultValue) {
            return LongCaster.cast(this.get(key, defaultValue));
        }

        public Long getAsLong(String ... key) {
            return LongCaster.cast(this.get(key));
        }

        public Double getAsDouble(String key, Object defaultValue) {
            return DoubleCaster.cast(this.get(key, defaultValue));
        }

        public Double getAsDouble(String ... key) {
            return DoubleCaster.cast(this.get(key));
        }

        public IStruct getAsStruct(String key, Object defaultValue) {
            return StructCaster.cast(this.get(key, defaultValue));
        }

        public IStruct getAsStruct(String ... key) {
            return StructCaster.cast(this.get(key));
        }

        public Array getAsArray(String key, Object defaultValue) {
            return ArrayCaster.cast(this.get(key, defaultValue));
        }

        public Array getAsArray(String ... key) {
            return ArrayCaster.cast(this.get(key));
        }

        private void parseFile(Path filePath) {
            try {
                Object rawConfig = JSONUtil.fromJSON(Files.readString(filePath.toAbsolutePath(), StandardCharsets.UTF_8));
                if (rawConfig instanceof Map) {
                    Map rawMap = (Map)rawConfig;
                    this.config = Struct.fromMap(rawMap);
                }
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
    }
}

