/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.components.jdbc.Query;
import ortus.boxlang.runtime.context.ContainerBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.context.ScriptingRequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.runnables.ITemplateRunnable;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.NullValue;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.AbortException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;
import ortus.boxlang.runtime.types.util.JSONUtil;

public class DumpUtil {
    private static final ThreadLocal<Set<Integer>> dumpedObjects = ThreadLocal.withInitial(HashSet::new);
    private static final ConcurrentMap<String, String> dumpTemplateCache = new ConcurrentHashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(DumpUtil.class);
    private static final String TEMPLATES_BASE_PATH = "/dump/html/";
    private static final String DEFAULT_DUMP_TEMPLATE = "Class.bxm";

    public static void dump(IBoxContext context, Object target, String label, Integer top, Boolean expand, Boolean abort, String output, String format, Boolean showUDFs) {
        if ((output = output.toLowerCase()).equals("browser")) {
            output = "buffer";
        }
        format = format == null ? (output.equals("console") || context.getParentOfType(RequestBoxContext.class) instanceof ScriptingRequestBoxContext ? "text" : "html") : format.toLowerCase();
        context.getRuntime().announce(BoxEvent.ON_BXDUMP, Struct.of(new Object[]{Key.context, context, Key.target, target, Key.label, label, Key.top, top, Key.expand, expand, Key.abort, abort, Key.output, output, Key.format, format, Key.showUDFs, showUDFs}));
        switch (output) {
            case "console": {
                DumpUtil.dumpToConsole(context, target, label);
                break;
            }
            case "buffer": {
                if (format.equals("html")) {
                    DumpUtil.dumpHTMLToBuffer(context, target, label, top, expand, abort, output, format, showUDFs);
                    break;
                }
                DumpUtil.dumpTextToBuffer(context, target);
                break;
            }
            default: {
                if (output.isEmpty()) {
                    throw new BoxRuntimeException("The output parameter is required.");
                }
                context.getRuntime().getInterceptorService().announce(BoxEvent.ON_MISSING_DUMP_OUTPUT, Struct.of(new Object[]{Key.context, context, Key.target, target, Key.label, label, Key.top, top, Key.expand, expand, Key.abort, abort, Key.output, output, Key.format, format, Key.showUDFs, showUDFs}));
            }
        }
        if (abort.booleanValue()) {
            if (output.equals("buffer")) {
                context.writeToBuffer("\t<div style=\"display: inline-block; padding: 8px 12px; background-color: #ff4d4d; color: white; font-weight: bold; border-radius: 5px;\">\n\t\tDump Aborted\n\t</div>\n", true);
            }
            context.flushBuffer(true);
            throw new AbortException("request", null);
        }
    }

    public static void dumpToConsole(IBoxContext context, Object target, String label) {
        PrintStream out = context.getParentOfType(RequestBoxContext.class).getOut();
        if (label != null && !label.isEmpty()) {
            out.println("============================================");
            out.println(label);
            out.println("============================================");
        }
        if (target instanceof IClassRunnable) {
            IClassRunnable castedTarget = (IClassRunnable)target;
            try {
                out.println("> " + castedTarget.getBoxMeta().getMeta().getAsString(Key._NAME));
                out.println(JSONUtil.getJSONBuilder().asString(castedTarget));
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Error serializing class to JSON", e);
            }
        } else if (target == null) {
            out.println("[null]");
        } else {
            out.println(target.toString());
        }
    }

    public static void dumpTextToBuffer(IBoxContext context, Object target) {
        if (target == null) {
            context.writeToBuffer("[null]\n", true);
        } else {
            context.writeToBuffer(target.toString() + "\n", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpHTMLToBuffer(IBoxContext context, Object target, String label, Integer top, Boolean expand, Boolean abort, String output, String format, Boolean showUDFs) {
        Set<Integer> dumped = dumpedObjects.get();
        boolean outerDump = dumped.isEmpty();
        Integer thisHashCode = System.identityHashCode(target);
        if (!dumped.add(thisHashCode)) {
            context.writeToBuffer("<div><em>Recursive Reference (Skipping dump)</em></div>", true);
            return;
        }
        String posInCode = "";
        String dumpTemplate = null;
        StringBuffer buffer = null;
        String templateName = DumpUtil.discoverTemplateName(target);
        try {
            dumpTemplate = DumpUtil.getDumpTemplate(context, templateName);
            ContainerBoxContext dumpContext = new ContainerBoxContext(context);
            if (outerDump) {
                buffer = new StringBuffer();
                context.pushBuffer(buffer);
                posInCode = ExceptionUtil.getCurrentPositionInCode();
                dumpContext.writeToBuffer("<style>" + DumpUtil.getDumpTemplate(context, "Dump.css") + "</style>", true);
                dumpContext.writeToBuffer("<script>" + DumpUtil.getDumpTemplate(context, "Dump.js") + "</script>");
            }
            dumpContext.getScopeNearby(VariablesScope.name).putAll(Struct.of(new Object[]{Key.posInCode, posInCode, Key.var, target, Key.label, label, Key.top, top, Key.expand, expand, Key.abort, abort, Key.showUDFs, showUDFs}));
            context.getRuntime().executeSource(dumpTemplate, dumpContext, BoxSourceType.BOXTEMPLATE);
        }
        finally {
            dumped.remove(thisHashCode);
            if (outerDump) {
                dumpedObjects.remove();
                context.popBuffer();
                if (buffer != null) {
                    context.writeToBuffer(buffer.toString(), true);
                }
            }
        }
    }

    private static String discoverTemplateName(Object target) {
        if (target == null || target instanceof NullValue) {
            return "Null.bxm";
        }
        if (target instanceof Throwable) {
            return "Throwable.bxm";
        }
        if (target instanceof Query) {
            return "Query.bxm";
        }
        if (target instanceof Function) {
            return "Function.bxm";
        }
        if (target instanceof IScope) {
            return "Struct.bxm";
        }
        if (target instanceof Key) {
            return "Key.bxm";
        }
        if (target instanceof DateTime) {
            return "DateTime.bxm";
        }
        if (target instanceof LocalDate || target instanceof LocalDateTime || target instanceof ZonedDateTime || target instanceof Date || target instanceof Timestamp || target instanceof java.util.Date) {
            target = DateTimeCaster.cast(target);
            return "DateTime.bxm";
        }
        if (target instanceof Duration || target instanceof ZoneId) {
            return "ToString.bxm";
        }
        if (target instanceof Instant) {
            return "Instant.bxm";
        }
        if (target instanceof IClassRunnable) {
            return "BoxClass.bxm";
        }
        if (target instanceof ITemplateRunnable) {
            ITemplateRunnable castedTarget = (ITemplateRunnable)target;
            target = castedTarget.getRunnablePath();
            return "ITemplateRunnable.bxm";
        }
        if (target instanceof IStruct) {
            return "Struct.bxm";
        }
        if (target instanceof IType) {
            return target.getClass().getSimpleName().replace("Unmodifiable", "") + ".bxm";
        }
        if (target instanceof String) {
            return "String.bxm";
        }
        if (target instanceof Number) {
            return "Number.bxm";
        }
        if (target instanceof Boolean) {
            return "Boolean.bxm";
        }
        if (target.getClass().isArray()) {
            target = ArrayCaster.cast(target);
            return "Array.bxm";
        }
        if (target instanceof StringBuffer || target instanceof StringBuilder) {
            return "StringBuffer.bxm";
        }
        if (target instanceof Map) {
            return "Map.bxm";
        }
        if (target instanceof List) {
            return "List.bxm";
        }
        return DEFAULT_DUMP_TEMPLATE;
    }

    private static String getDumpTemplate(IBoxContext context, String dumpTemplateName) {
        String dumpTemplatePath = TEMPLATES_BASE_PATH + dumpTemplateName;
        if (context.getRuntime().inDebugMode().booleanValue()) {
            return DumpUtil.computeDumpTemplate(dumpTemplatePath, context);
        }
        return dumpTemplateCache.computeIfAbsent(dumpTemplatePath, key -> DumpUtil.computeDumpTemplate(dumpTemplatePath, context));
    }

    private static String computeDumpTemplate(String dumpTemplatePath, IBoxContext context) {
        Path filePath;
        Objects.requireNonNull(dumpTemplatePath, "dumpTemplatePath cannot be null");
        InputStream dumpTemplate = null;
        dumpTemplate = DumpUtil.class.getResourceAsStream(dumpTemplatePath);
        if (!context.getRuntime().inJarMode() && context.getRuntime().inDebugMode().booleanValue() && Files.exists(filePath = Paths.get("src", "main", "resources", dumpTemplatePath).toAbsolutePath(), new LinkOption[0])) {
            try {
                dumpTemplate = Files.newInputStream(filePath, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new BoxRuntimeException(dumpTemplatePath + " not found", e);
            }
        }
        if (dumpTemplate == null) {
            throw new BoxRuntimeException("Could not load dump template from class path or filesystem: " + dumpTemplatePath);
        }
        try (Scanner s = new Scanner(dumpTemplate).useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }
}

