/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.SerializationUtils;
import ortus.boxlang.runtime.bifs.global.type.NullValue;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;

public class DuplicationUtil {
    public static Object duplicate(Object target, Boolean deep) {
        if (target == null) {
            return null;
        }
        if (ClassUtils.isPrimitiveOrWrapper(target.getClass())) {
            return target;
        }
        if (target instanceof String || target instanceof Number || target instanceof Character) {
            return target;
        }
        if (target instanceof Enum || target instanceof Class) {
            return target;
        }
        if (target instanceof IStruct) {
            IStruct str = (IStruct)target;
            return DuplicationUtil.duplicateStruct(str, deep);
        }
        if (target instanceof Array) {
            Array arr = (Array)target;
            return DuplicationUtil.duplicateArray(arr, deep);
        }
        if (target instanceof Query) {
            Query arr = (Query)target;
            return DuplicationUtil.duplicateQuery(arr, deep);
        }
        if (target instanceof DateTime) {
            DateTime dateTimeInstance = (DateTime)target;
            return dateTimeInstance.clone();
        }
        if (target instanceof Function) {
            return target;
        }
        if (target instanceof Throwable) {
            Throwable t = (Throwable)target;
            return ExceptionUtil.throwableToStruct(t);
        }
        if (target instanceof Serializable) {
            return SerializationUtils.clone((Serializable)target);
        }
        throw new BoxRuntimeException(String.format("Duplication was requested on the class [%s] but we don't know how to proceed", target.getClass().getSimpleName()));
    }

    public static Struct duplicateStruct(IStruct target, Boolean deep) {
        Stream entries = target.entrySet().stream();
        if (target.getType().equals((Object)IStruct.TYPES.LINKED)) {
            return new Struct(target.getType(), entries.collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Object val = entry.getValue();
                if (val == null) {
                    val = new NullValue();
                }
                return deep != false && val instanceof IStruct ? DuplicationUtil.duplicateStruct(StructCaster.cast(val), deep) : (val instanceof Array ? DuplicationUtil.duplicateArray(ArrayCaster.cast(val), deep) : val);
            }, (v1, v2) -> {
                throw new BoxRuntimeException("An exception occurred while duplicating the linked HashMap");
            }, LinkedHashMap::new)));
        }
        if (target.getType().equals((Object)IStruct.TYPES.SORTED)) {
            return new Struct(target.getType(), entries.collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Object val = entry.getValue();
                return DuplicationUtil.processStructAssignment(val, deep);
            }, (v1, v2) -> {
                throw new BoxRuntimeException("An exception occurred while duplicating the linked HashMap");
            }, ConcurrentSkipListMap::new)));
        }
        return new Struct(target.getType(), (Map<? extends Object, ? extends Object>)entries.collect(Collectors.toConcurrentMap(Map.Entry::getKey, entry -> DuplicationUtil.processStructAssignment(entry.getValue(), deep))));
    }

    public static Object processStructAssignment(Object val, Boolean deep) {
        if (val == null) {
            return new NullValue();
        }
        if (!deep.booleanValue()) {
            return val;
        }
        return DuplicationUtil.duplicate(val, deep);
    }

    public static Array duplicateArray(Array target, Boolean deep) {
        return new Array(target.intStream().mapToObj(idx -> deep != false ? DuplicationUtil.duplicate(target.get(idx), deep) : target.get(idx)).toArray());
    }

    private static Object duplicateQuery(Query target, Boolean deep) {
        return target.duplicate(deep);
    }
}

