/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.HexFormat;
import java.util.stream.IntStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public final class EncryptionUtil {
    private static final SecureRandom secureRandom = new SecureRandom();
    public static final String DEFAULT_HASH_ALGORITHM = "MD5";
    public static final String DEFAULT_ENCRYPTION_ALGORITHM = "AES";
    public static final String DEFAULT_ENCRYPTION_ENCODING = "UU";
    public static final int DEFAULT_ENCRYPTION_KEY_SIZE = 256;
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final int DEFAULT_ENCRYPTION_ITERATIONS = 1000;
    public static final IStruct KEY_ALGORITHMS = Struct.of(Key.of("AES"), "AES", Key.of("ARCFOUR"), "ARCFOUR", Key.of("Blowfish"), "Blowfish", Key.of("ChaCha20"), "ChaCha20", Key.of("DES"), "DES", Key.of("DESede"), "DESede", Key.of("HmacMD5"), "HmacMD5", Key.of("HmacSHA1"), "HmacSHA1", Key.of("HmacSHA224"), "HmacSHA224", Key.of("HmacSHA256"), "HmacSHA256", Key.of("HmacSHA384"), "HmacSHA384", Key.of("HmacSHA512"), "HmacSHA512", Key.of("HmacSHA3-224"), "HmacSHA3-224", Key.of("HmacSHA3-256"), "HmacSHA3-256", Key.of("HmacSHA3-384"), "HmacSHA3-384", Key.of("HmacSHA3-512"), "HmacSHA3-512");

    public static String hash(Object object) {
        return EncryptionUtil.hash(object, DEFAULT_HASH_ALGORITHM);
    }

    public static String hash(Object object, String algorithm) {
        if (object instanceof byte[]) {
            return EncryptionUtil.hash((byte[])object, algorithm, 1);
        }
        return EncryptionUtil.hash(object.toString().getBytes(), algorithm, 1);
    }

    public static String hash(byte[] byteArray, String algorithm, int iterations) {
        String result = null;
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm.toUpperCase());
            for (int i = 0; i < iterations; ++i) {
                try {
                    md.reset();
                    MessageDigest mdc = (MessageDigest)md.clone();
                    mdc.update(byteArray);
                    byte[] digest = mdc.digest();
                    byteArray = digest;
                    result = EncryptionUtil.digestToString(digest);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    throw new BoxRuntimeException(String.format("The clone operation is not supported using the algorithm [%s].", algorithm.toUpperCase()));
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new BoxRuntimeException(String.format("The algorithm [%s] provided is not a valid digest algorithm.", algorithm.toUpperCase()));
        }
        return result;
    }

    public static String digestToString(byte[] digest) {
        StringBuilder result = new StringBuilder();
        IntStream.range(0, digest.length).forEach(idx -> result.append(String.format("%02x", digest[idx])));
        return result.toString();
    }

    public static String checksum(Path filePath) {
        return EncryptionUtil.checksum(filePath, DEFAULT_HASH_ALGORITHM);
    }

    public static String checksum(Path filePath, String algorithm) {
        try {
            return EncryptionUtil.hash(Files.readAllBytes(filePath));
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static String hmac(byte[] encryptItem, String key, String algorithm, String encoding) {
        Charset charset = Charset.forName(encoding);
        algorithm = (String)KEY_ALGORITHMS.getOrDefault(Key.of(algorithm), (Object)algorithm);
        try {
            Mac mac = Mac.getInstance(algorithm);
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(charset), algorithm);
            mac.init(secretKey);
            mac.reset();
            return EncryptionUtil.digestToString(mac.doFinal(encryptItem));
        }
        catch (NoSuchAlgorithmException e) {
            throw new BoxRuntimeException(String.format("The algorithm [%s] provided is not a valid digest algorithm.", algorithm), e);
        }
        catch (InvalidKeyException e) {
            throw new BoxRuntimeException(String.format("The the key provided, [%s], is not a valid encryption key.", key), e);
        }
        catch (IllegalStateException e) {
            throw new BoxRuntimeException("An illegal state exception occurred", e);
        }
    }

    public static String hmac(Object input, String key, String algorithm, String encoding) {
        Charset charset = Charset.forName(encoding);
        byte[] encryptItem = null;
        encryptItem = input instanceof String ? StringCaster.cast(input).getBytes(charset) : input.toString().getBytes(charset);
        return EncryptionUtil.hmac(encryptItem, key, algorithm, encoding);
    }

    public static String base64Encode(Object item, Charset charset) {
        byte[] encodeItem = null;
        encodeItem = item instanceof byte[] ? (byte[])item : (item instanceof String ? StringCaster.cast(item).getBytes(charset) : item.toString().getBytes(charset));
        return Base64.getEncoder().encodeToString(encodeItem);
    }

    public static String urlEncode(String target) {
        return EncryptionUtil.urlEncode(target, DEFAULT_CHARSET);
    }

    public static String urlEncode(String target, String encoding) {
        try {
            return URLEncoder.encode(target, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRuntimeException(e.getMessage());
        }
    }

    public static String urlDecode(String target) {
        return EncryptionUtil.urlDecode(target, DEFAULT_CHARSET);
    }

    public static String urlDecode(String target, String encoding) {
        try {
            return URLDecoder.decode(target, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRuntimeException(e.getMessage());
        }
    }

    public static SecretKey generateKey(String algorithm, Integer keySize) {
        algorithm = (String)KEY_ALGORITHMS.getOrDefault(Key.of(algorithm), (Object)algorithm);
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            if (keySize != null) {
                keyGenerator.init(keySize);
            }
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BoxRuntimeException(String.format("The algorithm [%s] provided is not a valid key algorithm or it has not been loaded properly.", algorithm), e);
        }
    }

    public static SecretKey generateKey(String algorithm) {
        return EncryptionUtil.generateKey(algorithm, null);
    }

    public static String encodeKey(SecretKey key) {
        return EncryptionUtil.base64Encode(key.getEncoded(), Charset.forName(DEFAULT_CHARSET));
    }

    public static SecretKey decodeKey(String key, String algorithm) {
        return new SecretKeySpec(EncryptionUtil.decodeKeyBytes(key), algorithm);
    }

    public static byte[] decodeKeyBytes(String key) {
        return Base64.getDecoder().decode(key);
    }

    public static String generateKeyAsString(String algorithm, int keySize) {
        return EncryptionUtil.convertSecretKeyToString(EncryptionUtil.generateKey(algorithm, keySize));
    }

    public static SecretKey generateKey() {
        return EncryptionUtil.generateKey(DEFAULT_ENCRYPTION_ALGORITHM, 256);
    }

    public static String generateKeyAsString() {
        return EncryptionUtil.convertSecretKeyToString(EncryptionUtil.generateKey());
    }

    public static String convertSecretKeyToString(SecretKey secretKey) {
        byte[] rawData = secretKey.getEncoded();
        return Base64.getEncoder().encodeToString(rawData);
    }

    public static Object crypt(int cipherMode, Object obj, String algorithm, String key, String encoding, byte[] initVectorOrSalt, Integer iterations) {
        byte[] objectBytes = cipherMode == 1 ? EncryptionUtil.convertToByteArray(obj) : EncryptionUtil.decodeString(StringCaster.cast(obj), encoding);
        int ivsSize = 0;
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            if (initVectorOrSalt == null && (EncryptionUtil.isPBEAlgorithm(algorithm) || EncryptionUtil.isFBMAlgorithm(algorithm))) {
                ivsSize = cipher.getBlockSize();
                initVectorOrSalt = new byte[ivsSize];
                if (cipherMode == 2) {
                    System.arraycopy(objectBytes, 0, initVectorOrSalt, 0, ivsSize);
                } else {
                    secureRandom.nextBytes(initVectorOrSalt);
                }
            }
            String baseAlgorithm = StringUtils.substringBefore(algorithm, "/");
            AlgorithmParameterSpec params = null;
            SecretKey cipherKey = null;
            if (EncryptionUtil.isPBEAlgorithm(algorithm)) {
                params = new PBEParameterSpec(initVectorOrSalt, iterations != null ? iterations : 1000);
                cipherKey = SecretKeyFactory.getInstance(algorithm).generateSecret(new PBEKeySpec(key.toCharArray()));
            } else if (EncryptionUtil.isFBMAlgorithm(algorithm)) {
                params = new IvParameterSpec(initVectorOrSalt);
            }
            if (cipherKey == null) {
                cipherKey = new SecretKeySpec(EncryptionUtil.decodeKeyBytes(key), baseAlgorithm);
            }
            cipher.init(cipherMode, cipherKey, params);
            if (cipherMode == 2) {
                byte[] decryptedBytes = cipher.doFinal(objectBytes, ivsSize, objectBytes.length - ivsSize);
                try {
                    return new String(decryptedBytes, DEFAULT_CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    return SerializationUtils.deserialize(decryptedBytes);
                }
            }
            byte[] result = new byte[ivsSize + cipher.getOutputSize(objectBytes.length)];
            if (ivsSize > 0) {
                System.arraycopy(initVectorOrSalt, 0, result, 0, ivsSize);
            }
            cipher.doFinal(objectBytes, 0, objectBytes.length, result, ivsSize);
            return EncryptionUtil.encodeObject(result, encoding);
        }
        catch (IllegalBlockSizeException e) {
            throw new BoxRuntimeException("An block size exception occurred while attempting to encrypt an object: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            if (EncryptionUtil.isECBMode(algorithm)) {
                throw new BoxRuntimeException("An padding exception occurred while attempting to encrypt an object. ECB modes require padding. The message received was:" + e.getMessage(), e);
            }
            throw new BoxRuntimeException("An padding exception occurred while attempting to encrypt an object: " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException | ShortBufferException e) {
            throw new BoxRuntimeException("An error occurred while attempting to encrypt an object: " + e.getMessage(), e);
        }
    }

    public static String encrypt(Object obj, String algorithm, String key, String encoding, byte[] initVectorOrSalt, Integer iterations) {
        return StringCaster.cast(EncryptionUtil.crypt(1, obj, algorithm, key, encoding, initVectorOrSalt, iterations));
    }

    public static Object decrypt(String encrypted, String algorithm, String key, String encoding, byte[] initVectorOrSalt, Integer iterations) {
        return EncryptionUtil.crypt(2, encrypted, algorithm, key, encoding, initVectorOrSalt, iterations);
    }

    public static String encodeObject(byte[] obj, String encoding) {
        Key encodingKey = Key.of(encoding);
        if (encodingKey.equals(Key.encodingHex)) {
            StringBuilder sb = new StringBuilder(obj.length * 2);
            for (byte b : obj) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        if (encodingKey.equals(Key.encodingUU)) {
            return Base64.getMimeEncoder().encodeToString(obj);
        }
        if (encodingKey.equals(Key.encodingBase64)) {
            return EncryptionUtil.base64Encode(obj, Charset.forName(DEFAULT_CHARSET));
        }
        if (encodingKey.equals(Key.encodingBase64Url)) {
            return Base64.getUrlEncoder().encodeToString(obj);
        }
        throw new BoxRuntimeException(String.format("The encoding argument [%s] is not a valid encoding type", encodingKey.getName()));
    }

    public static byte[] decodeString(String encoded, String encoding) {
        Key encodingKey = Key.of(encoding);
        if (encodingKey.equals(Key.encodingHex)) {
            return HexFormat.of().parseHex(encoded);
        }
        if (encodingKey.equals(Key.encodingUU)) {
            return Base64.getMimeDecoder().decode(encoded);
        }
        if (encodingKey.equals(Key.encodingBase64)) {
            return Base64.getDecoder().decode(encoded);
        }
        if (encodingKey.equals(Key.encodingBase64Url)) {
            return Base64.getUrlDecoder().decode(encoded);
        }
        throw new BoxRuntimeException(String.format("The encoding argument [%s] is not a valid encoding type.", encoding));
    }

    public static byte[] convertToByteArray(Object obj) {
        byte[] byArray;
        if (obj instanceof String) {
            try {
                return StringCaster.cast(obj).getBytes(DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new BoxRuntimeException("Provided object could not be encoded", e);
            }
        }
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(obj);
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Error serializing object: " + e.getMessage(), e);
            }
            byArray = b.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    b.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Error serializing object: " + e.getMessage(), e);
            }
        }
        b.close();
        return byArray;
    }

    private static AlgorithmParameterSpec getAlgorithmParams(String algorithm, byte[] initVectorOrSalt, Integer iterations) {
        if (EncryptionUtil.isPBEAlgorithm(algorithm)) {
            return new PBEParameterSpec(initVectorOrSalt, iterations != null ? iterations : 1000);
        }
        if (EncryptionUtil.isFBMAlgorithm(algorithm) && initVectorOrSalt != null) {
            return new IvParameterSpec(initVectorOrSalt);
        }
        if (EncryptionUtil.isCBCMode(algorithm)) {
            return new IvParameterSpec(new byte[16]);
        }
        return null;
    }

    private static boolean isPBEAlgorithm(String algorithm) {
        return StringUtils.startsWithIgnoreCase(algorithm, "PBE");
    }

    private static boolean isFBMAlgorithm(String algorithm) {
        String[] algorithmParts = StringUtils.split(algorithm, "/");
        return algorithm.indexOf("/") > -1 && !StringUtils.startsWithIgnoreCase(algorithmParts[1], "ECB");
    }

    private static boolean isCBCMode(String algorithm) {
        String[] algorithmParts = StringUtils.split(algorithm, "/");
        return algorithmParts.length > 1 && StringUtils.startsWithIgnoreCase(algorithmParts[1], "CBC");
    }

    private static boolean isECBMode(String algorithm) {
        String[] algorithmParts = StringUtils.split(algorithm, "/");
        return algorithmParts.length > 1 && algorithmParts[1].equals("ECB");
    }
}

