/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FQN {
    static final Set<String> RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));
    protected String[] parts;

    public FQN(Path root, Path filePath) {
        root = root.toAbsolutePath();
        filePath = filePath.toAbsolutePath();
        if (!filePath.startsWith(root)) {
            throw new IllegalArgumentException("File path must be a child of the root path.");
        }
        this.parts = this.parseParts(this.parseFromFile(root.relativize(filePath)));
    }

    protected FQN(String[] parts2) {
        this.parts = parts2;
    }

    public FQN(Path path) {
        this.parts = this.parseParts(this.parseFromFile(path));
    }

    public FQN(String path) {
        this.parts = this.parseParts(path);
    }

    public FQN(String prefix, FQN fqn) {
        this.combineParts(this.parseParts(prefix, true), fqn.parts);
    }

    public FQN(String prefix, String path) {
        this.combineParts(this.parseParts(prefix, true), this.parseParts(path));
    }

    public FQN(String prefix, Path path) {
        this.combineParts(this.parseParts(prefix, true), this.parseParts(this.parseFromFile(path)));
    }

    protected void combineParts(String[] prefixParts, String[] pathParts) {
        this.parts = new String[prefixParts.length + pathParts.length];
        System.arraycopy(prefixParts, 0, this.parts, 0, prefixParts.length);
        System.arraycopy(pathParts, 0, this.parts, prefixParts.length, pathParts.length);
    }

    public String toString() {
        return String.join((CharSequence)".", this.parts);
    }

    public String getPackageString() {
        return this.getPackage().toString();
    }

    public String getClassName() {
        if (this.parts.length == 0) {
            return "";
        }
        return this.parts[this.parts.length - 1];
    }

    public FQN getPackage() {
        if (this.parts.length > 1) {
            return new FQN(Arrays.copyOfRange(this.parts, 0, this.parts.length - 1));
        }
        return new FQN(new String[0]);
    }

    protected String[] parseParts(String fqn) {
        return this.parseParts(fqn, false);
    }

    protected String[] parseParts(String fqn, boolean allPackage) {
        fqn = this.normalizeDots((String)fqn);
        if (((String)(fqn = ((String)fqn).replaceAll("[^a-zA-Z0-9$\\.]", "__"))).isEmpty()) {
            return new String[0];
        }
        if (allPackage) {
            fqn = ((String)fqn).toLowerCase();
        } else {
            int lastPeriodIndex = ((String)fqn).lastIndexOf(46);
            if (lastPeriodIndex != -1) {
                String beforeLastPeriod = ((String)fqn).substring(0, lastPeriodIndex).toLowerCase();
                Object afterLastPeriod = ((String)fqn).substring(lastPeriodIndex + 1).toLowerCase();
                afterLastPeriod = ((String)afterLastPeriod).substring(0, 1).toUpperCase() + ((String)afterLastPeriod).substring(1);
                fqn = beforeLastPeriod + "." + (String)afterLastPeriod;
            } else {
                fqn = ((String)fqn).substring(0, 1).toUpperCase() + ((String)fqn).substring(1).toLowerCase();
            }
        }
        return (String[])Arrays.stream(((String)fqn).split("\\.")).map(s -> s.matches("^\\d.*") ? "_" + s : s).map(s -> {
            if (RESERVED_WORDS.contains(s)) {
                return "_" + s;
            }
            return s;
        }).toArray(String[]::new);
    }

    protected String normalizeDots(String fqn) {
        if ((fqn = fqn.replaceAll("\\.\\.", ".")).endsWith(".")) {
            fqn = fqn.substring(0, fqn.length() - 1);
        }
        if (fqn.startsWith(".")) {
            fqn = fqn.substring(1);
        }
        return fqn;
    }

    protected String parseFromFile(Path file) {
        String fileName = file.getFileName().toString();
        fileName = this.cleanFileName(fileName);
        Path parent = file.getParent();
        String fqn = parent != null ? parent.resolve(fileName).toString() : fileName;
        if (fqn.startsWith("/") || fqn.startsWith("\\")) {
            fqn = fqn.substring(1);
        }
        if (fqn.endsWith("\\") || fqn.endsWith("/")) {
            fqn = fqn.substring(0, fqn.length() - 1);
        }
        fqn = fqn.replaceAll("\\.", "");
        fqn = fqn.replaceAll("/", ".");
        fqn = fqn.replaceAll(":", "_");
        fqn = fqn.replaceAll("\\\\", ".");
        return fqn;
    }

    protected String cleanFileName(String fileName) {
        return fileName.replace(".", "$");
    }

    public static FQN of(String prefix, String path) {
        return new FQN(prefix, path);
    }

    public static FQN of(String prefix, Path path) {
        return new FQN(prefix, path);
    }

    public static FQN of(String path) {
        return new FQN(path);
    }

    public static FQN of(Path path) {
        return new FQN(path);
    }

    public FQN appendPrefix(String prefix) {
        return new FQN(prefix, this);
    }
}

