/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.interop.DynamicObject;

public class FRTransService {
    private static FRTransService instance = null;
    private boolean FREnabled = false;
    private DynamicObject FRAPI;

    private FRTransService(Boolean enabled) {
        if (!enabled.booleanValue()) {
            this.FREnabled = false;
            return;
        }
        try {
            DynamicObject frapiClass = DynamicObject.of(Class.forName("com.intergral.fusionreactor.api.FRAPI"));
            Object FRAPIObject = frapiClass.invokeStatic(BoxRuntime.getInstance().getRuntimeContext(), "getInstance", new Object[0]);
            while (FRAPIObject == null || !((Boolean)DynamicObject.of(FRAPIObject).invoke(BoxRuntime.getInstance().getRuntimeContext(), "isInitialized", new Object[0])).booleanValue()) {
                Thread.sleep(200L);
                if (FRAPIObject != null) continue;
                FRAPIObject = frapiClass.invokeStatic(BoxRuntime.getInstance().getRuntimeContext(), "getInstance", new Object[0]);
            }
            this.FRAPI = DynamicObject.of(FRAPIObject);
            this.FREnabled = true;
        }
        catch (Throwable e) {
            this.FREnabled = false;
        }
    }

    public static synchronized FRTransService getInstance(Boolean enabled) {
        if (instance == null) {
            instance = new FRTransService(enabled);
        }
        return instance;
    }

    public boolean isEnabled() {
        return this.FREnabled;
    }

    public DynamicObject startTransaction(String name, String description) {
        if (!this.FREnabled) {
            return null;
        }
        DynamicObject FRTransaction = DynamicObject.of(this.FRAPI.invoke(BoxRuntime.getInstance().getRuntimeContext(), "createTrackedTransaction", name));
        this.FRAPI.invoke(BoxRuntime.getInstance().getRuntimeContext(), "setTransactionApplicationName", "BL");
        FRTransaction.invoke(BoxRuntime.getInstance().getRuntimeContext(), "setDescription", description);
        return FRTransaction;
    }

    public void endTransaction(DynamicObject FRTransaction) {
        if (!this.FREnabled) {
            return;
        }
        FRTransaction.invoke(BoxRuntime.getInstance().getRuntimeContext(), "close", new Object[0]);
    }

    public void errorTransaction(DynamicObject FRTransaction, Exception javaException) {
        if (!this.FREnabled) {
            return;
        }
        FRTransaction.invoke(BoxRuntime.getInstance().getRuntimeContext(), "setTrappedThrowable", javaException);
    }

    public void setCurrentTransactionName(String name) {
        if (!this.FREnabled) {
            return;
        }
        this.FRAPI.invoke(BoxRuntime.getInstance().getRuntimeContext(), "setTransactionName", name);
    }

    public void setCurrentTransactionApplicationName(String name) {
        if (!this.FREnabled) {
            return;
        }
        this.FRAPI.invoke(BoxRuntime.getInstance().getRuntimeContext(), "setTransactionApplicationName", name);
    }
}

