/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.ListUtil;
import ortus.boxlang.runtime.util.EncryptionUtil;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public final class FileSystemUtil {
    private static boolean isCaseSensitiveFS = FileSystemUtil.caseSensitivityCheck();
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final Array TEXT_MIME_SUFFIXES = new Array(new Object[]{"json", "xml", "javascript", "plain"});
    public static final Array TEXT_MIME_PREFIXES = new Array(new Object[]{"text"});
    private static final int OWNER_READ_FILEMODE = 256;
    private static final int OWNER_WRITE_FILEMODE = 128;
    private static final int OWNER_EXEC_FILEMODE = 64;
    private static final int GROUP_READ_FILEMODE = 32;
    private static final int GROUP_WRITE_FILEMODE = 16;
    private static final int GROUP_EXEC_FILEMODE = 8;
    private static final int OTHERS_READ_FILEMODE = 4;
    private static final int OTHERS_WRITE_FILEMODE = 2;
    private static final int OTHERS_EXEC_FILEMODE = 1;
    public static final boolean IS_WINDOWS = SystemUtils.IS_OS_WINDOWS;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String SLASH_PREFIX = "/";
    private static InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object read(String filePath, String charset, Integer bufferSize) {
        Path path = null;
        Boolean isURL = false;
        if (filePath.substring(0, 4).equalsIgnoreCase("http")) {
            isURL = true;
        } else {
            path = Path.of(filePath, new String[0]);
        }
        Charset cs = StandardCharsets.UTF_8;
        if (charset != null) {
            cs = Charset.forName(charset);
        }
        try {
            if (isURL.booleanValue()) {
                try {
                    URL fileURL = URI.create(filePath).toURL();
                    if (FileSystemUtil.isBinaryFile(filePath).booleanValue()) {
                        return IOUtils.toByteArray(fileURL.openStream());
                    }
                    InputStreamReader inputReader = new InputStreamReader(fileURL.openStream());
                    try (BufferedReader reader = new BufferedReader(inputReader);){
                        String string = ((Stream)reader.lines().parallel()).collect(Collectors.joining(LINE_SEPARATOR));
                        return string;
                    }
                }
                catch (MalformedURLException e) {
                    throw new BoxRuntimeException("The url [" + filePath + "] could not be parsed.  The reason was:" + e.getMessage() + "(" + String.valueOf(e.getCause()) + ")");
                }
            }
            if (FileSystemUtil.isBinaryFile(filePath).booleanValue()) {
                return Files.readAllBytes(path);
            }
            if (bufferSize == null) {
                return Files.readString(path, cs);
            }
            try (BufferedReader reader = new BufferedReader(Files.newBufferedReader(path, cs), bufferSize);){
                String string = ((Stream)reader.lines().parallel()).collect(Collectors.joining(LINE_SEPARATOR));
                return string;
            }
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static Object read(String filePath) {
        return FileSystemUtil.read(filePath, null, null);
    }

    public static void createDirectory(String directoryPath) {
        FileSystemUtil.createDirectory(directoryPath, true, null);
    }

    public static void createDirectory(String directoryPath, Boolean createPath, String mode) {
        try {
            if (createPath.booleanValue()) {
                Files.createDirectories(Path.of(directoryPath, new String[0]), new FileAttribute[0]);
            } else {
                Files.createDirectory(Path.of(directoryPath, new String[0]), new FileAttribute[0]);
            }
            if (mode != null) {
                FileSystemUtil.setPosixPermissions(directoryPath, mode);
            }
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static void deleteDirectory(String directoryPath, Boolean recursive) {
        Path targetDirectory = Path.of(directoryPath, new String[0]);
        if (recursive.booleanValue()) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(targetDirectory);){
                for (Path entry : stream) {
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        FileSystemUtil.deleteDirectory(entry.toString(), true);
                        continue;
                    }
                    Files.delete(entry);
                }
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
        try {
            Files.delete(targetDirectory);
        }
        catch (DirectoryNotEmptyException e) {
            throw new BoxRuntimeException("The directory " + directoryPath + " is not empty and may not be deleted without the recursive option.");
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static Stream<Path> listDirectory(String path, Boolean recurse, Object filter, String sort, String type) {
        String castedFilter;
        Path targetPath = Path.of(path, new String[0]);
        if (!Files.exists(targetPath, new LinkOption[0])) {
            return Stream.empty();
        }
        String theType = type.toLowerCase();
        String[] sortElements = sort.split("\\s+");
        String sortField = sortElements[0];
        String sortDirection = sortElements.length > 1 ? sortElements[1].toLowerCase() : "asc";
        Comparator pathSort = null;
        Stream<Path> directoryStream = null;
        switch (sortField) {
            case "size": {
                pathSort = (a, b) -> {
                    try {
                        return sortDirection.equals("desc") ? Long.compareUnsigned(Files.size(b), Files.size(a)) : Long.compareUnsigned(Files.size(a), Files.size(b));
                    }
                    catch (IOException e) {
                        return Long.compareUnsigned(0L, 0L);
                    }
                };
                break;
            }
            case "directory": {
                pathSort = (a, b) -> sortDirection.equals("desc") ? b.getParent().toString().compareTo(a.getParent().toString()) : a.getParent().toString().compareTo(b.getParent().toString());
                break;
            }
            case "namenocase": {
                pathSort = (a, b) -> sortDirection.equals("desc") ? b.toString().toLowerCase().compareTo(a.toString().toLowerCase()) : a.toString().toLowerCase().compareTo(b.toString().toLowerCase());
                break;
            }
            default: {
                pathSort = (a, b) -> sortDirection.equals("desc") ? b.toString().compareTo(a.toString()) : a.toString().compareTo(b.toString());
            }
        }
        try {
            directoryStream = recurse.booleanValue() ? ((Stream)Files.walk(targetPath, new FileVisitOption[0]).parallel()).filter(filterPath -> !filterPath.equals(targetPath)) : ((Stream)Files.walk(targetPath, 1, new FileVisitOption[0]).parallel()).filter(filterPath -> !filterPath.equals(targetPath));
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        directoryStream = directoryStream.filter(item -> FileSystemUtil.matchesType(item, theType));
        if (filter instanceof String && (castedFilter = (String)filter).length() > 1) {
            ArrayList pathMatchers = ListUtil.asList(castedFilter, "|").stream().map(filterString -> FileSystems.getDefault().getPathMatcher("glob:" + String.valueOf(filterString))).collect(Collectors.toCollection(ArrayList::new));
            directoryStream = directoryStream.filter(item -> pathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(item.getFileName())));
        } else if (filter instanceof Predicate) {
            directoryStream = directoryStream.filter((Predicate)filter);
        }
        return directoryStream.sorted(pathSort);
    }

    private static Boolean matchesType(Path item, String type) {
        switch (type) {
            case "directory": 
            case "dir": {
                return Files.isDirectory(item, new LinkOption[0]);
            }
            case "file": {
                return Files.isRegularFile(item, new LinkOption[0]);
            }
        }
        return true;
    }

    public static void deleteFile(String filePath) {
        try {
            Files.delete(Path.of(filePath, new String[0]));
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static void write(String filePath, String contents) {
        FileSystemUtil.write(filePath, contents.getBytes(DEFAULT_CHARSET), false);
    }

    public static void write(String filePath, String contents, String charset) {
        FileSystemUtil.write(filePath, contents.getBytes(Charset.forName(charset)), false);
    }

    public static void write(String filePath, String contents, String charset, Boolean ensureDirectory) {
        FileSystemUtil.write(filePath, contents.getBytes(Charset.forName(charset)), ensureDirectory);
    }

    public static void write(String filePath, byte[] contents, Boolean ensureDirectory) {
        Path fileTarget = Path.of(filePath, new String[0]);
        try {
            if (ensureDirectory.booleanValue() && !Files.exists(fileTarget.getParent(), new LinkOption[0])) {
                Files.createDirectories(fileTarget.getParent(), new FileAttribute[0]);
            }
            Files.write(fileTarget, contents, StandardOpenOption.CREATE);
        }
        catch (NoSuchFileException e) {
            throw new BoxRuntimeException("The file [" + filePath + "] could not be writtent. The directory [" + Path.of(filePath, new String[0]).getParent().toString() + "] does not exist.");
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static void move(String source, String destination) {
        FileSystemUtil.move(source, destination, true);
    }

    public static void move(String source, String destination, boolean createPath) {
        Path start = Path.of(source, new String[0]);
        Path end = Path.of(destination, new String[0]);
        if (!createPath && !Files.exists(end.getParent(), new LinkOption[0])) {
            throw new BoxRuntimeException("The directory [" + end.toAbsolutePath().toString() + "] cannot be created because the parent directory [" + end.getParent().toAbsolutePath().toString() + "] does not exist.  To prevent this error set the createPath argument to true.");
        }
        if (Files.exists(end, new LinkOption[0])) {
            throw new BoxRuntimeException("The target directory [" + end.toAbsolutePath().toString() + "] already exists");
        }
        try {
            if (createPath) {
                Files.createDirectories(end.getParent(), new FileAttribute[0]);
            }
            Files.move(start, end, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static void copyDirectory(String source, String destination, Boolean recurse, String filter, Boolean createPaths) {
        Path start = Path.of(source, new String[0]);
        Path end = Path.of(destination, new String[0]);
        if (createPaths.booleanValue() && !Files.exists(end, new LinkOption[0])) {
            try {
                Files.createDirectories(end, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
        if (Files.isDirectory(start, new LinkOption[0])) {
            FileSystemUtil.listDirectory(source, recurse, filter, "name", recurse != false ? "all" : "file").forEachOrdered(path -> {
                Path targetPath = Path.of(path.toString().replace(source, destination), new String[0]);
                Path targetParent = targetPath.getParent();
                if (recurse.booleanValue() && !Files.exists(targetParent, new LinkOption[0])) {
                    try {
                        Files.createDirectories(targetParent, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new BoxIOException(e);
                    }
                }
                try {
                    if (!Files.isDirectory(targetPath, new LinkOption[0]) || Files.isDirectory(targetPath, new LinkOption[0]) && !Files.exists(targetPath, new LinkOption[0])) {
                        Files.copy(path, targetPath, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new BoxIOException(e);
                }
            });
        } else {
            try {
                Files.copy(start, end, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
    }

    public static Boolean isValidFilePath(Path filePath) {
        return Files.exists(filePath, new LinkOption[0]);
    }

    public static Boolean isValidFilePath(String filePath) {
        try {
            return FileSystemUtil.isValidFilePath(Path.of(filePath, new String[0]));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static Boolean isBinaryFile(String filePath) {
        String mimeType = FileSystemUtil.getMimeType(filePath);
        if (mimeType == null) {
            return false;
        }
        String[] mimeParts = mimeType.split(SLASH_PREFIX);
        return !TEXT_MIME_PREFIXES.contains(mimeParts[0]) && !TEXT_MIME_PREFIXES.contains(mimeParts[mimeParts.length - 1]);
    }

    public static String getMimeType(String filePath) {
        try {
            if (filePath.substring(0, 4).equalsIgnoreCase("http")) {
                return Files.probeContentType(Paths.get(new URI(filePath).toURL().getFile(), new String[0]).getFileName());
            }
            return Files.probeContentType(Paths.get(filePath, new String[0]).getFileName());
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        catch (URISyntaxException e) {
            throw new BoxRuntimeException("The provided URL [" + filePath + "] is not a valid. " + e.getMessage());
        }
    }

    public static Set<PosixFilePermission> getPosixPermissions(String filePath) {
        Path path = Path.of(filePath, new String[0]);
        if (!FileSystemUtil.isPosixCompliant(path).booleanValue()) {
            throw new BoxRuntimeException("The underlying file system for path  [" + filePath + "] is not posix compliant.");
        }
        try {
            return Files.getPosixFilePermissions(Path.of(filePath, new String[0]), new LinkOption[0]);
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static Boolean isPosixCompliant(Object filePath) {
        Path path = null;
        path = filePath instanceof String ? Path.of((String)filePath, new String[0]) : (Path)filePath;
        return path.getFileSystem().supportedFileAttributeViews().contains("posix");
    }

    public static void setPosixPermissions(Object filePath, String mode) {
        Path path = null;
        path = filePath instanceof String ? Path.of((String)filePath, new String[0]) : (Path)filePath;
        if (!FileSystemUtil.isPosixCompliant(path).booleanValue()) {
            throw new BoxRuntimeException("The underlying file system for path  [" + String.valueOf(filePath) + "] is not posix compliant.");
        }
        if (mode.length() != 3) {
            throw new BoxRuntimeException("The file or directory mode [" + mode + "] is not a valid permission set.");
        }
        try {
            try {
                IntegerCaster.cast(mode);
            }
            catch (Exception e) {
                throw new BoxRuntimeException("The file or directory mode [" + mode + "] is not a valid permission set.");
            }
            Files.setPosixFilePermissions(path, FileSystemUtil.octalToPosixPermissions(mode));
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    private static Set<PosixFilePermission> octalToPosixPermissions(String mode) {
        char[] directiveSet = mode.toCharArray();
        char[] attributeSet = new char[]{'-', '-', '-', '-', '-', '-', '-', '-', '-'};
        for (int i = directiveSet.length - 1; i >= 0; --i) {
            int n = directiveSet[i] - 48;
            if (i == directiveSet.length - 1) {
                if ((n & 1) != 0) {
                    attributeSet[8] = 120;
                }
                if ((n & 2) != 0) {
                    attributeSet[7] = 119;
                }
                if ((n & 4) == 0) continue;
                attributeSet[6] = 114;
                continue;
            }
            if (i == directiveSet.length - 2) {
                if ((n & 1) != 0) {
                    attributeSet[5] = 120;
                }
                if ((n & 2) != 0) {
                    attributeSet[4] = 119;
                }
                if ((n & 4) == 0) continue;
                attributeSet[3] = 114;
                continue;
            }
            if (i != directiveSet.length - 3) continue;
            if ((n & 1) != 0) {
                attributeSet[2] = 120;
            }
            if ((n & 2) != 0) {
                attributeSet[1] = 119;
            }
            if ((n & 4) == 0) continue;
            attributeSet[0] = 114;
        }
        String attributes = new String(attributeSet);
        return PosixFilePermissions.fromString(attributes);
    }

    public static int posixSetToOctal(Set<PosixFilePermission> permissions) {
        int octal = 0;
        for (PosixFilePermission permissionBit : permissions) {
            switch (permissionBit) {
                case OWNER_READ: {
                    octal |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    octal |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    octal |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    octal |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    octal |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    octal |= 8;
                    break;
                }
                case OTHERS_READ: {
                    octal |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    octal |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    octal |= 1;
                }
            }
        }
        return octal;
    }

    public static Boolean exists(String path) {
        try {
            return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static IStruct info(Object filePath, Boolean verbose) {
        Path path = null;
        path = filePath instanceof String ? Path.of((String)filePath, new String[0]) : (Path)filePath;
        Struct infoStruct = new Struct();
        try {
            infoStruct.put("name", (Object)path.getFileName().toString());
            infoStruct.put("path", (Object)path.toAbsolutePath().toString());
            infoStruct.put("size", (Object)(Files.isDirectory(path, new LinkOption[0]) ? 0L : Files.size(path)));
            infoStruct.put("type", (Object)(Files.isDirectory(path, new LinkOption[0]) ? "dir" : "file"));
            infoStruct.put("lastModified", (Object)new DateTime(Files.getLastModifiedTime(path, new LinkOption[0]).toInstant()).setFormat("MMMM, d, yyyy HH:mm:ss Z"));
            if (verbose == null || !verbose.booleanValue()) {
                infoStruct.put("attributes", (Object)"");
                infoStruct.put("mode", (Object)(FileSystemUtil.isPosixCompliant(path) != false ? StringCaster.cast(FileSystemUtil.posixSetToOctal(Files.getPosixFilePermissions(path, new LinkOption[0]))) : ""));
                infoStruct.put("read", (Object)Files.isReadable(path));
                infoStruct.put("write", (Object)Files.isWritable(path));
                infoStruct.put("execute", (Object)Files.isExecutable(path));
                infoStruct.put("checksum", (Object)(!Files.isDirectory(path, new LinkOption[0]) ? EncryptionUtil.checksum(path, "md5") : ""));
            } else {
                infoStruct.put("parent", (Object)path.getParent().toAbsolutePath().toString());
                infoStruct.put("isHidden", (Object)Files.isHidden(path));
                infoStruct.put("canRead", (Object)Files.isReadable(path));
                infoStruct.put("canWrite", (Object)Files.isWritable(path));
                infoStruct.put("canExecute", (Object)Files.isExecutable(path));
                infoStruct.put("isArchive", IS_WINDOWS ? Files.getAttribute(path, "dos:archive", new LinkOption[0]) : Boolean.valueOf(false));
                infoStruct.put("isSystem", IS_WINDOWS ? Files.getAttribute(path, "dos:system", new LinkOption[0]) : Boolean.valueOf(false));
                infoStruct.put("isAttributesSupported", (Object)IS_WINDOWS);
                infoStruct.put("isModeSupported", (Object)FileSystemUtil.isPosixCompliant(path));
                infoStruct.put("isCaseSensitive", (Object)(!Files.exists(Path.of(path.toAbsolutePath().toString().toUpperCase(), new String[0]), new LinkOption[0]) ? 1 : 0));
            }
            return infoStruct;
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String convertInputStreamToString(InputStream inputStream) {
        return new String(FileSystemUtil.convertInputStreamToByteArray(inputStream), DEFAULT_CHARSET);
    }

    public static ResolvedFilePath expandPath(IBoxContext context, String path) {
        ResolvedFilePath resolvedFilePath = context.findClosestTemplate();
        return FileSystemUtil.expandPath(context, path, resolvedFilePath);
    }

    public static ResolvedFilePath expandPath(IBoxContext context, String path, ResolvedFilePath basePath) {
        if (((String)path).startsWith("//")) {
            path = ((String)path).substring(1);
        }
        path = ((String)path).replace("\\", SLASH_PREFIX);
        String originalPath = path;
        Path originalPathPath = null;
        originalPathPath = Path.of(originalPath, new String[0]);
        boolean isAbsolute = originalPathPath.isAbsolute();
        if (!isAbsolute && !((String)path).startsWith(SLASH_PREFIX)) {
            Path template;
            if (basePath != null && (template = basePath.absolutePath()) != null) {
                return basePath.newFromRelative((String)path);
            }
            path = SLASH_PREFIX + (String)path;
        }
        String finalPath = path;
        Map.Entry matchingMappingEntry = context.getConfig().getAsStruct(Key.mappings).entrySet().stream().filter(entry -> !((Key)entry.getKey()).getName().equals(SLASH_PREFIX) && StringUtils.startsWithIgnoreCase(finalPath, ((Key)entry.getKey()).getName())).findFirst().orElse(null);
        if (matchingMappingEntry != null) {
            path = ((String)path).substring(((Key)matchingMappingEntry.getKey()).getName().length());
            String matchingMapping = matchingMappingEntry.getValue().toString();
            Path result = Path.of(matchingMapping, new String[]{path}).toAbsolutePath();
            return ResolvedFilePath.of(((Key)matchingMappingEntry.getKey()).getName(), matchingMapping, Path.of(finalPath, new String[0]).normalize().toString(), result.normalize());
        }
        if (isAbsolute && !originalPath.equals(SLASH_PREFIX)) {
            if (File.separator.equals(SLASH_PREFIX)) {
                String[] pathParts;
                boolean tldExists;
                if (originalPath.startsWith(SLASH_PREFIX) && !originalPathPath.getParent().toString().equals(SLASH_PREFIX) && (tldExists = IntStream.range(0, (pathParts = originalPath.substring(1, originalPath.length() - 1).split(SLASH_PREFIX)).length).filter(idx -> pathParts[idx].length() > 0).mapToObj(idx -> {
                    Object tld = "";
                    for (int i = 0; i <= idx; ++i) {
                        tld = (String)tld + SLASH_PREFIX + pathParts[i];
                    }
                    return tld;
                }).anyMatch(tld -> Files.exists(Path.of(tld, new String[0]), new LinkOption[0])))) {
                    return ResolvedFilePath.of(originalPathPath);
                }
            } else {
                return ResolvedFilePath.of(originalPathPath);
            }
        }
        IStruct interceptData = Struct.of(new Object[]{Key.path, path, Key.resolvedFilePath, null});
        interceptorService.announce(BoxEvent.ON_MISSING_MAPPING, interceptData);
        if (interceptData.get(Key.resolvedFilePath) != null) {
            return (ResolvedFilePath)interceptData.get(Key.resolvedFilePath);
        }
        String rootMapping = context.getConfig().getAsStruct(Key.mappings).getAsString(Key.of(SLASH_PREFIX));
        Path result = Path.of(rootMapping, new String[]{path}).toAbsolutePath();
        return ResolvedFilePath.of(SLASH_PREFIX, rootMapping, Path.of(finalPath, new String[0]).normalize().toString(), result.normalize());
    }

    public static ResolvedFilePath contractPath(IBoxContext context, String path) {
        String finalPath = Path.of(path, new String[0]).normalize().toString().replace("\\", SLASH_PREFIX);
        Map.Entry matchingMappingEntry = context.getConfig().getAsStruct(Key.mappings).entrySet().stream().sorted(Comparator.comparingInt(entry -> ((Key)entry.getKey()).getName().length())).map(entry -> new AbstractMap.SimpleEntry<Key, String>((Key)entry.getKey(), Path.of(entry.getValue().toString(), new String[0]).normalize().toString().replace("\\", SLASH_PREFIX))).filter(entry -> File.separator.equals(SLASH_PREFIX) ? finalPath.startsWith((String)entry.getValue()) : StringUtils.startsWithIgnoreCase(finalPath, (CharSequence)entry.getValue())).findFirst().orElse(null);
        if (matchingMappingEntry != null) {
            Object contractedPath = finalPath.replace((CharSequence)matchingMappingEntry.getValue(), "");
            if (!((String)contractedPath).startsWith(SLASH_PREFIX)) {
                contractedPath = SLASH_PREFIX + (String)contractedPath;
            }
            return ResolvedFilePath.of(((Key)matchingMappingEntry.getKey()).getName(), (String)matchingMappingEntry.getValue(), (String)contractedPath, Path.of(finalPath, new String[0]));
        }
        return ResolvedFilePath.of(null, null, finalPath, Path.of(finalPath, new String[0]));
    }

    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void serializeToFile(Object target, Path filePath) {
        try (OutputStream fileStream = Files.newOutputStream(filePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            try (ObjectOutputStream objStream = new ObjectOutputStream(fileStream);){
                objStream.writeObject(target);
            }
            catch (IOException e) {
                throw new BoxIOException(String.format("The target entry [%s] could not be written to the file path [%s]. The message received was: %s", target.getClass().getName(), filePath.toString(), e.getMessage()), e);
            }
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object deserializeFromFile(Path filePath) {
        try (InputStream fileStream = Files.newInputStream(filePath, new OpenOption[0]);){
            Object object;
            ObjectInputStream objStream = new ObjectInputStream(fileStream);
            try {
                object = objStream.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        objStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    throw new BoxRuntimeException("Cannot cast the deserialized object to a known class.", e);
                }
                catch (IOException e) {
                    throw new BoxIOException(String.format("The file path [%s] could not be read. The message received was: %s", filePath.toString(), e.getMessage()), e);
                }
            }
            objStream.close();
            return object;
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
    }

    public static Path pathExistsCaseInsensitive(Path path) {
        Boolean defaultCheck = Files.exists(path, new LinkOption[0]);
        if (defaultCheck.booleanValue()) {
            try {
                return path.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                return null;
            }
        }
        if (isCaseSensitiveFS) {
            Object realPath = "";
            String[] pathSegments = path.toString().replace('\\', '/').split(SLASH_PREFIX);
            if (pathSegments.length > 0 && pathSegments[0].contains(":")) {
                realPath = pathSegments[0];
            }
            Boolean first = true;
            for (String thisSegment : pathSegments) {
                if (realPath == pathSegments[0] && pathSegments[0].contains(":") && first.booleanValue()) {
                    first = false;
                    continue;
                }
                if (thisSegment.length() == 0) continue;
                Boolean found = false;
                String[] children = new File((String)realPath + SLASH_PREFIX).list();
                if (children == null) {
                    return null;
                }
                for (String thisChild : children) {
                    if (!thisSegment.equalsIgnoreCase(thisChild)) continue;
                    realPath = (String)realPath + SLASH_PREFIX + thisChild;
                    found = true;
                    break;
                }
                if (found.booleanValue()) continue;
                return null;
            }
            Path realPathFinal = Paths.get((String)realPath, new String[0]);
            return realPathFinal;
        }
        return null;
    }

    private static boolean caseSensitivityCheck() {
        try {
            File currentWorkingDir = new File(System.getProperty("user.home"));
            File case1 = new File(currentWorkingDir, "case1");
            File case2 = new File(currentWorkingDir, "Case1");
            case1.createNewFile();
            if (case2.createNewFile()) {
                case1.delete();
                case2.delete();
                return true;
            }
            case1.delete();
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
    }
}

