/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public final class LocalizationUtil {
    private static Logger logger = LoggerFactory.getLogger(LocalizationUtil.class);
    public static final LinkedHashMap<Key, Locale> COMMON_LOCALES = new LinkedHashMap();
    public static final Array ISO_COUNTRIES;
    public static final Array ISO_LANGUAGES;
    public static final HashMap<Key, Locale> LOCALE_ALIASES;
    public static final Struct COMMON_NUMBER_FORMATTERS;
    public static final Key DEFAULT_NUMBER_FORMAT_KEY;
    public static final HashMap<Key, String> NUMBER_FORMAT_PATTERNS;
    public static final String CURRENCY_TYPE_LOCAL = "local";
    public static final String CURRENCY_TYPE_INTERNATIONAL = "international";
    public static final String CURRENCY_TYPE_NONE = "none";
    public static final HashMap<Key, String> ZONE_ALIASES;

    public static Locale parseLocale(String requestedLocale) {
        Locale oLocale = null;
        if (requestedLocale == null || requestedLocale.isEmpty()) {
            return null;
        }
        oLocale = COMMON_LOCALES.get(Key.of(requestedLocale));
        if (oLocale != null) {
            return oLocale;
        }
        oLocale = LOCALE_ALIASES.get(Key.of(requestedLocale));
        if (oLocale != null) {
            return oLocale;
        }
        try {
            oLocale = LocaleUtils.toLocale(requestedLocale);
            return LocaleUtils.isAvailableLocale(oLocale) ? oLocale : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LocaleUtils.isAvailableLocale(locale);
    }

    public static String getLocaleDisplayName(Locale locale) {
        return String.format("%s (%s)", locale.getDisplayLanguage(COMMON_LOCALES.get(Key.of("US"))), BooleanCaster.cast(locale.getVariant().length()) != false ? locale.getVariant() : locale.getDisplayCountry(COMMON_LOCALES.get(Key.of("US"))));
    }

    public static Locale parseLocaleOrDefault(String requestedLocale, Locale defaultLocale) {
        Locale locale = LocalizationUtil.parseLocale(requestedLocale);
        return locale != null ? locale : defaultLocale;
    }

    public static Locale parseLocaleFromContext(IBoxContext context, ArgumentsScope arguments) {
        RequestBoxContext requestContext = context.getParentOfType(RequestBoxContext.class);
        return LocalizationUtil.parseLocaleOrDefault(arguments.getAsString(Key.locale), requestContext.getLocale() != null ? requestContext.getLocale() : (Locale)context.getConfig().get(Key.locale));
    }

    public static Locale getParsedLocale(String locale) {
        Locale localeObj = null;
        if (locale != null) {
            String[] localeParts = locale.split("[-_ ]");
            String ISOLang = localeParts[0];
            String ISOCountry = null;
            if (localeParts.length > 1) {
                ISOCountry = localeParts[1];
            }
            localeObj = ISOCountry == null ? LocalizationUtil.buildLocale(ISOLang) : LocalizationUtil.buildLocale(ISOLang, ISOCountry);
        } else {
            localeObj = Locale.getDefault();
        }
        return localeObj;
    }

    public static ZoneId parseZoneId(String timezone, IBoxContext context) {
        if (timezone != null) {
            Key zoneKey = Key.of(timezone);
            if (ZONE_ALIASES.containsKey(zoneKey)) {
                return ZoneId.of(ZONE_ALIASES.get(zoneKey));
            }
            ZoneId parsed = LocalizationUtil.parseZoneId(timezone);
            return parsed != null ? parsed : (ZoneId)context.getConfig().get(Key.timezone);
        }
        RequestBoxContext requestContext = context.getParentOfType(RequestBoxContext.class);
        if (requestContext != null && requestContext.getTimezone() != null) {
            return requestContext.getTimezone();
        }
        return (ZoneId)context.getConfig().get(Key.timezone);
    }

    public static ZoneId parseZoneId(String timezone) {
        try {
            Key zoneKey = Key.of(timezone);
            if (ZONE_ALIASES.containsKey(zoneKey)) {
                return ZoneId.of(ZONE_ALIASES.get(zoneKey));
            }
            return ZoneId.of(timezone);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Double parseLocalizedCurrency(Object value, Locale locale) {
        String currencyCode;
        DecimalFormat parser = (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
        String stringValue = StringCaster.cast(value);
        if (stringValue.substring(0, (currencyCode = parser.getCurrency().getCurrencyCode()).length()).equals(currencyCode)) {
            stringValue = stringValue.replace(currencyCode, parser.getCurrency().getSymbol()).replace(parser.getCurrency().getSymbol() + " ", parser.getCurrency().getSymbol());
        }
        Number parsed = null;
        try {
            parsed = parser.parse(stringValue);
        }
        catch (ParseException e) {
            logger.debug("Error parsing currency value: " + stringValue + ". The message received was: " + e.getMessage());
        }
        return parsed == null ? null : Double.valueOf(parsed.doubleValue());
    }

    public static Number parseLocalizedNumber(Object value, Locale locale) {
        DecimalFormat parser = (DecimalFormat)DecimalFormat.getInstance(locale);
        String parseable = StringCaster.cast(value);
        ParsePosition parsePosition = new ParsePosition(0);
        if (parseable.length() >= 20 || parseable.contains("E") || parseable.contains("e") || parseable.contains(".")) {
            parser.setParseBigDecimal(true);
        }
        parser.setParseBigDecimal(true);
        Number parseResult = parser.parse(StringCaster.cast(value), parsePosition);
        return parsePosition.getIndex() == parseable.length() && parseResult != null ? (Number)parseResult : (Number)null;
    }

    public static DateTimeFormatter localizedDateFormatter(Locale locale, FormatStyle style) {
        return DateTimeFormatter.ofLocalizedDate(style).withLocale(locale);
    }

    public static NumberFormat localizedCurrencyFormatter(Locale locale) {
        return NumberFormat.getCurrencyInstance(locale);
    }

    public static NumberFormat localizedCurrencyFormatter(Locale locale, String type) {
        DecimalFormat formatter = (DecimalFormat)LocalizationUtil.localizedCurrencyFormatter(locale);
        DecimalFormatSymbols symbols = LocalizationUtil.localizedDecimalSymbols(locale);
        switch (type.toLowerCase()) {
            case "international": {
                symbols.setCurrencySymbol(symbols.getInternationalCurrencySymbol() + " ");
                break;
            }
            case "none": {
                symbols.setCurrencySymbol("");
                break;
            }
            case "local": {
                break;
            }
            default: {
                throw new BoxRuntimeException(String.format("The argument [type] [%s] is not recognized as a valid currency format type.", type));
            }
        }
        formatter.setDecimalFormatSymbols(symbols);
        return formatter;
    }

    public static DecimalFormat localizedDecimalFormatter(Locale locale) {
        DecimalFormat formatter = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
        formatter.setDecimalFormatSymbols(LocalizationUtil.localizedDecimalSymbols(locale));
        return formatter;
    }

    public static DecimalFormat localizedDecimalFormatter(Locale locale, String format) {
        Key formatKey = Key.of(format);
        if (NUMBER_FORMAT_PATTERNS.containsKey(formatKey)) {
            format = NUMBER_FORMAT_PATTERNS.get(formatKey);
        }
        return new DecimalFormat(format, LocalizationUtil.localizedDecimalSymbols(locale));
    }

    public static DecimalFormatSymbols localizedDecimalSymbols(Locale locale) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        Character thinSpace = Character.valueOf('\u00a0');
        if (thinSpace.equals(Character.valueOf(symbols.getGroupingSeparator()))) {
            symbols.setGroupingSeparator('.');
        }
        return symbols;
    }

    public static DateTimeFormatter getLocaleZonedDateTimeParsers(Locale locale) {
        DateTimeFormatterBuilder formatBuilder = new DateTimeFormatterBuilder();
        return formatBuilder.parseLenient().appendOptional(DateTimeFormatter.ISO_ZONED_DATE_TIME.withLocale(locale)).appendOptional(DateTimeFormatter.ISO_ZONED_DATE_TIME).appendOptional(DateTimeFormatter.ISO_OFFSET_DATE_TIME).toFormatter(locale);
    }

    public static DateTimeFormatter getLocaleDateTimeParsers(Locale locale) {
        DateTimeFormatterBuilder formatBuilder = new DateTimeFormatterBuilder();
        return formatBuilder.parseLenient().appendOptional(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.SHORT).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.LONG).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.FULL).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL).withLocale(locale)).appendOptional(new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd hh:mm:ss a").toFormatter(locale)).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).appendOptional(DateTimeFormatter.ofPattern("dd-MMM-yyyy HH:mm:ss")).appendOptional(DateTimeFormatter.ofPattern("'{ts '''yyyy-MM-dd HH:mm:ss'''}'")).appendOptional(DateTimeFormatter.ofPattern("EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)")).appendOptional(DateTimeFormatter.ISO_INSTANT).appendOptional(DateTimeFormatter.ISO_DATE_TIME).appendOptional(DateTimeFormatter.ISO_LOCAL_DATE_TIME).toFormatter(locale);
    }

    public static DateTimeFormatter getLocaleDateParsers(Locale locale) {
        DateTimeFormatterBuilder formatBuilder = new DateTimeFormatterBuilder();
        return formatBuilder.parseLenient().appendOptional(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).withLocale(locale)).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd")).appendOptional(DateTimeFormatter.ofPattern("yyyy.MM.dd")).appendOptional(DateTimeFormatter.ofPattern("MM/dd/yyyy")).appendOptional(DateTimeFormatter.ofPattern("dd-MMM-yy")).appendOptional(DateTimeFormatter.ISO_DATE).appendOptional(DateTimeFormatter.ISO_LOCAL_DATE).appendOptional(DateTimeFormatter.BASIC_ISO_DATE).toFormatter(locale);
    }

    public static DateTimeFormatter getLocaleTimeParsers(Locale locale) {
        DateTimeFormatterBuilder formatBuilder = new DateTimeFormatterBuilder();
        return formatBuilder.parseLenient().appendOptional(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG).withLocale(locale)).appendOptional(DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL).withLocale(locale)).appendOptional(DateTimeFormatter.ofPattern("hh:mm a")).appendOptional(DateTimeFormatter.ISO_TIME).toFormatter(locale);
    }

    public static Locale buildLocale(String language) {
        return new Locale.Builder().setLanguage(language).build();
    }

    public static Locale buildLocale(String language, String region) {
        return new Locale.Builder().setLanguage(language).setRegion(region).build();
    }

    public static Locale buildLocale(String language, String region, String variant) {
        return new Locale.Builder().setLanguage(language).setRegion(region).setVariant(variant).build();
    }

    static {
        COMMON_LOCALES.put(Key.of("Canada"), Locale.CANADA);
        COMMON_LOCALES.put(Key.of("Canadian"), Locale.CANADA);
        COMMON_LOCALES.put(Key.of("Canada_French"), Locale.CANADA_FRENCH);
        COMMON_LOCALES.put(Key.of("French Canadian"), Locale.CANADA_FRENCH);
        COMMON_LOCALES.put(Key.of("China"), Locale.CHINA);
        COMMON_LOCALES.put(Key.of("Chinese"), Locale.CHINESE);
        COMMON_LOCALES.put(Key.of("English"), Locale.ENGLISH);
        COMMON_LOCALES.put(Key.of("France"), Locale.FRANCE);
        COMMON_LOCALES.put(Key.of("French"), Locale.FRENCH);
        COMMON_LOCALES.put(Key.of("German"), Locale.GERMAN);
        COMMON_LOCALES.put(Key.of("Germany"), Locale.GERMANY);
        COMMON_LOCALES.put(Key.of("Italian"), Locale.ITALIAN);
        COMMON_LOCALES.put(Key.of("Italy"), Locale.ITALY);
        COMMON_LOCALES.put(Key.of("Japan"), Locale.JAPAN);
        COMMON_LOCALES.put(Key.of("Japanese"), Locale.JAPANESE);
        COMMON_LOCALES.put(Key.of("Korea"), Locale.KOREA);
        COMMON_LOCALES.put(Key.of("Korean"), Locale.KOREAN);
        COMMON_LOCALES.put(Key.of("PRC"), Locale.PRC);
        COMMON_LOCALES.put(Key.of("root"), Locale.ROOT);
        COMMON_LOCALES.put(Key.of("Simplified_Chinese"), Locale.SIMPLIFIED_CHINESE);
        COMMON_LOCALES.put(Key.of("Taiwan"), Locale.TAIWAN);
        COMMON_LOCALES.put(Key.of("Traditional_Chinese"), Locale.TRADITIONAL_CHINESE);
        COMMON_LOCALES.put(Key.of("UK"), Locale.UK);
        COMMON_LOCALES.put(Key.of("United Kingdom"), Locale.UK);
        COMMON_LOCALES.put(Key.of("British"), Locale.UK);
        COMMON_LOCALES.put(Key.of("US"), LocalizationUtil.buildLocale("en", "US"));
        COMMON_LOCALES.put(Key.of("United States"), LocalizationUtil.buildLocale("en", "US"));
        ISO_COUNTRIES = new Array(Locale.getISOCountries());
        ISO_LANGUAGES = new Array(Locale.getISOLanguages());
        LOCALE_ALIASES = new LinkedHashMap<Key, Locale>();
        LOCALE_ALIASES.put(Key.of("Albanian (Albania)"), LocalizationUtil.buildLocale("sq", "AL"));
        LOCALE_ALIASES.put(Key.of("Arabic (Algeria)"), LocalizationUtil.buildLocale("ar", "DZ"));
        LOCALE_ALIASES.put(Key.of("Arabic (Bahrain)"), LocalizationUtil.buildLocale("ar", "BH"));
        LOCALE_ALIASES.put(Key.of("Arabic (Egypt)"), LocalizationUtil.buildLocale("ar", "EG"));
        LOCALE_ALIASES.put(Key.of("Arabic (Iraq)"), LocalizationUtil.buildLocale("ar", "IQ"));
        LOCALE_ALIASES.put(Key.of("Arabic (Jordan)"), LocalizationUtil.buildLocale("ar", "JO"));
        LOCALE_ALIASES.put(Key.of("Arabic (Kuwait)"), LocalizationUtil.buildLocale("ar", "KW"));
        LOCALE_ALIASES.put(Key.of("Arabic (Lebanon)"), LocalizationUtil.buildLocale("ar", "LB"));
        LOCALE_ALIASES.put(Key.of("Arabic (Libya)"), LocalizationUtil.buildLocale("ar", "LY"));
        LOCALE_ALIASES.put(Key.of("Arabic (Morocco)"), LocalizationUtil.buildLocale("ar", "MA"));
        LOCALE_ALIASES.put(Key.of("Arabic (Oman)"), LocalizationUtil.buildLocale("ar", "OM"));
        LOCALE_ALIASES.put(Key.of("Arabic (Qatar)"), LocalizationUtil.buildLocale("ar", "QA"));
        LOCALE_ALIASES.put(Key.of("Arabic (Saudi Arabia)"), LocalizationUtil.buildLocale("ar", "SA"));
        LOCALE_ALIASES.put(Key.of("Arabic (Sudan)"), LocalizationUtil.buildLocale("ar", "SD"));
        LOCALE_ALIASES.put(Key.of("Arabic (Syria)"), LocalizationUtil.buildLocale("ar", "SY"));
        LOCALE_ALIASES.put(Key.of("Arabic (Tunisia)"), LocalizationUtil.buildLocale("ar", "TN"));
        LOCALE_ALIASES.put(Key.of("Arabic (United Arab Emirates)"), LocalizationUtil.buildLocale("ar", "AE"));
        LOCALE_ALIASES.put(Key.of("Arabic (Yemen)"), LocalizationUtil.buildLocale("ar", "YE"));
        LOCALE_ALIASES.put(Key.of("Chinese (China)"), Locale.CHINA);
        LOCALE_ALIASES.put(Key.of("Chinese (Hong Kong)"), LocalizationUtil.buildLocale("zh", "HK"));
        LOCALE_ALIASES.put(Key.of("Chinese (Singapore)"), LocalizationUtil.buildLocale("zh", "SG"));
        LOCALE_ALIASES.put(Key.of("Chinese (Taiwan)"), LocalizationUtil.buildLocale("zh", "TW"));
        LOCALE_ALIASES.put(Key.of("Dutch (Belgian)"), LocalizationUtil.buildLocale("nl", "BE"));
        LOCALE_ALIASES.put(Key.of("Dutch (Belgium)"), LOCALE_ALIASES.get(Key.of("dutch (belgian)")));
        LOCALE_ALIASES.put(Key.of("Dutch (Standard)"), LocalizationUtil.buildLocale("nl", "NL"));
        LOCALE_ALIASES.put(Key.of("English (Australian)"), LocalizationUtil.buildLocale("en", "AU"));
        LOCALE_ALIASES.put(Key.of("English (Australia)"), LOCALE_ALIASES.get(Key.of("english (australian)")));
        LOCALE_ALIASES.put(Key.of("English (Canadian)"), Locale.CANADA);
        LOCALE_ALIASES.put(Key.of("English (Canada)"), Locale.CANADA);
        LOCALE_ALIASES.put(Key.of("English (New zealand)"), LocalizationUtil.buildLocale("en", "NZ"));
        LOCALE_ALIASES.put(Key.of("English (UK)"), Locale.UK);
        LOCALE_ALIASES.put(Key.of("English (United Kingdom)"), Locale.UK);
        LOCALE_ALIASES.put(Key.of("English (GB)"), Locale.UK);
        LOCALE_ALIASES.put(Key.of("English (Great Britan)"), Locale.UK);
        LOCALE_ALIASES.put(Key.of("English (US)"), LocalizationUtil.buildLocale("en", "US"));
        LOCALE_ALIASES.put(Key.of("English (USA)"), LOCALE_ALIASES.get(Key.of("English (US)")));
        LOCALE_ALIASES.put(Key.of("English (United States)"), LOCALE_ALIASES.get(Key.of("English (US)")));
        LOCALE_ALIASES.put(Key.of("English (United States of America)"), LOCALE_ALIASES.get(Key.of("English (US)")));
        LOCALE_ALIASES.put(Key.of("French (Belgium)"), LocalizationUtil.buildLocale("fr", "BE"));
        LOCALE_ALIASES.put(Key.of("French (Belgian)"), LocalizationUtil.buildLocale("fr", "BE"));
        LOCALE_ALIASES.put(Key.of("French (Canadian)"), Locale.CANADA_FRENCH);
        LOCALE_ALIASES.put(Key.of("French (Canadia)"), Locale.CANADA_FRENCH);
        LOCALE_ALIASES.put(Key.of("French (Standard)"), Locale.FRANCE);
        LOCALE_ALIASES.put(Key.of("French (Swiss)"), LocalizationUtil.buildLocale("fr", "CH"));
        LOCALE_ALIASES.put(Key.of("German (Austrian)"), LocalizationUtil.buildLocale("de", "AT"));
        LOCALE_ALIASES.put(Key.of("German (Austria)"), LocalizationUtil.buildLocale("de", "AT"));
        LOCALE_ALIASES.put(Key.of("German (Standard)"), Locale.GERMANY);
        LOCALE_ALIASES.put(Key.of("German (Swiss)"), LocalizationUtil.buildLocale("de", "CH"));
        LOCALE_ALIASES.put(Key.of("Italian (Standard)"), Locale.ITALIAN);
        LOCALE_ALIASES.put(Key.of("Italian (Swiss)"), LocalizationUtil.buildLocale("it", "CH"));
        LOCALE_ALIASES.put(Key.of("Japanese"), Locale.JAPANESE);
        LOCALE_ALIASES.put(Key.of("Korean"), Locale.KOREAN);
        LOCALE_ALIASES.put(Key.of("Norwegian (Bokmal)"), LocalizationUtil.buildLocale("no", "NO"));
        LOCALE_ALIASES.put(Key.of("Norwegian (Nynorsk)"), LocalizationUtil.buildLocale("no", "NO"));
        LOCALE_ALIASES.put(Key.of("Portuguese (Brazilian)"), LocalizationUtil.buildLocale("pt", "BR"));
        LOCALE_ALIASES.put(Key.of("Portuguese (Brazil)"), LOCALE_ALIASES.get(Key.of("portuguese (brazilian)")));
        LOCALE_ALIASES.put(Key.of("Portuguese (Standard)"), LocalizationUtil.buildLocale("pt", "PT"));
        LOCALE_ALIASES.put(Key.of("Rhaeto-Romance (Swiss)"), LocalizationUtil.buildLocale("rm", "CH"));
        LOCALE_ALIASES.put(Key.of("Rhaeto-Romance (Swiss)"), LocalizationUtil.buildLocale("rm", "CH"));
        LOCALE_ALIASES.put(Key.of("Spanish (Modern)"), LocalizationUtil.buildLocale("es", "ES"));
        LOCALE_ALIASES.put(Key.of("Spanish (Standard)"), LocalizationUtil.buildLocale("es", "ES"));
        LOCALE_ALIASES.put(Key.of("Swedish"), LocalizationUtil.buildLocale("sv", "SE"));
        LOCALE_ALIASES.put(Key.of("Welsh"), LocalizationUtil.buildLocale("cy", "GB"));
        COMMON_NUMBER_FORMATTERS = new Struct(new HashMap());
        COMMON_NUMBER_FORMATTERS.put(Key.of("USD"), (Object)DecimalFormat.getCurrencyInstance(COMMON_LOCALES.get(Key.of("US"))));
        COMMON_NUMBER_FORMATTERS.put(Key.of("EURO"), (Object)DecimalFormat.getCurrencyInstance(COMMON_LOCALES.get(Key.of("German"))));
        DEFAULT_NUMBER_FORMAT_KEY = Key.of(",");
        NUMBER_FORMAT_PATTERNS = new HashMap();
        NUMBER_FORMAT_PATTERNS.put(Key.of("()"), "0;(0)");
        NUMBER_FORMAT_PATTERNS.put(Key.of("_,2"), "#.00");
        NUMBER_FORMAT_PATTERNS.put(Key.of("_,3"), "#.000");
        NUMBER_FORMAT_PATTERNS.put(Key.of("_,4"), "#.0000");
        NUMBER_FORMAT_PATTERNS.put(Key.of("_,5"), "#.00000");
        NUMBER_FORMAT_PATTERNS.put(Key.of("_,6"), "#.000000");
        NUMBER_FORMAT_PATTERNS.put(Key.of("_,7"), "#.0000000");
        NUMBER_FORMAT_PATTERNS.put(Key.of("_,8"), "#.00000000");
        NUMBER_FORMAT_PATTERNS.put(Key.of("_,9"), "#.000000000");
        NUMBER_FORMAT_PATTERNS.put(Key.of("+"), "+0;-0");
        NUMBER_FORMAT_PATTERNS.put(Key.of("-"), " 0;-0");
        NUMBER_FORMAT_PATTERNS.put(Key.dollarFormat, "$#,##0.00;($#,##0.00)");
        NUMBER_FORMAT_PATTERNS.put(DEFAULT_NUMBER_FORMAT_KEY, "#,#00.#");
        ZONE_ALIASES = new HashMap();
        ZONE_ALIASES.putAll(ZoneId.SHORT_IDS.entrySet().stream().collect(Collectors.toMap(entry -> Key.of((String)entry.getKey()), entry -> (String)entry.getValue())));
        ZONE_ALIASES.putAll(ZoneId.getAvailableZoneIds().stream().collect(Collectors.toMap(entry -> Key.of(entry), entry -> entry)));
        ZONE_ALIASES.put(Key.of("PDT"), "America/Los_Angeles");
        ZONE_ALIASES.put(Key.of("MDT"), "America/Denver");
        ZONE_ALIASES.put(Key.of("CDT"), "America/Chicago");
        ZONE_ALIASES.put(Key.of("EDT"), "America/New_York");
    }
}

