/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class NetworkUtil {
    public static InetAddress getLocalHost() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public static String getLocalIPAddress() {
        try {
            return NetworkUtil.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public static String getLocalHostname() {
        try {
            return NetworkUtil.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static String getLocalMacAddress() {
        byte[] macAddress;
        NetworkInterface network;
        try {
            network = NetworkInterface.getByInetAddress(NetworkUtil.getLocalHost());
        }
        catch (SocketException | UnknownHostException e) {
            return "";
        }
        if (network == null) {
            return "";
        }
        try {
            macAddress = network.getHardwareAddress();
        }
        catch (SocketException e) {
            return "";
        }
        if (macAddress == null) {
            return "";
        }
        StringBuilder macAddressString = new StringBuilder();
        for (int i = 0; i < macAddress.length; ++i) {
            macAddressString.append(String.format("%02X%s", macAddress[i], i < macAddress.length - 1 ? "-" : ""));
        }
        return macAddressString.toString();
    }
}

