/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.ThreadBoxContext;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.LocalScope;
import ortus.boxlang.runtime.scopes.ThreadScope;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class RequestThreadManager {
    public static final String DEFAULT_THREAD_PREFIX = "BL-Thread-";
    public static final long DEFAULT_THREAD_WAIT_TIME = 3000L;
    protected Map<Key, IStruct> threads = new ConcurrentHashMap<Key, IStruct>();
    protected IScope threadScope = new ThreadScope();
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup("BL-Threads");
    private static final Logger logger = LoggerFactory.getLogger(RequestThreadManager.class);

    public synchronized IStruct registerThread(Key name, ThreadBoxContext context) {
        if (this.threads.containsKey(name)) {
            throw new RuntimeException("Thread name [" + String.valueOf(name) + "] already in use for this request.");
        }
        Object[] objectArray = new Object[18];
        objectArray[0] = Key._NAME;
        objectArray[1] = name;
        objectArray[2] = Key.elapsedTime;
        objectArray[3] = 0;
        objectArray[4] = Key.error;
        objectArray[5] = null;
        objectArray[6] = Key.output;
        objectArray[7] = "";
        objectArray[8] = Key.stackTrace;
        objectArray[9] = "";
        objectArray[10] = Key.interrupted;
        objectArray[11] = false;
        objectArray[12] = Key.priority;
        objectArray[13] = switch (context.getThread().getPriority()) {
            case 1 -> "LOW";
            case 5 -> "NORMAL";
            case 10 -> "HIGH";
            default -> "UNKNOWN";
        };
        objectArray[14] = Key.startTime;
        objectArray[15] = new DateTime();
        objectArray[16] = Key.status;
        objectArray[17] = "NOT_STARTED";
        IStruct threadMeta = Struct.of(objectArray);
        this.threadScope.put(name, (Object)threadMeta);
        return this.threads.put(name, Struct.of(new Object[]{Key.context, context, Key._NAME, name, Key.startTicks, System.currentTimeMillis(), Key.metadata, threadMeta}));
    }

    public IStruct getThreadMeta(Key name) {
        IStruct threadData = this.threads.get(name);
        if (threadData == null) {
            return threadData;
        }
        IStruct threadMeta = threadData.getAsStruct(Key.metadata);
        String threadStatus = threadMeta.getAsString(Key.status);
        if (threadStatus.equals("NOT_STARTED") || threadStatus.equals("RUNNNG") || threadStatus.equals("WAITING")) {
            Thread thread = ((ThreadBoxContext)threadData.get(Key.context)).getThread();
            Thread.State currentThreadState = thread.getState();
            IStruct exception = threadMeta.getAsStruct(Key.error);
            threadStatus = switch (currentThreadState) {
                case Thread.State.NEW -> "NOT_STARTED";
                case Thread.State.RUNNABLE -> "RUNNNG";
                case Thread.State.TERMINATED -> {
                    if (exception == null) {
                        yield "COMPLETED";
                    }
                    yield "TERMINATED";
                }
                case Thread.State.BLOCKED -> "WAITING";
                case Thread.State.WAITING -> "WAITING";
                case Thread.State.TIMED_WAITING -> "WAITING";
                default -> "UNKNOWN";
            };
            threadMeta.put(Key.status, (Object)threadStatus);
            threadMeta.put(Key.elapsedTime, (Object)(System.currentTimeMillis() - threadData.getAsLong(Key.startTicks)));
            if (threadStatus.equals("RUNNNG") || threadStatus.equals("WAITING")) {
                StackTraceElement[] stackTrace;
                StringBuilder stackTraceBuilder = new StringBuilder();
                for (StackTraceElement element : stackTrace = thread.getStackTrace()) {
                    stackTraceBuilder.append(element.toString()).append("\n");
                }
                threadMeta.put(Key.stackTrace, (Object)stackTraceBuilder.toString());
            } else {
                threadMeta.put(Key.stackTrace, (Object)"");
            }
        }
        return threadMeta;
    }

    public IStruct getThreadData(Key name) {
        IStruct threadData = this.threads.get(name);
        if (threadData == null) {
            this.throwInvalidThreadException(name);
        }
        return threadData;
    }

    public void completeThread(Key name, String output, Throwable exception, Boolean interrupted) {
        IStruct threadData = this.threads.get(name);
        if (threadData == null) {
            return;
        }
        IStruct threadMeta = threadData.getAsStruct(Key.metadata);
        Thread targetThread = ((ThreadBoxContext)threadData.get(Key.context)).getThread();
        threadMeta.put(Key.interrupted, (Object)interrupted);
        threadMeta.put(Key.error, (Object)exception);
        threadMeta.put(Key.output, (Object)output);
        threadMeta.put(Key.status, (Object)(exception == null ? "COMPLETED" : "TERMINATED"));
        threadMeta.put(Key.elapsedTime, (Object)(System.currentTimeMillis() - threadData.getAsLong(Key.startTicks)));
        threadMeta.put(Key.stackTrace, (Object)targetThread.getStackTrace());
    }

    public static Key ensureThreadName(String name) {
        if (name == null || name.isEmpty()) {
            name = UUID.randomUUID().toString();
        }
        return Key.of(name);
    }

    public ThreadBoxContext createThreadContext(IBoxContext context, Key name) {
        return new ThreadBoxContext(context, this, name);
    }

    public Thread startThread(ThreadBoxContext context, Key name, String priority, Runnable task, IStruct attributes) {
        Thread thread = new Thread(this.getThreadGroup(), task, DEFAULT_THREAD_PREFIX + name.getName());
        thread.setPriority(switch (priority) {
            case "high" -> 10;
            case "low" -> 1;
            default -> 5;
        });
        context.setThread(thread);
        LocalScope local = (LocalScope)context.getScopeNearby(LocalScope.name);
        local.put(Key.attributes, (Object)attributes);
        this.registerThread(name, context);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateThread(Key name) {
        IStruct threadData = this.threads.get(name);
        if (threadData == null) {
            this.throwInvalidThreadException(name);
            return;
        }
        ThreadBoxContext context = (ThreadBoxContext)threadData.get(Key.context);
        Thread targetThread = context.getThread();
        targetThread.interrupt();
        try {
            targetThread.join(3000L);
            if (targetThread.isAlive()) {
                targetThread.stop();
            }
        }
        catch (InterruptedException e) {
            targetThread.interrupt();
            targetThread.stop();
        }
        finally {
            this.completeThread(name, "", new InterruptedException("Thread requested to terminate"), true);
        }
    }

    public void joinAllThreads(Integer timeout) {
        this.joinThreads(Array.fromArray(this.getThreadNames()), timeout);
    }

    public void joinThreads(Array names, Integer timeout) {
        int timeoutMSLeft = timeout;
        long start = System.currentTimeMillis();
        for (Object threadName : names) {
            this.joinThread(Key.of(threadName), timeoutMSLeft);
            if (timeout <= 0 || (timeoutMSLeft = timeout - (int)(System.currentTimeMillis() - start)) > 0) continue;
            return;
        }
    }

    public void joinThread(Key name, Integer timeout) {
        Objects.requireNonNull(name, "Thread name is required for join");
        try {
            ((ThreadBoxContext)this.getThreadData(name).get(Key.context)).getThread().join(timeout.intValue());
        }
        catch (InterruptedException e) {
            throw new BoxRuntimeException("Thread join interrupted", e);
        }
    }

    public boolean hasThreads() {
        return !this.threads.isEmpty();
    }

    public IScope getThreadScope() {
        return this.threadScope;
    }

    public ThreadGroup getThreadGroup() {
        return THREAD_GROUP;
    }

    public boolean isInThread() {
        return Thread.currentThread().getThreadGroup() == THREAD_GROUP;
    }

    public Key[] getThreadNames() {
        return this.threads.keySet().toArray(new Key[0]);
    }

    private void throwInvalidThreadException(Key name) {
        throw new BoxRuntimeException("No thread with name [" + name.getName() + "] not found. Valid names are [" + Arrays.stream(this.getThreadNames()).map(Key::getName).collect(Collectors.joining(", ")) + "].");
    }
}

