/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.util.BoxFQN;
import ortus.boxlang.runtime.util.FQN;

public record ResolvedFilePath(String mappingName, String mappingPath, String relativePath, Path absolutePath) {
    public static ResolvedFilePath of(String mappingName, String mappingPath, String relativePath, Path absolutePath) {
        return new ResolvedFilePath(mappingName, mappingPath, relativePath, absolutePath != null ? ResolvedFilePath.makeReal(absolutePath.normalize()) : null);
    }

    public static ResolvedFilePath of(String mappingName, String mappingPath, String relativePath, String absolutePath) {
        return ResolvedFilePath.of(mappingName, mappingPath, relativePath, Path.of(absolutePath, new String[0]));
    }

    public static ResolvedFilePath of(Path absolutePath) {
        return new ResolvedFilePath(null, null, absolutePath != null ? absolutePath.normalize().toString() : null, ResolvedFilePath.makeReal(absolutePath));
    }

    public static ResolvedFilePath of(String absolutePath) {
        return ResolvedFilePath.of(Path.of(absolutePath, new String[0]));
    }

    public boolean resolvedViaMapping() {
        return this.mappingName != null;
    }

    public FQN getFQN(String prefix) {
        return FQN.of(prefix, this.relativePath != null ? Path.of(this.relativePath, new String[0]) : this.absolutePath);
    }

    public FQN getFQN() {
        return FQN.of(this.relativePath != null ? Path.of(this.relativePath, new String[0]) : this.absolutePath);
    }

    public BoxFQN getBoxFQN() {
        return BoxFQN.of(this.relativePath != null ? Path.of(this.relativePath, new String[0]) : this.absolutePath);
    }

    public BoxFQN getBoxFQN(String prefix) {
        return BoxFQN.of(prefix, this.relativePath != null ? Path.of(this.relativePath, new String[0]) : this.absolutePath);
    }

    public ResolvedFilePath newFromRelative(String relativePath) {
        String newRelativePath;
        Path absoluteParent = this.absolutePath().getParent();
        Path newAbsolutePath = absoluteParent.resolve(relativePath);
        if (this.absolutePath().toString().equals(this.relativePath())) {
            newRelativePath = newAbsolutePath.toString();
        } else {
            String tmpAbsolutePath = Paths.get(this.absolutePath().toString(), new String[0]).toAbsolutePath().normalize().toString();
            String tmpRelativePath = Paths.get(this.relativePath(), new String[0]).normalize().toString();
            Path absoluteRoot = Paths.get(tmpAbsolutePath.replace(tmpRelativePath, ""), new String[0]);
            newRelativePath = absoluteRoot.relativize(newAbsolutePath).toString();
        }
        return ResolvedFilePath.of(this.mappingName, this.mappingPath, newRelativePath, newAbsolutePath);
    }

    private static Path makeReal(Path path) {
        if (path != null && path.toFile().exists()) {
            try {
                return path.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new BoxIOException(e);
            }
        }
        return path;
    }
}

