/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class Timer {
    public static final DecimalFormat TIMING_FORMAT = new DecimalFormat("#.##");
    private Map<String, Long> timers = new ConcurrentHashMap<String, Long>(32);
    private boolean autoRemoveTimers;
    private static final HashMap<TimeUnit, java.util.concurrent.TimeUnit> TIME_UNITS = new HashMap();
    private static final Map<TimeUnit, String> UNIT_ABBREVIATIONS = new HashMap<TimeUnit, String>();

    public Timer() {
        this.autoRemoveTimers = true;
    }

    public Timer(boolean autoRemoveTimers) {
        this.autoRemoveTimers = autoRemoveTimers;
    }

    public static Timer create(boolean autoRemoveTimers) {
        return new Timer(autoRemoveTimers);
    }

    public static Timer create() {
        return new Timer();
    }

    public static long timeAndPrint(Runnable runnable) {
        return Timer.timeAndPrint(runnable, null, TimeUnit.MILLISECONDS);
    }

    public static long timeAndPrint(Runnable runnable, String label) {
        return Timer.timeAndPrint(runnable, label, TimeUnit.MILLISECONDS);
    }

    public static long timeAndPrint(Runnable runnable, String label, TimeUnit timeUnit) {
        if (label == null) {
            label = "Lambda";
        }
        long start = System.nanoTime();
        runnable.run();
        long elapsed = System.nanoTime() - start;
        System.out.println(label + " took: " + TIMING_FORMAT.format(Timer.convert(elapsed, timeUnit)) + " " + String.valueOf((Object)timeUnit));
        return elapsed;
    }

    public Map<String, Long> getTimers() {
        return this.timers;
    }

    public void clearTimers() {
        this.timers.clear();
    }

    public void printTimers(TimeUnit timeUnit) {
        System.out.println("|----------------------|----------------------|");
        System.out.println("| Timer                | Duration             |");
        System.out.println("|----------------------|----------------------|");
        for (Map.Entry<String, Long> entry : this.timers.entrySet()) {
            String key = entry.getKey();
            long duration = entry.getValue();
            System.out.printf("| %-20s | %-20s |%n", key, TIMING_FORMAT.format(Timer.convert(duration, timeUnit)));
        }
        System.out.println("|----------------------|----------------------|");
        System.out.println("");
        System.out.println("Duration = " + String.valueOf((Object)timeUnit));
    }

    public void printTimers() {
        this.printTimers(TimeUnit.MILLISECONDS);
    }

    public Timer start(String label) {
        this.timers.put(label, System.nanoTime());
        return this;
    }

    public String timeIt(Runnable runnable, TimeUnit timeUnit) {
        String label = "timer-" + String.valueOf(UUID.randomUUID());
        this.start(label);
        runnable.run();
        return this.stop(label, timeUnit);
    }

    public long timeItRaw(Runnable runnable, TimeUnit timeUnit) {
        String label = "timer-" + String.valueOf(UUID.randomUUID());
        this.start(label);
        runnable.run();
        return this.stopAndGet(label, timeUnit);
    }

    public String timeIt(Runnable runnable) {
        String label = "timer-" + String.valueOf(UUID.randomUUID());
        this.start(label);
        runnable.run();
        return this.stop(label);
    }

    public String timeIt(Runnable runnable, String label) {
        this.start(label);
        runnable.run();
        return this.stop(label);
    }

    public long stopAndGetSeconds(String label) {
        return TIME_UNITS.get((Object)TimeUnit.SECONDS).convert(this.stopAndGetNanos(label), java.util.concurrent.TimeUnit.NANOSECONDS);
    }

    public long stopAndGetMillis(String label) {
        return TIME_UNITS.get((Object)TimeUnit.MILLISECONDS).convert(this.stopAndGetNanos(label), java.util.concurrent.TimeUnit.NANOSECONDS);
    }

    public long stopAndGetNanos(String label) {
        if (!this.timers.containsKey(label)) {
            throw new BoxRuntimeException("Timer '" + label + "' not started.");
        }
        long endTime = System.nanoTime();
        long startTime = this.timers.get(label);
        long duration = endTime - startTime;
        if (this.autoRemoveTimers) {
            this.timers.remove(label);
        } else {
            this.timers.put(label, duration);
        }
        return duration;
    }

    public long stopAndGet(String label, TimeUnit timeUnit) {
        return TIME_UNITS.get((Object)timeUnit).convert(this.stopAndGetNanos(label), java.util.concurrent.TimeUnit.NANOSECONDS);
    }

    public String stop(String label, TimeUnit timeUnit) {
        return this.stopAndGet(label, timeUnit) + " " + UNIT_ABBREVIATIONS.get((Object)timeUnit);
    }

    public String stop(String label) {
        return this.stop(label, TimeUnit.MILLISECONDS);
    }

    public Timer stopAndPrint(String label) {
        return this.stopAndPrint(label, TimeUnit.MILLISECONDS);
    }

    public Timer stopAndPrint(String label, TimeUnit timeUnit) {
        System.out.println(label + " took: " + this.stop(label, timeUnit));
        return this;
    }

    public static long convert(long time, TimeUnit timeUnit) {
        return TIME_UNITS.get((Object)timeUnit).convert(time, java.util.concurrent.TimeUnit.NANOSECONDS);
    }

    static {
        UNIT_ABBREVIATIONS.put(TimeUnit.NANOSECONDS, "ns");
        UNIT_ABBREVIATIONS.put(TimeUnit.MICROSECONDS, "\u00b5s");
        UNIT_ABBREVIATIONS.put(TimeUnit.MILLISECONDS, "ms");
        UNIT_ABBREVIATIONS.put(TimeUnit.SECONDS, "s");
        TIME_UNITS.put(TimeUnit.SECONDS, java.util.concurrent.TimeUnit.SECONDS);
        TIME_UNITS.put(TimeUnit.MILLISECONDS, java.util.concurrent.TimeUnit.MILLISECONDS);
        TIME_UNITS.put(TimeUnit.NANOSECONDS, java.util.concurrent.TimeUnit.NANOSECONDS);
        TIME_UNITS.put(TimeUnit.MICROSECONDS, java.util.concurrent.TimeUnit.MICROSECONDS);
    }

    public static enum TimeUnit {
        SECONDS,
        MILLISECONDS,
        NANOSECONDS,
        MICROSECONDS;

    }
}

