/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.time.Instant;
import java.util.Queue;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentLinkedQueue;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.ApplicationBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.logging.LogLevel;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;

public class Tracer {
    private final Queue<TracerRecord> traceRecords = new ConcurrentLinkedQueue<TracerRecord>();

    public void trace(String category, String type, String text, Object extraInfo, IBoxContext context) {
        String logType = LogLevel.valueOf(type.trim(), false).getName();
        String extraAsString = Tracer.extraToString(extraInfo);
        String positionInCode = ExceptionUtil.getCurrentPositionInCode();
        String applicationName = "uknown-application";
        ApplicationBoxContext appContext = context.getParentOfType(ApplicationBoxContext.class);
        if (appContext != null) {
            applicationName = appContext.getApplication().getName().getName();
        }
        this.traceRecords.add(new TracerRecord(applicationName, Instant.now(), positionInCode, category, logType, text, extraAsString));
        String traceMessage = new StringJoiner(" ").add("[").add(applicationName).add("]").add("[").add(category).add("]").add("[").add(positionInCode).add("]").add("[").add(text).add("]").add("[").add(extraAsString).add("]").toString();
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.LOG_MESSAGE, Struct.of(new Object[]{Key.text, traceMessage, Key.log, "trace", Key.type, logType}));
    }

    public Queue<TracerRecord> getTracers() {
        return this.traceRecords;
    }

    public int count() {
        return this.traceRecords.size();
    }

    public Tracer reset() {
        this.traceRecords.clear();
        return this;
    }

    private static String extraToString(Object extraInfo) {
        if (extraInfo == null) {
            return "[null]";
        }
        if (extraInfo instanceof IType) {
            IType t = (IType)extraInfo;
            return t.asString();
        }
        return extraInfo.toString();
    }

    public record TracerRecord(String applicationName, Instant tracedAt, String traceLocation, String category, String type, String text, String extraInfo) {
    }
}

