/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.operators.GreaterThanEqual;
import ortus.boxlang.runtime.operators.LessThanEqual;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.types.Closure;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.Lambda;
import ortus.boxlang.runtime.types.UDF;

public class ValidationUtil {
    public static final Pattern URL = Pattern.compile("^(https?|ftp|file)://([A-Za-z0-90.]*)/?([-a-zA-Z0-9.+&@#/]+)?(\\??[^\\s]*)$");
    public static final Pattern TELEPHONE = Pattern.compile("^(?:(?:\\+?1\\s*(?:[.-]\\s*)?)?(?:\\(\\s*([2-9]1[02-9]|[2-9][02-8]1|[2-9][02-8][02-9])\\s*\\)|([2-9]1[02-9]|[2-9][02-8]1|[2-9][02-8][02-9]))\\s*(?:[.-]\\s*)?)?([2-9]1[02-9]|[2-9][02-9]1|[2-9][02-9]{2})\\s*(?:[.-]\\s*)?([0-9]{4})(?:\\s*(?:#|x\\.?|ext\\.?|extension)\\s*(\\d+))?$");
    public static final Pattern ZIPCODE = Pattern.compile("\\d{5}([ -]?\\d{4})?");
    public static final Pattern SSN = Pattern.compile("^(?!219099999|078051120)(?!666|000|9\\d{2})\\d{3}(?!00)\\d{2}(?!0{4})\\d{4}$");
    public static final Pattern UUID_V4 = Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-4[a-fA-F0-9]{3}-[89abAB][a-fA-F0-9]{3}-[a-fA-F0-9]{12}");
    public static final Pattern UUID_PATTERN = Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-4[a-fA-F0-9]{3}-[89abAB][a-fA-F0-9]{3}[a-fA-F0-9]{12}");
    public static final String VALID_VARIABLE_REGEX = "^[a-zA-Z_][a-zA-Z0-9_]*$";

    public static boolean isValidCreditCard(String cardNumber) {
        int shortestValidCardLength = 12;
        int longestValidCardLength = 19;
        if (cardNumber == null || !cardNumber.matches("[0-9 ,_-]+")) {
            return false;
        }
        String sanitized = cardNumber.replaceAll("[^0-9]", "");
        if (sanitized.length() < shortestValidCardLength || sanitized.length() > longestValidCardLength) {
            return false;
        }
        int sum = 0;
        boolean alternate = false;
        for (int i = sanitized.length() - 1; i >= 0; --i) {
            int n = Character.getNumericValue(sanitized.charAt(i));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }

    public static boolean isValidInteger(Object value) {
        String stringVal;
        return value instanceof Integer || value instanceof String && NumberUtils.isDigits(stringVal = (String)value);
    }

    public static boolean isValidNumeric(Object value) {
        String stringVal;
        return value instanceof Number || value instanceof String && NumberUtils.isCreatable(stringVal = (String)value);
    }

    public static boolean isValidGUID(String uuid) {
        return UUID_V4.matcher(uuid).matches();
    }

    public static boolean isValidUUID(String uuid) {
        return UUID_PATTERN.matcher(uuid).matches();
    }

    public static boolean isValidSSN(String ssn) {
        return SSN.matcher(ssn.replace("-", "").replace(" ", "")).matches();
    }

    public static boolean isValidTelephone(String phone) {
        return TELEPHONE.matcher(phone).matches();
    }

    public static boolean isValidURL(String url) {
        return URL.matcher(url).matches();
    }

    public static boolean isValidZipCode(String zipCode) {
        return ZIPCODE.matcher(zipCode).matches();
    }

    public static boolean isValidVariableName(String variableName) {
        return variableName.matches(VALID_VARIABLE_REGEX);
    }

    public static boolean isBinary(Object value) {
        return value instanceof byte[];
    }

    public static boolean isFloat(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Float || value instanceof Double) {
            return true;
        }
        CastAttempt<String> stringAttempt = StringCaster.attempt(value);
        if (stringAttempt.wasSuccessful()) {
            try {
                Float.parseFloat(stringAttempt.get());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isBoxClass(Object value) {
        return value instanceof IClassRunnable;
    }

    public static boolean isFunction(Object value) {
        return value instanceof Function;
    }

    public static boolean isUDF(Object value) {
        return value instanceof UDF;
    }

    public static boolean isClosure(Object value) {
        return value instanceof Closure;
    }

    public static boolean isLambda(Object value) {
        return value instanceof Lambda;
    }

    public static boolean isValidRange(Object value, Number min, Number max) {
        CastAttempt<Number> castedValue = NumberCaster.attempt(value);
        if (castedValue.wasSuccessful()) {
            Number nValue = castedValue.get();
            return GreaterThanEqual.invoke(nValue, min) != false && LessThanEqual.invoke(nValue, max) != false;
        }
        return false;
    }

    public static boolean isValidMatch(String value, String regex) {
        return value.matches(regex);
    }

    public static boolean isValidMatchNoCase(String value, String regex) {
        return ValidationUtil.isValidMatch(value, "(?i)" + regex);
    }

    public static boolean isValidEmail(String email) {
        return email.matches("^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}$");
    }

    public static boolean isValidPattern(String value, String pattern) {
        return value.matches(pattern);
    }
}

