/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.BLCollector;

public class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class);

    public static String compress(COMPRESSION_FORMAT format, String source, String destination, Boolean includeBaseFolder, Boolean overwrite, String prefix, Object filter, Boolean recurse, IBoxContext context) {
        switch (format.ordinal()) {
            case 0: {
                return ZipUtil.compressZip(source, destination, includeBaseFolder, overwrite, prefix, filter, recurse, context);
            }
            case 1: {
                return ZipUtil.compressGzip(source, destination, includeBaseFolder, overwrite);
            }
        }
        throw new BoxRuntimeException("Unsupported compression format: [" + String.valueOf((Object)format) + "]");
    }

    public static String compressZip(String source, String destination, final Boolean includeBaseFolder, Boolean overwrite, String prefix, final Object filter, final Boolean recurse, final IBoxContext context) {
        final Path sourceFile = ZipUtil.ensurePath(source);
        Path destinationFile = ZipUtil.toPathWithExtension(destination, ".zip");
        if (destinationFile.toFile().exists() && !overwrite.booleanValue()) {
            throw new BoxRuntimeException("Destination file already exists: [" + destination + "]");
        }
        try (final ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(destinationFile.toFile()));){
            String pathPrefix;
            String string = pathPrefix = prefix != null && !prefix.isEmpty() ? prefix + "/" : "";
            if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                final Path basePath = (includeBaseFolder != false ? sourceFile.getParent() : sourceFile).normalize();
                Files.walkFileTree(sourceFile, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path targetFile = basePath.relativize(file.normalize());
                        String zipEntryName = pathPrefix + targetFile.toString().replace("\\", "/");
                        if (filter != null) {
                            Predicate predicate;
                            Function filterFunction;
                            String castedFilter;
                            if (filter instanceof String && (castedFilter = (String)filter).length() > 1 && !Pattern.compile(castedFilter, 2).matcher(zipEntryName).matches()) {
                                return FileVisitResult.CONTINUE;
                            }
                            if (filter instanceof Function && !BooleanCaster.cast(context.invokeFunction((Object)(filterFunction = (Function)filter), new Object[]{zipEntryName})).booleanValue()) {
                                return FileVisitResult.CONTINUE;
                            }
                            if (filter instanceof Predicate && !(predicate = (Predicate)filter).test(zipEntryName)) {
                                return FileVisitResult.CONTINUE;
                            }
                        }
                        zipOutputStream.putNextEntry(new ZipEntry(zipEntryName));
                        Files.copy(file, zipOutputStream);
                        zipOutputStream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (dir.equals(sourceFile) && !includeBaseFolder.booleanValue()) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (!recurse.booleanValue() && !dir.equals(sourceFile)) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        Path targetDir = basePath.relativize(dir.normalize());
                        String zipEntryName = pathPrefix + targetDir.toString().replace("\\", "/") + "/";
                        zipOutputStream.putNextEntry(new ZipEntry(zipEntryName));
                        zipOutputStream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                String zipEntryName = pathPrefix + sourceFile.getFileName().toString();
                zipOutputStream.putNextEntry(new ZipEntry(zipEntryName));
                Files.copy(sourceFile, zipOutputStream);
                zipOutputStream.closeEntry();
            }
        }
        catch (Exception e) {
            throw new BoxRuntimeException("Error compressing file or folder: [" + source + "] to destination: [" + destination + "]", e);
        }
        return destinationFile.toString();
    }

    public static String compressGzip(String source, String destination, final Boolean includeBaseFolder, Boolean overwrite) {
        final Path sourceFile = ZipUtil.ensurePath(source).normalize();
        Path destinationFile = ZipUtil.toPathWithExtension(destination, ".gz");
        if (Files.exists(destinationFile, new LinkOption[0]) && !overwrite.booleanValue()) {
            throw new BoxRuntimeException("Destination file already exists: [" + destination + "]");
        }
        try (final GZIPOutputStream gzipOutputStream = new GZIPOutputStream(Files.newOutputStream(destinationFile, new OpenOption[0]));){
            if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                Path basePath = (includeBaseFolder != false ? sourceFile.getParent() : sourceFile).normalize();
                Files.walkFileTree(sourceFile, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.copy(file, gzipOutputStream);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (dir.equals(sourceFile) && !includeBaseFolder.booleanValue()) {
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                Files.copy(sourceFile, gzipOutputStream);
            }
        }
        catch (Exception e) {
            throw new BoxRuntimeException("Error compressing file or folder: [" + source + "] to destination: [" + destination + "]", e);
        }
        return destinationFile.toString();
    }

    public static void extract(COMPRESSION_FORMAT format, String source, String destination, Boolean overwrite, Boolean recurse, Object filter, Array entryPaths, IBoxContext context) {
        switch (format.ordinal()) {
            case 0: {
                ZipUtil.extractZip(source, destination, overwrite, recurse, filter, entryPaths, context);
                break;
            }
            case 1: {
                ZipUtil.extractGZip(source, destination, overwrite);
                break;
            }
            default: {
                throw new BoxRuntimeException("Unsupported compression format: [" + String.valueOf((Object)format) + "]");
            }
        }
    }

    public static void extractZip(String source, String destination, Boolean overwrite, Boolean recurse, Object filter, Array entryPaths, IBoxContext context) {
        Path sourceFile = ZipUtil.ensurePath(source);
        Path destinationPath = Paths.get(destination, new String[0]).normalize().toAbsolutePath();
        try {
            if (Files.exists(destinationPath, new LinkOption[0])) {
                if (!Files.isDirectory(destinationPath, new LinkOption[0])) {
                    throw new BoxRuntimeException("Destination is not a directory: [" + destination + "]");
                }
            } else {
                Files.createDirectories(destinationPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new BoxIOException("Failed to create or verify destination directory: [" + destination + "]", e);
        }
        try (ZipFile zipFile = new ZipFile(sourceFile.toFile());){
            zipFile.stream().filter(entry -> {
                if (filter != null) {
                    String castedFilter;
                    if (filter instanceof String && (castedFilter = (String)filter).length() > 1) {
                        return Pattern.compile(castedFilter, 2).matcher(entry.getName()).matches();
                    }
                    if (filter instanceof Function) {
                        Function filterFunction = (Function)filter;
                        return BooleanCaster.cast(context.invokeFunction((Object)filterFunction, new Object[]{entry.getName()}));
                    }
                    if (filter instanceof Predicate) {
                        Predicate predicate = (Predicate)filter;
                        return predicate.test(entry);
                    }
                }
                return true;
            }).filter(entry -> {
                if (entryPaths != null && !entryPaths.isEmpty()) {
                    return entryPaths.contains(entry.getName());
                }
                return true;
            }).filter(entry -> recurse != false || !entry.getName().contains("/") || entry.getName().split("/").length <= 1).forEach(entry -> {
                block15: {
                    Path targetPath = destinationPath.resolve(entry.getName()).normalize();
                    if (!targetPath.startsWith(destinationPath)) {
                        logger.warn("Zip Slip attack detected for entry [{}], skipping extraction", (Object)entry.getName());
                        return;
                    }
                    if (Files.exists(targetPath, new LinkOption[0]) && !overwrite.booleanValue()) {
                        logger.debug("Destination file already exists: [{}] skipping extraction", (Object)targetPath);
                        return;
                    }
                    try {
                        if (entry.isDirectory()) {
                            if (!Files.exists(targetPath, new LinkOption[0])) {
                                Files.createDirectories(targetPath, new FileAttribute[0]);
                            }
                            break block15;
                        }
                        if (!Files.exists(targetPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                        }
                        try (InputStream inputStream = zipFile.getInputStream((ZipEntry)entry);){
                            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            throw new BoxRuntimeException("Error extracting entry: [" + entry.getName() + "] from zip file: [" + source + "] to destination: [" + destination + "]", e);
                        }
                    }
                    catch (IOException e) {
                        throw new BoxRuntimeException("Error creating directory or file: [" + String.valueOf(targetPath) + "]", e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new BoxRuntimeException("Error extracting zip file: [" + source + "] to destination: [" + destination + "]", e);
        }
    }

    public static void extractGZip(String source, String destination, Boolean overwrite) {
        Path sourceFile = ZipUtil.ensurePath(source);
        Path destinationDirectory = Paths.get(destination, new String[0]).normalize().toAbsolutePath();
        try {
            if (Files.exists(destinationDirectory, new LinkOption[0])) {
                if (!Files.isDirectory(destinationDirectory, new LinkOption[0])) {
                    throw new BoxRuntimeException("Destination is not a directory: [" + destination + "]");
                }
            } else {
                Files.createDirectories(destinationDirectory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new BoxIOException("Failed to create or verify destination directory: [" + destination + "]", e);
        }
        Path targetPath = destinationDirectory.resolve(sourceFile.getFileName().toString().replace(".gz", "")).normalize();
        if (Files.exists(targetPath, new LinkOption[0]) && !overwrite.booleanValue()) {
            throw new BoxRuntimeException("Destination file already exists: [" + String.valueOf(targetPath) + "] and overwrite is not allowed.");
        }
        try {
            if (!Files.exists(targetPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new BoxIOException("Failed to create parent directories for: [" + String.valueOf(targetPath) + "]", e);
        }
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(sourceFile.toFile()));
             FileOutputStream outputStream = new FileOutputStream(targetPath.toFile());){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = gzipInputStream.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error extracting GZIP file: [" + source + "] to destination: [" + destination + "]", e);
        }
    }

    public static Array listEntries(String source, Object filter, Boolean recurse, IBoxContext context) {
        Array array;
        ZipFile zipFile = new ZipFile(source);
        try {
            array = zipFile.stream().filter(entry -> {
                if (filter != null) {
                    String castedFilter;
                    if (filter instanceof String && (castedFilter = (String)filter).length() > 1) {
                        return Pattern.compile(castedFilter, 2).matcher(entry.getName()).matches();
                    }
                    if (filter instanceof Function) {
                        Function filterFunction = (Function)filter;
                        return BooleanCaster.cast(context.invokeFunction((Object)filterFunction, new Object[]{entry.getName()}));
                    }
                    if (filter instanceof Predicate) {
                        Predicate predicate = (Predicate)filter;
                        return predicate.test(entry);
                    }
                }
                return true;
            }).filter(entry -> recurse != false || !entry.getName().contains("/") || entry.getName().split("/").length <= 1).map(entry -> Struct.of("comment", entry.getComment(), "compressedSize", entry.getCompressedSize(), "crc", entry.getCrc(), "creationTime", entry.getCreationTime() == null ? "" : entry.getCreationTime().toString(), "lastAccessTime", entry.getLastAccessTime() == null ? "" : entry.getLastAccessTime().toString(), "lastModifiedTime", entry.getLastModifiedTime() == null ? "" : entry.getLastModifiedTime().toString(), "dateLastModified", new DateTime(entry.getTimeLocal()), "directory", StringUtils.substringBeforeLast(entry.getName(), "/"), "fullpath", entry.getName(), "isDirectory", entry.isDirectory(), "name", StringUtils.substringAfterLast(entry.getName(), "/"), "size", entry.getSize(), "type", entry.isDirectory() ? "directory" : "file")).collect(BLCollector.toArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new BoxRuntimeException("Error listing entries in zip file: [" + source + "]", e);
            }
        }
        zipFile.close();
        return array;
    }

    public static Array listEntriesFlat(String source, Object filter, Boolean recurse, IBoxContext context) {
        return ZipUtil.listEntries(source, filter, recurse, context).stream().map(entry -> ((IStruct)entry).getAsString(Key.of("fullpath"))).collect(BLCollector.toArray());
    }

    public static void deleteEntries(String source, Object filter, Array entryPaths, IBoxContext context) {
        Path tempFile;
        Path sourceFile = ZipUtil.ensurePath(source);
        try {
            tempFile = Files.createTempFile("ziputil_", ".zip", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BoxIOException("Failed to create a temporary file for repackaging", e);
        }
        try (ZipFile zipFile = new ZipFile(sourceFile.toFile());
             ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));){
            zipFile.stream().filter(entry -> {
                if (filter != null) {
                    String castedFilter;
                    if (filter instanceof String && (castedFilter = (String)filter).length() > 1) {
                        return !Pattern.compile(castedFilter, 2).matcher(entry.getName()).matches();
                    }
                    if (filter instanceof Function) {
                        Function filterFunction = (Function)filter;
                        return BooleanCaster.cast(context.invokeFunction((Object)filterFunction, new Object[]{entry.getName()})) == false;
                    }
                    if (filter instanceof Predicate) {
                        Predicate predicate = (Predicate)filter;
                        return !predicate.test(entry);
                    }
                }
                return true;
            }).filter(entry -> {
                if (entryPaths != null && !entryPaths.isEmpty()) {
                    return !entryPaths.contains(entry.getName());
                }
                return true;
            }).forEach(entry -> {
                try {
                    zipOutputStream.putNextEntry(new ZipEntry(entry.getName()));
                    try (InputStream inputStream = zipFile.getInputStream((ZipEntry)entry);){
                        inputStream.transferTo(zipOutputStream);
                    }
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    throw new BoxRuntimeException("Error while repackaging zip file", e);
                }
            });
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error processing zip file for deletion", e);
        }
        try {
            Files.move(tempFile, sourceFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new BoxIOException("Failed to replace the original zip file with the updated one", e);
        }
    }

    public static String readEntry(String source, String entryPath, String charset) {
        String entryContent;
        Path sourceFile = ZipUtil.ensurePath(source);
        try (ZipFile zipFile = new ZipFile(sourceFile.toFile());){
            ZipEntry entry = zipFile.getEntry(entryPath);
            if (entry == null) {
                throw new BoxRuntimeException("Entry not found in zip file: [" + entryPath + "]");
            }
            try (InputStream inputStream = zipFile.getInputStream(entry);){
                entryContent = new String(inputStream.readAllBytes(), charset);
            }
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error reading entry: [" + entryPath + "] from zip file: [" + source + "]", e);
        }
        return entryContent;
    }

    public static String readEntry(String source, String entryPath) {
        return ZipUtil.readEntry(source, entryPath, Charset.defaultCharset().name());
    }

    public static byte[] readBinaryEntry(String source, String entryPath) {
        byte[] entryContent;
        Path sourceFile = ZipUtil.ensurePath(source);
        try (ZipFile zipFile = new ZipFile(sourceFile.toFile());){
            ZipEntry entry = zipFile.getEntry(entryPath);
            if (entry == null) {
                throw new BoxRuntimeException("Entry not found in zip file: [" + entryPath + "]");
            }
            try (InputStream inputStream = zipFile.getInputStream(entry);){
                entryContent = inputStream.readAllBytes();
            }
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error reading entry: [" + entryPath + "] from zip file: [" + source + "]", e);
        }
        return entryContent;
    }

    private static Path ensurePath(String target) {
        Path sourcePath = Paths.get(target, new String[0]).normalize().toAbsolutePath();
        if (!sourcePath.toFile().exists()) {
            throw new BoxRuntimeException("Source file or folder does not exist: [" + target + "]");
        }
        return sourcePath;
    }

    private static Path toPathWithExtension(String destination, String extension) {
        Path destinationFile = Paths.get(destination, new String[0]).normalize().toAbsolutePath();
        if (!destinationFile.toString().toLowerCase().endsWith(extension)) {
            destinationFile = Paths.get(destinationFile.toString() + extension, new String[0]);
        }
        return destinationFile;
    }

    public static Boolean isZipFile(String filepath) {
        Boolean bl;
        Path path = Paths.get(filepath, new String[0]).toAbsolutePath();
        ZipFile zipFile = new ZipFile(path.toFile());
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        zipFile.close();
        return bl;
    }

    public static enum COMPRESSION_FORMAT {
        ZIP,
        GZIP;

    }
}

