/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util.conversion;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Optional;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class BoxClassState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public IStruct variablesScope = new Struct();
    public IStruct thisScope = new Struct();
    public Key classPath;

    public BoxClassState(IClassRunnable target) {
        this.classPath = target.getName();
        Array aProperties = target.getBoxMeta().getMeta().getAsArray(Key.properties);
        target.getVariablesScope().entrySet().stream().filter(entry -> !(entry.getValue() instanceof Function)).filter(entry -> this.isSerializable(aProperties, (Key)entry.getKey())).forEach(entry -> this.variablesScope.put((Key)entry.getKey(), entry.getValue()));
        target.getThisScope().entrySet().stream().filter(entry -> !(entry.getValue() instanceof Function)).forEach(entry -> this.thisScope.put((Key)entry.getKey(), entry.getValue()));
    }

    private Boolean isSerializable(Array properties, Key property) {
        Optional<IStruct> propertyMetadata = properties.stream().map(IStruct.class::cast).filter(prop -> prop.getAsKey(Key.nameAsKey).equals(property)).findFirst();
        if (propertyMetadata.isPresent()) {
            return BooleanCaster.cast(propertyMetadata.get().getAsStruct(Key.annotations).getOrDefault(Key.serializable, (Object)true));
        }
        return true;
    }

    private Object readResolve() throws ObjectStreamException {
        IBoxContext context = BoxRuntime.getInstance().getRuntimeContext();
        IClassRunnable boxClass = (IClassRunnable)ClassLocator.getInstance().load(context, this.classPath.getName(), "bx", true, context.getCurrentImports()).invokeConstructor(context, Key.noInit).unWrapBoxLangClass();
        boxClass.getVariablesScope().putAll(this.variablesScope);
        boxClass.getThisScope().putAll(this.thisScope);
        return boxClass;
    }
}

