/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util.conversion;

import com.fasterxml.jackson.jr.ob.api.ReaderWriterProvider;
import com.fasterxml.jackson.jr.ob.api.ValueReader;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.util.conversion.deserializers.ArrayDeserializer;
import ortus.boxlang.runtime.util.conversion.deserializers.DateTimeDeserializer;
import ortus.boxlang.runtime.util.conversion.deserializers.LocalDateDeserializer;
import ortus.boxlang.runtime.util.conversion.deserializers.LocalDateTimeDeserializer;
import ortus.boxlang.runtime.util.conversion.deserializers.StructDeserializer;
import ortus.boxlang.runtime.util.conversion.serializers.BoxArraySerializer;
import ortus.boxlang.runtime.util.conversion.serializers.BoxClassSerializer;
import ortus.boxlang.runtime.util.conversion.serializers.BoxFunctionSerializer;
import ortus.boxlang.runtime.util.conversion.serializers.BoxStructSerializer;
import ortus.boxlang.runtime.util.conversion.serializers.DynamicObjectSerializer;

public class BoxJsonProvider
extends ReaderWriterProvider {
    @Override
    public ValueWriter findValueWriter(JSONWriter writeContext, Class<?> type) {
        if (type == DateTime.class || type == LocalDate.class || type == java.util.Date.class || type == Date.class) {
            return new DateTime();
        }
        if (IClassRunnable.class.isAssignableFrom(type)) {
            return new BoxClassSerializer();
        }
        if (List.class.isAssignableFrom(type)) {
            return new BoxArraySerializer();
        }
        if (Function.class.isAssignableFrom(type)) {
            return new BoxFunctionSerializer();
        }
        if (Map.class.isAssignableFrom(type)) {
            return new BoxStructSerializer();
        }
        if (type == DynamicObject.class) {
            return new DynamicObjectSerializer();
        }
        return null;
    }

    @Override
    public ValueReader findValueReader(JSONReader readContext, Class<?> type) {
        if (type.equals(DateTime.class)) {
            return new DateTimeDeserializer();
        }
        if (type.equals(LocalDate.class)) {
            return new LocalDateDeserializer();
        }
        if (type.equals(LocalDateTime.class)) {
            return new LocalDateTimeDeserializer();
        }
        if (type.isAssignableFrom(Map.class)) {
            return new StructDeserializer();
        }
        if (type.isAssignableFrom(List.class)) {
            return new ArrayDeserializer();
        }
        return null;
    }
}

