/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util.conversion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.util.conversion.BoxClassState;

public class ObjectMarshaller {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(IBoxContext context, Object target) {
        if (target == null) {
            throw new BoxValidationException("Object is null and cannot be serialized");
        }
        if (!(target instanceof Serializable)) {
            throw new BoxValidationException("Object is not serializable");
        }
        context.getRuntime().getInterceptorService().announce(BoxEvent.BEFORE_OBJECT_MARSHALL_SERIALIZE, Struct.of(new Object[]{"object", target}));
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(target);
                oos.flush();
                byte[] result = bos.toByteArray();
                context.getRuntime().getInterceptorService().announce(BoxEvent.AFTER_OBJECT_MARSHALL_SERIALIZE, Struct.of(new Object[]{"binary", result}));
                byArray = result;
            }
            return byArray;
        }
        catch (IOException e) {
            throw new BoxIOException("Failed to serialize object", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(IBoxContext context, byte[] data) {
        if (data == null) {
            throw new BoxValidationException("Byte array is null and cannot be deserialized");
        }
        context.getRuntime().getInterceptorService().announce(BoxEvent.BEFORE_OBJECT_MARSHALL_DESERIALIZE, Struct.of(new Object[]{"binary", data}));
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);){
            Object object;
            try (ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
                Object result = objectInputStream.readObject();
                if (result instanceof BoxClassState) {
                    BoxClassState classState = (BoxClassState)result;
                    IClassRunnable boxClass = (IClassRunnable)ClassLocator.getInstance().load(context, classState.classPath.getName(), "bx", true, context.getCurrentImports()).invokeConstructor(context, Key.noInit).unWrapBoxLangClass();
                    boxClass.getVariablesScope().putAll(classState.variablesScope);
                    boxClass.getThisScope().putAll(classState.thisScope);
                    result = boxClass;
                }
                context.getRuntime().getInterceptorService().announce(BoxEvent.AFTER_OBJECT_MARSHALL_DESERIALIZE, Struct.of(new Object[]{"object", result}));
                object = result;
            }
            return object;
        }
        catch (IOException e) {
            throw new BoxIOException("Failed to deserialize object", e);
        }
        catch (ClassNotFoundException e) {
            throw new BoxRuntimeException("Failed to load the object", e);
        }
    }

    public static Object serializeClass(IClassRunnable target) {
        return new BoxClassState(target);
    }
}

