/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util.conversion.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;

public class BoxArraySerializer
implements ValueWriter {
    private static final ThreadLocal<IdentityHashMap<List<?>, Boolean>> visitedArrays = ThreadLocal.withInitial(IdentityHashMap::new);

    @Override
    public void writeValue(JSONWriter context, JsonGenerator g, Object value) throws IOException {
        List bxArray = (List)value;
        IdentityHashMap<List<?>, Boolean> visited = visitedArrays.get();
        if (visited.containsKey(bxArray)) {
            g.writeString("recursive-array-skipping");
        } else {
            visited.put(bxArray, Boolean.TRUE);
            g.writeStartArray();
            for (Object element : bxArray) {
                context.writeValue(element);
            }
            g.writeEndArray();
            visited.remove(bxArray);
        }
    }

    @Override
    public Class<?> valueType() {
        return List.class;
    }
}

