/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util.conversion.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Property;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.util.BLCollector;

public class BoxClassSerializer
implements ValueWriter {
    private static final Logger logger = LoggerFactory.getLogger(BoxClassSerializer.class);
    private static final ThreadLocal<Set<IClassRunnable>> visitedClasses = ThreadLocal.withInitial(HashSet::new);

    private static Array inflateArray(Object value) {
        if (value instanceof Array) {
            Array castedArray = (Array)value;
            return castedArray;
        }
        return Arrays.stream(StringCaster.cast(value).split(",")).map(String::trim).collect(BLCollector.toArray());
    }

    @Override
    public void writeValue(JSONWriter context, JsonGenerator g, Object value) throws IOException {
        IClassRunnable bxClass = (IClassRunnable)value;
        Map<Key, Property> properties = bxClass.getProperties();
        IStruct classAnnotations = bxClass.getAnnotations();
        VariablesScope variablesScope = bxClass.getVariablesScope();
        IBoxContext boxContext = BoxRuntime.getInstance().getRuntimeContext();
        Set<IClassRunnable> visited = visitedClasses.get();
        if (visited.contains(bxClass)) {
            g.writeString("recursive-class-skipping");
            return;
        }
        if (!BooleanCaster.cast(classAnnotations.getOrDefault(Key.serializable, (Object)true)).booleanValue()) {
            context.writeValue(new Struct());
            return;
        }
        Array classJsonExcludes = BoxClassSerializer.inflateArray(classAnnotations.getOrDefault(Key.jsonExclude, (Object)""));
        if (variablesScope.containsKey(Key.toJSON)) {
            context.writeValue(variablesScope.dereferenceAndInvoke(boxContext, Key.toJSON, new Object[]{context, g, value}, (Boolean)false));
            return;
        }
        IStruct memento = variablesScope.entrySet().stream().filter(entry -> properties.containsKey(entry.getKey())).filter(entry -> {
            Property prop = (Property)properties.get(entry.getKey());
            return !prop.annotations().containsKey(Key.jsonExclude) && classJsonExcludes.findIndex(prop.name(), false) == 0;
        }).filter(entry -> {
            Property prop = (Property)properties.get(entry.getKey());
            return BooleanCaster.cast(prop.annotations().getOrDefault(Key.serializable, (Object)true));
        }).map(entry -> {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            return entry;
        }).collect(BLCollector.toStruct());
        context.writeValue(memento);
        visited.remove(bxClass);
    }

    @Override
    public Class<?> valueType() {
        return IClassRunnable.class;
    }
}

