/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util.conversion.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;

public class BoxStructSerializer
implements ValueWriter {
    private static final ThreadLocal<IdentityHashMap<Map<?, ?>, Boolean>> visitedStructs = ThreadLocal.withInitial(IdentityHashMap::new);

    @Override
    public void writeValue(JSONWriter context, JsonGenerator g, Object value) throws IOException {
        Map bxStruct = (Map)value;
        IdentityHashMap<Map<?, ?>, Boolean> visited = visitedStructs.get();
        if (visited.containsKey(bxStruct)) {
            g.writeString("recursive-struct-skipping");
        } else {
            visited.put(bxStruct, Boolean.TRUE);
            g.writeStartObject();
            for (Map.Entry entry : bxStruct.entrySet()) {
                g.writeFieldName(entry.getKey().toString());
                context.writeValue(entry.getValue());
            }
            g.writeEndObject();
            visited.remove(bxStruct);
        }
    }

    @Override
    public Class<?> valueType() {
        return Map.class;
    }
}

