/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.util.conversion.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.IClassRunnable;

public class DynamicObjectSerializer
implements ValueWriter {
    @Override
    public void writeValue(JSONWriter context, JsonGenerator g, Object value) throws IOException {
        DynamicObject dynamicObject = (DynamicObject)value;
        Object object = dynamicObject.unWrap();
        if (object instanceof IClassRunnable) {
            IClassRunnable bxClass = (IClassRunnable)object;
            context.writeValue(bxClass);
            return;
        }
        object = dynamicObject.unWrap();
        if (object instanceof List) {
            List castedList = (List)object;
            context.writeValue(castedList);
            return;
        }
        object = dynamicObject.unWrap();
        if (object instanceof Map) {
            Map castedMap = (Map)object;
            context.writeValue(castedMap);
            return;
        }
        g.writeStartObject();
        dynamicObject.getFieldsAsStream().filter(field -> Modifier.isPublic(field.getModifiers())).forEach(field -> {
            try {
                g.writeObjectField(field.getName(), dynamicObject.getField(field.getName()).orElse("").toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        g.writeEndObject();
    }

    @Override
    public Class<?> valueType() {
        return DynamicObject.class;
    }
}

