/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.validation;

import java.util.Set;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.validation.DefaultValue;
import ortus.boxlang.runtime.validation.NotImplemented;
import ortus.boxlang.runtime.validation.Required;
import ortus.boxlang.runtime.validation.Type;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.dynamic.Max;
import ortus.boxlang.runtime.validation.dynamic.MaxLength;
import ortus.boxlang.runtime.validation.dynamic.Min;
import ortus.boxlang.runtime.validation.dynamic.MinLength;
import ortus.boxlang.runtime.validation.dynamic.Requires;
import ortus.boxlang.runtime.validation.dynamic.TypeOneOf;
import ortus.boxlang.runtime.validation.dynamic.ValueOneOf;
import ortus.boxlang.runtime.validation.dynamic.ValueRequires;
import ortus.boxlang.runtime.validation.dynamic.ValueRequiresOneOf;

@FunctionalInterface
public interface Validator {
    public static final Validator REQUIRED = new Required();
    public static final Validator NON_EMPTY = new MinLength(1);
    public static final Validator TYPE = new Type();
    public static final Validator DEFAULT_VALUE = new DefaultValue();
    public static final Validator NOT_IMPLEMENTED = new NotImplemented();

    public void validate(IBoxContext var1, Key var2, Validatable var3, IStruct var4);

    public static Validator min(Number min) {
        return new Min(min);
    }

    public static Validator max(Number max) {
        return new Max(max);
    }

    public static Validator maxLength(Number maxLength) {
        return new MaxLength(maxLength);
    }

    public static Validator minLength(Number minLength) {
        return new MinLength(minLength);
    }

    public static Validator requires(Key ... recordNames) {
        return new Requires(Set.of(recordNames));
    }

    public static Validator valueRequires(String value, Key ... recordNames) {
        return new ValueRequires(value, Set.of(recordNames));
    }

    public static Validator valueRequiresOneOf(String value, Key ... recordNames) {
        return new ValueRequiresOneOf(value, Set.of(recordNames));
    }

    public static Validator valueOneOf(String ... validValues) {
        return new ValueOneOf(Set.of(validValues));
    }

    public static Validator typeOneOf(String ... validTypes) {
        return new TypeOneOf(Set.of(validTypes));
    }
}

