/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.validation.dynamic;

import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public class MaxLength
implements Validator {
    private final Number maxLength;

    public MaxLength(Number maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void validate(IBoxContext context, Key caller, Validatable record, IStruct records) {
        if (records.get(record.name()) != null && (double)StringCaster.cast(records.get(record.name())).length() > this.maxLength.doubleValue()) {
            throw new BoxValidationException(caller, record, "cannot be longer than [" + StringCaster.cast(this.maxLength) + "] character(s).");
        }
    }
}

