/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.validation.dynamic;

import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public class MinLength
implements Validator {
    private final Number minLength;

    public MinLength(Number minLength) {
        this.minLength = minLength;
    }

    @Override
    public void validate(IBoxContext context, Key caller, Validatable record, IStruct records) {
        if (records.get(record.name()) != null) {
            Object value = records.get(record.name());
            CastAttempt<Array> arrayAttempt = ArrayCaster.attempt(value);
            if (arrayAttempt.wasSuccessful()) {
                if (((Array)arrayAttempt.getOrFail()).size() < this.minLength.intValue()) {
                    throw new BoxValidationException(caller, record, "cannot be shorter than [" + StringCaster.cast(this.minLength) + "] item" + (this.minLength.intValue() != 1 ? "s" : "") + ".");
                }
                return;
            }
            CastAttempt<IStruct> structAttempt = StructCaster.attempt(value);
            if (structAttempt.wasSuccessful()) {
                if (((IStruct)structAttempt.getOrFail()).size() < this.minLength.intValue()) {
                    throw new BoxValidationException(caller, record, "cannot be shorter than [" + StringCaster.cast(this.minLength) + "] record" + (this.minLength.intValue() != 1 ? "s" : "") + ".");
                }
                return;
            }
            if ((double)StringCaster.cast(records.get(record.name())).length() < this.minLength.doubleValue()) {
                throw new BoxValidationException(caller, record, "cannot be shorter than [" + StringCaster.cast(this.minLength) + "] character(s).");
            }
        }
    }
}

