/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.validation.dynamic;

import java.util.ArrayList;
import java.util.Set;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public class Requires
implements Validator {
    private Set<Key> recordNames;

    public Requires(Set<Key> recordNames) {
        this.recordNames = recordNames;
    }

    @Override
    public void validate(IBoxContext context, Key caller, Validatable record, IStruct records) {
        if (records.containsKey(record.name())) {
            ArrayList<String> missingRecords = new ArrayList<String>();
            for (Key required : this.recordNames) {
                if (records.containsKey(required)) continue;
                missingRecords.add(required.getName());
            }
            if (!missingRecords.isEmpty()) {
                String missingRecordsString = String.join((CharSequence)", ", missingRecords);
                throw new BoxValidationException(caller, record, "requires the following records to be present: " + missingRecordsString);
            }
        }
    }
}

